/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.utils;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.repackage.com.google.common.collect.ImmutableSet;
import org.opensearch.transport.client.Client;

public class MLTaskUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(MLTaskUtils.class);
    public static final ImmutableSet<MLTaskState> TASK_DONE_STATES = ImmutableSet.of(MLTaskState.COMPLETED, MLTaskState.COMPLETED_WITH_ERROR, MLTaskState.FAILED, MLTaskState.CANCELLED);

    public static void updateMLTaskDirectly(String taskId, Map<String, Object> updatedFields, Client client, ActionListener<UpdateResponse> listener) {
        if (taskId == null || taskId.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("Task ID is null or empty"));
            return;
        }
        if (updatedFields == null || updatedFields.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("Updated fields is null or empty"));
            return;
        }
        if (updatedFields.containsKey("state") && !(updatedFields.get("state") instanceof MLTaskState)) {
            listener.onFailure((Exception)new IllegalArgumentException("Invalid task state"));
            return;
        }
        UpdateRequest updateRequest = new UpdateRequest(".plugins-ml-task", taskId);
        HashMap<String, Object> updatedContent = new HashMap<String, Object>(updatedFields);
        updatedContent.put("last_update_time", Instant.now().toEpochMilli());
        updateRequest.doc(updatedContent);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        if (updatedFields.containsKey("state") && TASK_DONE_STATES.contains((Object)((MLTaskState)((Object)updatedFields.get("state"))))) {
            updateRequest.retryOnConflict(3);
        }
        try (ThreadContext.StoredContext context = client.threadPool().getThreadContext().stashContext();){
            client.update(updateRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e) {
            log.error("Failed to update ML task {}", (Object)taskId, (Object)e);
            listener.onFailure(e);
        }
    }
}

