/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.ECDSA;
import software.amazon.cryptography.materialproviders.model.None;

public class SignatureAlgorithm {
    private final ECDSA ECDSA;
    private final None None;

    protected SignatureAlgorithm(BuilderImpl builder) {
        this.ECDSA = builder.ECDSA();
        this.None = builder.None();
    }

    public ECDSA ECDSA() {
        return this.ECDSA;
    }

    public None None() {
        return this.None;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECDSA ECDSA;
        protected None None;

        protected BuilderImpl() {
        }

        protected BuilderImpl(SignatureAlgorithm model) {
            this.ECDSA = model.ECDSA();
            this.None = model.None();
        }

        @Override
        public Builder ECDSA(ECDSA ECDSA2) {
            this.ECDSA = ECDSA2;
            return this;
        }

        @Override
        public ECDSA ECDSA() {
            return this.ECDSA;
        }

        @Override
        public Builder None(None None2) {
            this.None = None2;
            return this;
        }

        @Override
        public None None() {
            return this.None;
        }

        @Override
        public SignatureAlgorithm build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`SignatureAlgorithm` is a Union. A Union MUST have one and only one value set.");
            }
            return new SignatureAlgorithm(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.ECDSA, this.None};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder ECDSA(ECDSA var1);

        public ECDSA ECDSA();

        public Builder None(None var1);

        public None None();

        public SignatureAlgorithm build();
    }
}

