/*
 * Decompiled with CFR 0.152.
 */
package AESEncryption;

import AESEncryption.AES_GCM;
import BoundedInts_Compile.uint8;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.primitives.internaldafny.types.AESDecryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.AESEncryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.OpaqueError;

public abstract class _ExternBase___default {
    public static AESEncryptOutput EncryptionOutputFromByteSeq(DafnySequence<? extends Byte> s, AES__GCM encAlg) {
        long _0_pivot__point = (long)s.cardinalityInt() - (long)encAlg.dtor_tagLength();
        DafnySequence _1_cipherText = s.take(_0_pivot__point);
        DafnySequence _2_authTag = s.drop(_0_pivot__point);
        return AESEncryptOutput.create((DafnySequence<? extends Byte>)_1_cipherText, (DafnySequence<? extends Byte>)_2_authTag);
    }

    public static Result<AESEncryptOutput, Error> AESEncrypt(AESEncryptInput input) {
        Result<AESEncryptOutput, Error> res = Result.Default(AESEncryptOutput._typeDescriptor(), Error._typeDescriptor(), AESEncryptOutput.Default());
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = __default.Need(Error._typeDescriptor(), (long)input.dtor_iv().cardinalityInt() == (long)input.dtor_encAlg().dtor_ivLength() && (long)input.dtor_key().cardinalityInt() == (long)input.dtor_encAlg().dtor_keyLength(), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Request does not match algorithm.")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), AESEncryptOutput._typeDescriptor());
            return res;
        }
        AESEncryptInput _let_tmp_rhs0 = input;
        AES__GCM _1_encAlg = _let_tmp_rhs0._encAlg;
        DafnySequence<? extends Byte> _2_iv = _let_tmp_rhs0._iv;
        DafnySequence<? extends Byte> _3_key = _let_tmp_rhs0._key;
        DafnySequence<? extends Byte> _4_msg = _let_tmp_rhs0._msg;
        DafnySequence<? extends Byte> _5_aad = _let_tmp_rhs0._aad;
        Result<AESEncryptOutput, Error> _6_valueOrError1 = Result.Default(AESEncryptOutput._typeDescriptor(), OpaqueError._typeDescriptor(), AESEncryptOutput.Default());
        Result<AESEncryptOutput, Error> _out0 = AES_GCM.AESEncryptExtern(_1_encAlg, _2_iv, _3_key, _4_msg, _5_aad);
        _6_valueOrError1 = _out0;
        if (_6_valueOrError1.IsFailure(AESEncryptOutput._typeDescriptor(), OpaqueError._typeDescriptor())) {
            res = _6_valueOrError1.PropagateFailure(AESEncryptOutput._typeDescriptor(), OpaqueError._typeDescriptor(), AESEncryptOutput._typeDescriptor());
            return res;
        }
        AESEncryptOutput _7_value = _6_valueOrError1.Extract(AESEncryptOutput._typeDescriptor(), OpaqueError._typeDescriptor());
        Outcome<Error> _8_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _8_valueOrError2 = __default.Need(Error._typeDescriptor(), (long)_7_value.dtor_cipherText().cardinalityInt() == (long)_4_msg.cardinalityInt(), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"AESEncrypt did not return cipherText of expected length")));
        if (_8_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _8_valueOrError2.PropagateFailure(Error._typeDescriptor(), AESEncryptOutput._typeDescriptor());
            return res;
        }
        Outcome<Error> _9_valueOrError3 = Outcome.Default(Error._typeDescriptor());
        _9_valueOrError3 = __default.Need(Error._typeDescriptor(), (long)_7_value.dtor_authTag().cardinalityInt() == (long)_1_encAlg.dtor_tagLength(), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"AESEncryption did not return valid tag")));
        if (_9_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _9_valueOrError3.PropagateFailure(Error._typeDescriptor(), AESEncryptOutput._typeDescriptor());
            return res;
        }
        res = Result.create_Success(AESEncryptOutput._typeDescriptor(), Error._typeDescriptor(), _7_value);
        return res;
    }

    public static Result<DafnySequence<? extends Byte>, Error> AESDecrypt(AESDecryptInput input) {
        Result<DafnySequence<? extends Byte>, Error> res = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Error> _0_valueOrError0 = Outcome.Default(Error._typeDescriptor());
        _0_valueOrError0 = __default.Need(Error._typeDescriptor(), (long)input.dtor_key().cardinalityInt() == (long)input.dtor_encAlg().dtor_keyLength() && (long)input.dtor_iv().cardinalityInt() == (long)input.dtor_encAlg().dtor_ivLength() && (long)input.dtor_authTag().cardinalityInt() == (long)input.dtor_encAlg().dtor_tagLength(), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"Request does not match algorithm.")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        AESDecryptInput _let_tmp_rhs0 = input;
        AES__GCM _1_encAlg = _let_tmp_rhs0._encAlg;
        DafnySequence<? extends Byte> _2_key = _let_tmp_rhs0._key;
        DafnySequence<? extends Byte> _3_cipherTxt = _let_tmp_rhs0._cipherTxt;
        DafnySequence<? extends Byte> _4_authTag = _let_tmp_rhs0._authTag;
        DafnySequence<? extends Byte> _5_iv = _let_tmp_rhs0._iv;
        DafnySequence<? extends Byte> _6_aad = _let_tmp_rhs0._aad;
        Result<DafnySequence, Error> _7_valueOrError1 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), OpaqueError._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, Error> _out0 = AES_GCM.AESDecryptExtern(_1_encAlg, _2_key, _3_cipherTxt, _4_authTag, _5_iv, _6_aad);
        _7_valueOrError1 = _out0;
        if (_7_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), OpaqueError._typeDescriptor())) {
            res = _7_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), OpaqueError._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        DafnySequence _8_value = _7_valueOrError1.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), OpaqueError._typeDescriptor());
        Outcome<Error> _9_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _9_valueOrError2 = __default.Need(Error._typeDescriptor(), (long)_3_cipherTxt.cardinalityInt() == (long)_8_value.cardinalityInt(), Error.create_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)DafnySequence.asString((String)"AESDecrypt did not return plaintext of expected length")));
        if (_9_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _9_valueOrError2.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return res;
        }
        res = Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), _8_value);
        return res;
    }

    public static Result<AESEncryptOutput, Error> CreateAESEncryptExternSuccess(AESEncryptOutput output) {
        return Result.create_Success(AESEncryptOutput._typeDescriptor(), OpaqueError._typeDescriptor(), output);
    }

    public static Result<AESEncryptOutput, Error> CreateAESEncryptExternFailure(Error error) {
        return Result.create_Failure(AESEncryptOutput._typeDescriptor(), OpaqueError._typeDescriptor(), error);
    }

    public static Result<DafnySequence<? extends Byte>, Error> CreateAESDecryptExternSuccess(DafnySequence<? extends Byte> bytes) {
        return Result.create_Success(DafnySequence._typeDescriptor(uint8._typeDescriptor()), OpaqueError._typeDescriptor(), bytes);
    }

    public static Result<DafnySequence<? extends Byte>, Error> CreateAESDecryptExternFailure(Error error) {
        return Result.create_Failure(DafnySequence._typeDescriptor(uint8._typeDescriptor()), OpaqueError._typeDescriptor(), error);
    }

    public String toString() {
        return "AESEncryption._default";
    }
}

