/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeInfoHttp
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeInfoHttp> {
    @Nonnull
    private final List<String> boundAddress;
    @Nullable
    private final String maxContentLength;
    private final long maxContentLengthInBytes;
    @Nonnull
    private final String publishAddress;
    public static final JsonpDeserializer<NodeInfoHttp> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoHttp::setupNodeInfoHttpDeserializer);

    private NodeInfoHttp(Builder builder) {
        this.boundAddress = ApiTypeHelper.unmodifiableRequired(builder.boundAddress, (Object)this, "boundAddress");
        this.maxContentLength = builder.maxContentLength;
        this.maxContentLengthInBytes = ApiTypeHelper.requireNonNull(builder.maxContentLengthInBytes, this, "maxContentLengthInBytes");
        this.publishAddress = ApiTypeHelper.requireNonNull(builder.publishAddress, this, "publishAddress");
    }

    public static NodeInfoHttp of(Function<Builder, ObjectBuilder<NodeInfoHttp>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> boundAddress() {
        return this.boundAddress;
    }

    @Nullable
    public final String maxContentLength() {
        return this.maxContentLength;
    }

    public final long maxContentLengthInBytes() {
        return this.maxContentLengthInBytes;
    }

    @Nonnull
    public final String publishAddress() {
        return this.publishAddress;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bound_address");
        generator.writeStartArray();
        for (String item0 : this.boundAddress) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.maxContentLength != null) {
            generator.writeKey("max_content_length");
            generator.write(this.maxContentLength);
        }
        generator.writeKey("max_content_length_in_bytes");
        generator.write(this.maxContentLengthInBytes);
        generator.writeKey("publish_address");
        generator.write(this.publishAddress);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeInfoHttpDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::boundAddress, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "bound_address");
        op.add(Builder::maxContentLength, JsonpDeserializer.stringDeserializer(), "max_content_length");
        op.add(Builder::maxContentLengthInBytes, JsonpDeserializer.longDeserializer(), "max_content_length_in_bytes");
        op.add(Builder::publishAddress, JsonpDeserializer.stringDeserializer(), "publish_address");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.boundAddress.hashCode();
        result = 31 * result + Objects.hashCode(this.maxContentLength);
        result = 31 * result + Long.hashCode(this.maxContentLengthInBytes);
        result = 31 * result + this.publishAddress.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfoHttp other = (NodeInfoHttp)o;
        return this.boundAddress.equals(other.boundAddress) && Objects.equals(this.maxContentLength, other.maxContentLength) && this.maxContentLengthInBytes == other.maxContentLengthInBytes && this.publishAddress.equals(other.publishAddress);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeInfoHttp> {
        private List<String> boundAddress;
        @Nullable
        private String maxContentLength;
        private Long maxContentLengthInBytes;
        private String publishAddress;

        public Builder() {
        }

        private Builder(NodeInfoHttp o) {
            this.boundAddress = Builder._listCopy(o.boundAddress);
            this.maxContentLength = o.maxContentLength;
            this.maxContentLengthInBytes = o.maxContentLengthInBytes;
            this.publishAddress = o.publishAddress;
        }

        private Builder(Builder o) {
            this.boundAddress = Builder._listCopy(o.boundAddress);
            this.maxContentLength = o.maxContentLength;
            this.maxContentLengthInBytes = o.maxContentLengthInBytes;
            this.publishAddress = o.publishAddress;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder boundAddress(List<String> list) {
            this.boundAddress = Builder._listAddAll(this.boundAddress, list);
            return this;
        }

        @Nonnull
        public final Builder boundAddress(String value, String ... values) {
            this.boundAddress = Builder._listAdd(this.boundAddress, value, values);
            return this;
        }

        @Nonnull
        public final Builder maxContentLength(@Nullable String value) {
            this.maxContentLength = value;
            return this;
        }

        @Nonnull
        public final Builder maxContentLengthInBytes(long value) {
            this.maxContentLengthInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder publishAddress(String value) {
            this.publishAddress = value;
            return this;
        }

        @Override
        @Nonnull
        public NodeInfoHttp build() {
            this._checkSingleUse();
            return new NodeInfoHttp(this);
        }
    }
}

