/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service.categorizer;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.common.cache.Cache;
import org.opensearch.common.cache.CacheBuilder;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.index.Index;
import org.opensearch.plugin.insights.settings.QueryCategorizationSettings;

public class IndicesFieldTypeCache {
    private static final Logger logger = LogManager.getLogger(IndicesFieldTypeCache.class);
    private final Cache<Index, IndexFieldMap> cache;
    private final CounterMetric evictionCount;
    private final CounterMetric entryCount;
    private final CounterMetric weight;

    public IndicesFieldTypeCache(Settings settings) {
        long sizeInBytes = ((ByteSizeValue)QueryCategorizationSettings.SEARCH_QUERY_FIELD_TYPE_CACHE_SIZE_KEY.get(settings)).getBytes();
        CacheBuilder cacheBuilder = CacheBuilder.builder();
        if (sizeInBytes > 0L) {
            cacheBuilder.setMaximumWeight(sizeInBytes).weigher((k, v) -> RamUsageEstimator.sizeOfObject((Object)k) + v.weight());
        }
        this.cache = cacheBuilder.build();
        this.evictionCount = new CounterMetric();
        this.entryCount = new CounterMetric();
        this.weight = new CounterMetric();
    }

    IndexFieldMap getOrInitialize(Index index) {
        try {
            return (IndexFieldMap)this.cache.computeIfAbsent((Object)index, k -> new IndexFieldMap());
        }
        catch (ExecutionException ex) {
            logger.error("Unexpected execution exception while initializing for index " + String.valueOf(index));
            return null;
        }
    }

    public void invalidate(Index index) {
        IndexFieldMap indexFieldMap = (IndexFieldMap)this.cache.get((Object)index);
        if (indexFieldMap != null) {
            this.evictionCount.inc((long)indexFieldMap.fieldTypeMap.size());
            this.entryCount.dec((long)indexFieldMap.fieldTypeMap.size());
            this.weight.dec(indexFieldMap.weight());
        }
        this.cache.invalidate((Object)index);
    }

    public Iterable<Index> keySet() {
        return this.cache.keys();
    }

    public void incrementCountAndWeight(String key, String value) {
        this.entryCount.inc();
        this.weight.inc(RamUsageEstimator.sizeOf((String)key) + RamUsageEstimator.sizeOf((String)value));
    }

    public Long getEvictionCount() {
        return this.evictionCount.count();
    }

    public Long getEntryCount() {
        return this.entryCount.count();
    }

    public Long getWeight() {
        return this.weight.count();
    }

    static class IndexFieldMap {
        private final ConcurrentHashMap<String, String> fieldTypeMap = new ConcurrentHashMap();
        private final CounterMetric weight = new CounterMetric();

        IndexFieldMap() {
        }

        public String get(String fieldName) {
            return this.fieldTypeMap.get(fieldName);
        }

        public boolean putIfAbsent(String key, String value) {
            if (this.fieldTypeMap.putIfAbsent(key, value) == null) {
                this.weight.inc(RamUsageEstimator.sizeOf((String)key) + RamUsageEstimator.sizeOf((String)value));
                return true;
            }
            return false;
        }

        public long weight() {
            return this.weight.count();
        }
    }
}

