/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.interceptors;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public final class UserAgentInterceptor
implements Interceptor {
    private static final String DEFAULT_USER_AGENT_HEADER = "AutoRest-Java";
    private String userAgent = "AutoRest-Java";

    public UserAgentInterceptor withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public UserAgentInterceptor appendUserAgent(String userAgent) {
        this.userAgent = this.userAgent + " " + userAgent;
        return this;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String header = request.header("User-Agent");
        if (header == null) {
            header = DEFAULT_USER_AGENT_HEADER;
        }
        if (!DEFAULT_USER_AGENT_HEADER.equals(this.userAgent)) {
            header = header.equals(DEFAULT_USER_AGENT_HEADER) ? this.userAgent : this.userAgent + " " + header;
        }
        request = chain.request().newBuilder().header("User-Agent", header).build();
        return chain.proceed(request);
    }
}

