/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.beats.AckEncoder;
import org.logstash.beats.BeatsHandler;
import org.logstash.beats.BeatsParser;
import org.logstash.beats.ConnectionHandler;
import org.logstash.beats.IMessageListener;
import org.logstash.beats.MessageListener;
import org.logstash.beats.util.DaemonThreadFactory;
import org.logstash.netty.SslHandlerProvider;

public class Server {
    private static final Logger logger = LogManager.getLogger(Server.class);
    private final int port;
    private final String id;
    private final String host;
    private final int eventLoopThreadCount;
    private final int executorThreadCount;
    private NioEventLoopGroup bossGroup;
    private NioEventLoopGroup workGroup;
    private IMessageListener messageListener = new MessageListener();
    private SslHandlerProvider sslHandlerProvider;
    private BeatsInitializer beatsInitializer;
    private final int clientInactivityTimeoutSeconds;

    public Server(String id, String host, int port, int clientInactivityTimeoutSeconds, int eventLoopThreadCount, int executorThreadCount) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.clientInactivityTimeoutSeconds = clientInactivityTimeoutSeconds;
        this.eventLoopThreadCount = eventLoopThreadCount;
        this.executorThreadCount = executorThreadCount;
    }

    public void setSslHandlerProvider(SslHandlerProvider sslHandlerProvider) {
        this.sslHandlerProvider = sslHandlerProvider;
    }

    public Server listen() throws InterruptedException {
        if (this.workGroup != null) {
            try {
                logger.debug("Shutting down existing worker group before starting");
                this.workGroup.shutdownGracefully().sync();
            }
            catch (Exception e) {
                logger.error("Could not shut down worker group before starting", (Throwable)e);
            }
        }
        this.bossGroup = new NioEventLoopGroup(this.eventLoopThreadCount, DaemonThreadFactory.daemonThreadFactory(this.id + "-bossGroup"));
        this.workGroup = new NioEventLoopGroup(this.eventLoopThreadCount, DaemonThreadFactory.daemonThreadFactory(this.id + "-workGroup"));
        try {
            logger.info("Starting server on port: {}", (Object)this.port);
            this.beatsInitializer = new BeatsInitializer(this.id, this.messageListener, this.clientInactivityTimeoutSeconds, this.executorThreadCount);
            ServerBootstrap server = new ServerBootstrap();
            ((ServerBootstrap)server.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.SO_LINGER, (Object)0).childHandler((ChannelHandler)this.beatsInitializer);
            Channel channel = server.bind(this.host, this.port).sync().channel();
            channel.closeFuture().sync();
        }
        finally {
            this.shutdown();
        }
        return this;
    }

    public void stop() {
        logger.debug("Server shutting down");
        this.shutdown();
        logger.debug("Server stopped");
    }

    private void shutdown() {
        try {
            if (this.bossGroup != null) {
                this.bossGroup.shutdownGracefully().sync();
            }
            if (this.workGroup != null) {
                this.workGroup.shutdownGracefully().sync();
            }
            if (this.beatsInitializer != null) {
                this.beatsInitializer.shutdownEventExecutor();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public IMessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(IMessageListener listener) {
        this.messageListener = listener;
    }

    public boolean isSslEnabled() {
        return this.sslHandlerProvider != null;
    }

    private class BeatsInitializer
    extends ChannelInitializer<SocketChannel> {
        private static final String SSL_HANDLER = "ssl-handler";
        private static final String IDLESTATE_HANDLER = "idlestate-handler";
        private static final String CONNECTION_HANDLER = "connection-handler";
        private static final String BEATS_ACKER = "beats-acker";
        private static final int DEFAULT_IDLESTATEHANDLER_THREAD = 4;
        private static final int IDLESTATE_WRITER_IDLE_TIME_SECONDS = 5;
        private final EventExecutorGroup idleExecutorGroup;
        private final EventExecutorGroup beatsHandlerExecutorGroup;
        private final IMessageListener localMessageListener;
        private final int localClientInactivityTimeoutSeconds;

        BeatsInitializer(String pluginId, IMessageListener messageListener, int clientInactivityTimeoutSeconds, int beatsHandlerThreadCount) {
            this.localMessageListener = messageListener;
            this.localClientInactivityTimeoutSeconds = clientInactivityTimeoutSeconds;
            this.idleExecutorGroup = new DefaultEventExecutorGroup(4, DaemonThreadFactory.daemonThreadFactory(pluginId + "-idleStateHandler"));
            this.beatsHandlerExecutorGroup = new DefaultEventExecutorGroup(beatsHandlerThreadCount, DaemonThreadFactory.daemonThreadFactory(pluginId + "-beatsHandler"));
        }

        public void initChannel(SocketChannel socket) {
            ChannelPipeline pipeline = socket.pipeline();
            if (Server.this.isSslEnabled()) {
                pipeline.addLast(SSL_HANDLER, (ChannelHandler)Server.this.sslHandlerProvider.sslHandlerForChannel(socket));
            }
            pipeline.addLast(this.idleExecutorGroup, IDLESTATE_HANDLER, (ChannelHandler)new IdleStateHandler(this.localClientInactivityTimeoutSeconds, 5, this.localClientInactivityTimeoutSeconds));
            pipeline.addLast(BEATS_ACKER, (ChannelHandler)new AckEncoder());
            pipeline.addLast(CONNECTION_HANDLER, (ChannelHandler)new ConnectionHandler());
            pipeline.addLast(this.beatsHandlerExecutorGroup, new ChannelHandler[]{new BeatsParser(), new BeatsHandler(this.localMessageListener)});
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.warn("Exception caught in channel initializer", cause);
            try {
                this.localMessageListener.onChannelInitializeException(ctx, cause);
            }
            finally {
                super.exceptionCaught(ctx, cause);
            }
        }

        public void shutdownEventExecutor() {
            try {
                this.idleExecutorGroup.shutdownGracefully().sync();
                this.shutdownEventExecutorsWithPendingTasks();
                this.beatsHandlerExecutorGroup.shutdownGracefully().sync();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        private void shutdownEventExecutorsWithPendingTasks() {
            try {
                for (EventExecutor eventExecutor : this.beatsHandlerExecutorGroup) {
                    SingleThreadEventExecutor singleExecutor;
                    if (!(eventExecutor instanceof SingleThreadEventExecutor) || (singleExecutor = (SingleThreadEventExecutor)eventExecutor).pendingTasks() <= 0) continue;
                    singleExecutor.shutdownGracefully().sync();
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

