/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowNode;
import org.apache.derby.impl.sql.compile.WindowReferenceNode;
import org.apache.derby.shared.common.error.StandardException;

public abstract class WindowFunctionNode
extends UnaryOperatorNode {
    private WindowNode window;
    private ResultColumn generatedRC;
    private ColumnReference generatedRef;

    WindowFunctionNode(ValueNode op, String functionName, WindowNode w, ContextManager cm) throws StandardException {
        super(op, functionName, null, cm);
        this.window = w;
    }

    @Override
    public boolean isConstantExpression() {
        return false;
    }

    @Override
    boolean constantExpression(PredicateList whereClause) {
        return false;
    }

    WindowNode getWindow() {
        return this.window;
    }

    void setWindow(WindowDefinitionNode wdn) {
        this.window = wdn;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        if (this.window instanceof WindowReferenceNode) {
            WindowDefinitionNode found = this.definedWindow(fromList.getWindows(), this.window.getName());
            if (found != null) {
                this.window = found;
            } else {
                throw StandardException.newException((String)"42ZC0", (Object[])new Object[]{this.window.getName()});
            }
        }
        return this;
    }

    private WindowDefinitionNode definedWindow(WindowList windows, String name) {
        for (WindowDefinitionNode wdn : windows) {
            if (!wdn.getName().equals(name)) continue;
            return wdn;
        }
        return null;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "window: ");
        this.window.treePrint(depth + 1);
    }

    ValueNode replaceCallsWithColumnReferences(ResultColumnList rcl, int tableNumber) throws StandardException {
        if (this.generatedRef == null) {
            CompilerContext cc = this.getCompilerContext();
            String generatedColName = "SQLCol" + cc.getNextColumnNumber();
            this.generatedRC = new ResultColumn(generatedColName, (ValueNode)this, this.getContextManager());
            this.generatedRC.markGenerated();
            this.generatedRef = new ColumnReference(this.generatedRC.getName(), null, this.getContextManager());
            this.generatedRef.setSource(this.generatedRC);
            this.generatedRef.setNestingLevel(0);
            this.generatedRef.setSourceLevel(0);
            if (tableNumber != -1) {
                this.generatedRef.setTableNumber(tableNumber);
            }
            rcl.addResultColumn(this.generatedRC);
            this.generatedRef.markGeneratedToReplaceWindowFunctionCall();
        } else {
            rcl.addResultColumn(this.generatedRC);
        }
        return this.generatedRef;
    }

    ColumnReference getGeneratedRef() {
        return this.generatedRef;
    }

    ValueNode getNewNullResultExpression() throws StandardException {
        return this.getNullNode(this.getTypeServices());
    }
}

