/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AccessPathImpl;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasCorrelatedCRsVisitor;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class FromTable
extends ResultSetNode
implements Optimizable {
    Properties tableProperties;
    String correlationName;
    TableName corrTableName;
    int tableNumber;
    int level;
    int[] hashKeyColumns;
    int initialCapacity = -1;
    float loadFactor = -1.0f;
    int maxCapacity = -1;
    AccessPathImpl currentAccessPath;
    AccessPathImpl bestAccessPath;
    AccessPathImpl bestSortAvoidancePath;
    AccessPathImpl trulyTheBestAccessPath;
    private int joinStrategyNumber;
    protected String userSpecifiedJoinStrategy;
    protected CostEstimate bestCostEstimate;
    private double perRowUsage = -1.0;
    private boolean considerSortAvoidancePath;
    private HashMap<Object, AccessPathImpl> bestPlanMap;
    protected static final short REMOVE_PLAN = 0;
    protected static final short ADD_PLAN = 1;
    protected static final short LOAD_PLAN = 2;
    protected TableName origTableName;
    private int _mergeTableID = 0;

    FromTable(String correlationName, Properties tableProperties, ContextManager cm) {
        super(cm);
        this.correlationName = correlationName;
        this.tableProperties = tableProperties;
        this.tableNumber = -1;
        this.bestPlanMap = null;
    }

    public String getCorrelationName() {
        return this.correlationName;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        this.updateBestPlanMap((short)1, this);
        CostEstimate singleScanCost = this.estimateCost(predList, null, outerCost, optimizer, rowOrdering);
        this.getCostEstimate(optimizer);
        this.setCostEstimateCost(singleScanCost);
        this.optimizeSubqueries(this.getDataDictionary(), this.getCostEstimate().rowCount());
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, predList, null, outerCost, optimizer, this.getCostEstimate());
        optimizer.considerCost(this, predList, this.getCostEstimate(), outerCost);
        return this.getCostEstimate();
    }

    @Override
    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList predList, RowOrdering rowOrdering) throws StandardException {
        int numStrat = optimizer.getNumberOfJoinStrategies();
        boolean found = false;
        AccessPath ap = this.getCurrentAccessPath();
        if (this.userSpecifiedJoinStrategy != null) {
            if (ap.getJoinStrategy() != null) {
                ap.setJoinStrategy(null);
                found = false;
            } else {
                ap.setJoinStrategy(optimizer.getJoinStrategy(this.userSpecifiedJoinStrategy));
                if (ap.getJoinStrategy() == null) {
                    throw StandardException.newException((String)"42Y56", (Object[])new Object[]{this.userSpecifiedJoinStrategy, this.getBaseTableName()});
                }
                found = true;
            }
        } else if (this.joinStrategyNumber < numStrat) {
            ap.setJoinStrategy(optimizer.getJoinStrategy(this.joinStrategyNumber));
            ++this.joinStrategyNumber;
            found = true;
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceConsideringJoinStrategy(ap.getJoinStrategy(), this.tableNumber);
            }
        }
        this.tellRowOrderingAboutConstantColumns(rowOrdering, predList);
        return found;
    }

    protected boolean canBeOrdered() {
        return false;
    }

    @Override
    public AccessPath getCurrentAccessPath() {
        return this.currentAccessPath;
    }

    @Override
    public AccessPath getBestAccessPath() {
        return this.bestAccessPath;
    }

    @Override
    public AccessPath getBestSortAvoidancePath() {
        return this.bestSortAvoidancePath;
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        return this.trulyTheBestAccessPath;
    }

    @Override
    public void rememberSortAvoidancePath() {
        this.considerSortAvoidancePath = true;
    }

    @Override
    public boolean considerSortAvoidancePath() {
        return this.considerSortAvoidancePath;
    }

    @Override
    public void rememberJoinStrategyAsBest(AccessPath ap) {
        Optimizer opt = ap.getOptimizer();
        ap.setJoinStrategy(this.getCurrentAccessPath().getJoinStrategy());
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceRememberingJoinStrategy(this.getCurrentAccessPath().getJoinStrategy(), this.tableNumber);
        }
        if (ap == this.bestAccessPath) {
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceRememberingBestAccessPathSubstring(ap, this.tableNumber);
            }
        } else if (ap == this.bestSortAvoidancePath) {
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceRememberingBestSortAvoidanceAccessPathSubstring(ap, this.tableNumber);
            }
        } else if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceRememberingBestUnknownAccessPathSubstring(ap, this.tableNumber);
        }
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        SanityManager.THROWASSERT((String)("getTableDescriptor() not expected to be called for " + this.getClass().toString()));
        return null;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return false;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates) throws StandardException {
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        return this;
    }

    @Override
    public boolean isCoveringIndex(ConglomerateDescriptor cd) throws StandardException {
        return false;
    }

    @Override
    public Properties getProperties() {
        return this.tableProperties;
    }

    @Override
    public void setProperties(Properties tableProperties) {
        this.tableProperties = tableProperties;
    }

    @Override
    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.tableProperties == null) {
            return;
        }
        Enumeration<Object> e = this.tableProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.tableProperties.get(key);
            if (key.equals("joinStrategy")) {
                this.userSpecifiedJoinStrategy = StringUtil.SQLToUpperCase(value);
                continue;
            }
            if (key.equals("hashInitialCapacity")) {
                this.initialCapacity = this.getIntProperty(value, key);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException((String)"42Y59", (Object[])new Object[]{String.valueOf(this.initialCapacity)});
            }
            if (key.equals("hashLoadFactor")) {
                try {
                    this.loadFactor = Float.parseFloat(value);
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException((String)"42Y58", (Object[])new Object[]{value, key});
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException((String)"42Y60", (Object[])new Object[]{value});
            }
            if (key.equals("hashMaxCapacity")) {
                this.maxCapacity = this.getIntProperty(value, key);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException((String)"42Y61", (Object[])new Object[]{String.valueOf(this.maxCapacity)});
            }
            throw StandardException.newException((String)"42Y44", (Object[])new Object[]{key, "joinStrategy"});
        }
    }

    @Override
    public String getName() throws StandardException {
        return this.getExposedName();
    }

    @Override
    public String getBaseTableName() {
        return "";
    }

    @Override
    public int convertAbsoluteToRelativeColumnPosition(int absolutePosition) {
        return absolutePosition;
    }

    @Override
    public void updateBestPlanMap(short action, Object planKey) throws StandardException {
        if (action == 0) {
            if (this.bestPlanMap != null) {
                this.bestPlanMap.remove(planKey);
                if (this.bestPlanMap.isEmpty()) {
                    this.bestPlanMap = null;
                }
            }
            return;
        }
        AccessPath bestPath = this.getTrulyTheBestAccessPath();
        AccessPathImpl ap = null;
        if (action == 1) {
            if (bestPath == null) {
                return;
            }
            if (this.bestPlanMap == null) {
                this.bestPlanMap = new HashMap();
            } else {
                ap = this.bestPlanMap.get(planKey);
            }
            if (ap == null) {
                ap = planKey instanceof Optimizer ? new AccessPathImpl((Optimizer)planKey) : new AccessPathImpl(null);
            }
            ap.copy(bestPath);
            this.bestPlanMap.put(planKey, ap);
            return;
        }
        if (this.bestPlanMap == null) {
            return;
        }
        ap = this.bestPlanMap.get(planKey);
        if (ap == null || ap.getCostEstimate() == null) {
            return;
        }
        bestPath.copy(ap);
    }

    @Override
    public void rememberAsBest(int planType, Optimizer optimizer) throws StandardException {
        AccessPath bestPath = null;
        switch (planType) {
            case 1: {
                bestPath = this.getBestAccessPath();
                break;
            }
            case 2: {
                bestPath = this.getBestSortAvoidancePath();
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Invalid plan type " + planType));
            }
        }
        this.getTrulyTheBestAccessPath().copy(bestPath);
        if (!(this instanceof ProjectRestrictNode)) {
            this.updateBestPlanMap((short)1, optimizer);
        } else {
            ProjectRestrictNode prn = (ProjectRestrictNode)this;
            if (!(prn.getChildResult() instanceof Optimizable)) {
                this.updateBestPlanMap((short)1, optimizer);
            }
        }
        if (this.isBaseTable()) {
            DataDictionary dd = this.getDataDictionary();
            TableDescriptor td = this.getTableDescriptor();
            this.getTrulyTheBestAccessPath().initializeAccessPathName(dd, td);
        }
        this.setCostEstimateCost(bestPath.getCostEstimate());
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceRememberingBestAccessPath(bestPath, this.tableNumber, planType);
        }
    }

    @Override
    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        this.resetJoinStrategies(optimizer);
        this.considerSortAvoidancePath = false;
        CostEstimate ce = this.getBestAccessPath().getCostEstimate();
        if (ce != null) {
            ce.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if ((ce = this.getBestSortAvoidancePath().getCostEstimate()) != null) {
            ce.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if (!this.canBeOrdered()) {
            rowOrdering.addUnorderedOptimizable(this);
        }
    }

    protected void resetJoinStrategies(Optimizer optimizer) {
        this.joinStrategyNumber = 0;
        this.getCurrentAccessPath().setJoinStrategy(null);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        SanityManager.THROWASSERT((String)("estimateCost() not expected to be called for " + this.getClass().toString()));
        return null;
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCandidateFinalCostEstimate() != null) {
            return this.getCandidateFinalCostEstimate();
        }
        if (this.getTrulyTheBestAccessPath() == null) {
            this.setCandidateFinalCostEstimate(this.getCostEstimate());
        } else {
            this.setCandidateFinalCostEstimate(this.getTrulyTheBestAccessPath().getCostEstimate());
        }
        return this.getCandidateFinalCostEstimate();
    }

    @Override
    public boolean isBaseTable() {
        return false;
    }

    @Override
    public boolean hasLargeObjectColumns() {
        for (ResultColumn rc : this.getResultColumns()) {
            DataTypeDescriptor type;
            if (!rc.isReferenced() || (type = rc.getType()) == null || !type.getTypeId().isLOBTypeId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMaterializable() throws StandardException {
        HasCorrelatedCRsVisitor visitor = new HasCorrelatedCRsVisitor();
        this.accept(visitor);
        return !visitor.hasCorrelatedCRs();
    }

    @Override
    public boolean supportsMultipleInstantiations() {
        return true;
    }

    @Override
    public int getTableNumber() {
        return this.tableNumber;
    }

    @Override
    public boolean hasTableNumber() {
        return this.tableNumber >= 0;
    }

    @Override
    public boolean forUpdate() {
        return false;
    }

    @Override
    public int initialCapacity() {
        SanityManager.THROWASSERT((String)"Not expected to be called");
        return 0;
    }

    @Override
    public float loadFactor() {
        SanityManager.THROWASSERT((String)"Not expected to be called");
        return 0.0f;
    }

    @Override
    public int maxCapacity(JoinStrategy joinStrategy, int maxMemoryPerTable) throws StandardException {
        return joinStrategy.maxCapacity(this.maxCapacity, maxMemoryPerTable, this.getPerRowUsage());
    }

    private double getPerRowUsage() throws StandardException {
        if (this.perRowUsage < 0.0) {
            FormatableBitSet refCols = this.getResultColumns().getReferencedFormatableBitSet(this.cursorTargetTable(), true, false);
            this.perRowUsage = 0.0;
            for (int i = 0; i < refCols.size(); ++i) {
                ResultColumn rc;
                DataTypeDescriptor expressionType;
                if (!refCols.isSet(i) || (expressionType = (rc = (ResultColumn)this.getResultColumns().elementAt(i)).getExpression().getTypeServices()) == null) continue;
                this.perRowUsage += expressionType.estimatedMemoryUsage();
            }
            ConglomerateDescriptor cd = this.getCurrentAccessPath().getConglomerateDescriptor();
            if (cd != null && cd.isIndex() && !this.isCoveringIndex(cd)) {
                this.perRowUsage += 12.0;
            }
        }
        return this.perRowUsage;
    }

    @Override
    public int[] hashKeyColumns() {
        SanityManager.ASSERT((this.hashKeyColumns != null ? 1 : 0) != 0, (String)"hashKeyColumns expected to be non-null");
        return this.hashKeyColumns;
    }

    @Override
    public void setHashKeyColumns(int[] columnNumbers) {
        this.hashKeyColumns = columnNumbers;
    }

    @Override
    public boolean feasibleJoinStrategy(OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        return this.getCurrentAccessPath().getJoinStrategy().feasible(this, predList, optimizer);
    }

    @Override
    public boolean memoryUsageOK(double rowCount, int maxMemoryPerTable) throws StandardException {
        if (this.userSpecifiedJoinStrategy != null) {
            return true;
        }
        int intRowCount = rowCount > 2.147483647E9 ? Integer.MAX_VALUE : (int)rowCount;
        return intRowCount <= this.maxCapacity(this.getCurrentAccessPath().getJoinStrategy(), maxMemoryPerTable);
    }

    void isJoinColumnForRightOuterJoin(ResultColumn rc) {
    }

    @Override
    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        return true;
    }

    @Override
    public int getNumColumnsReturned() {
        return this.getResultColumns().size();
    }

    @Override
    public boolean isTargetTable() {
        return false;
    }

    @Override
    public boolean isOneRowScan() throws StandardException {
        return this.isOneRowResultSet();
    }

    @Override
    public void initAccessPaths(Optimizer optimizer) {
        if (this.currentAccessPath == null) {
            this.currentAccessPath = new AccessPathImpl(optimizer);
        }
        if (this.bestAccessPath == null) {
            this.bestAccessPath = new AccessPathImpl(optimizer);
        }
        if (this.bestSortAvoidancePath == null) {
            this.bestSortAvoidancePath = new AccessPathImpl(optimizer);
        }
        if (this.trulyTheBestAccessPath == null) {
            this.trulyTheBestAccessPath = new AccessPathImpl(optimizer);
        }
    }

    @Override
    public double uniqueJoin(OptimizablePredicateList predList) throws StandardException {
        return -1.0;
    }

    String getUserSpecifiedJoinStrategy() {
        if (this.tableProperties == null) {
            return null;
        }
        return this.tableProperties.getProperty("joinStrategy");
    }

    protected boolean cursorTargetTable() {
        return false;
    }

    protected CostEstimate getCostEstimate(Optimizer optimizer) {
        if (this.getCostEstimate() == null) {
            this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        }
        return this.getCostEstimate();
    }

    protected CostEstimate getScratchCostEstimate(Optimizer optimizer) {
        if (this.getScratchCostEstimate() == null) {
            this.setScratchCostEstimate(this.getOptimizerFactory().getCostEstimate());
        }
        return this.getScratchCostEstimate();
    }

    protected void setCostEstimateCost(CostEstimate newCostEstimate) {
        this.getCostEstimate().setCost(newCostEstimate);
    }

    protected void assignCostEstimate(CostEstimate newCostEstimate) {
        this.setCostEstimate(newCostEstimate);
    }

    @Override
    public String toString() {
        return "correlation Name: " + this.correlationName + "\n" + (this.corrTableName != null ? this.corrTableName.toString() : "null") + "\ntableNumber " + this.tableNumber + "\nlevel " + this.level + "\n" + super.toString();
    }

    ResultColumnList getResultColumnsForList(TableName allTableName, ResultColumnList inputRcl, TableName tableName) throws StandardException {
        TableName toCompare = this.correlationName == null ? tableName : (allTableName != null ? this.makeTableName(allTableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName));
        if (allTableName != null && !allTableName.equals(toCompare)) {
            return null;
        }
        TableName exposedName = this.correlationName == null ? tableName : this.makeTableName(null, this.correlationName);
        ContextManager cm = this.getContextManager();
        ResultColumnList rcList = new ResultColumnList(cm);
        for (ResultColumn rc : inputRcl) {
            ColumnReference oldCR = rc.getReference();
            if (oldCR != null && oldCR.getMergeTableID() != 0) {
                exposedName = oldCR.getQualifiedTableName();
            }
            ColumnReference newCR = new ColumnReference(rc.getName(), exposedName, cm);
            if (oldCR != null && oldCR.getMergeTableID() != 0) {
                newCR.setMergeTableID(oldCR.getMergeTableID());
            }
            ResultColumn newRc = new ResultColumn(rc.getName(), (ValueNode)newCR, cm);
            rcList.addResultColumn(newRc);
        }
        return rcList;
    }

    void pushExpressions(PredicateList predicateList) throws StandardException {
        SanityManager.ASSERT((predicateList != null ? 1 : 0) != 0, (String)"predicateList is expected to be non-null");
    }

    String getExposedName() throws StandardException {
        SanityManager.THROWASSERT((String)("getExposedName() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    void setTableNumber(int tableNumber) {
        SanityManager.ASSERT((this.tableNumber == -1 ? 1 : 0) != 0, (String)"tableNumber is not expected to be already set");
        this.tableNumber = tableNumber;
    }

    TableName getTableName() throws StandardException {
        if (this.correlationName == null) {
            return null;
        }
        if (this.corrTableName == null) {
            this.corrTableName = this.makeTableName(null, this.correlationName);
        }
        return this.corrTableName;
    }

    void setLevel(int level) {
        this.level = level;
    }

    int getLevel() {
        return this.level;
    }

    @Override
    void decrementLevel(int decrement) {
        if (this.level < decrement && this.level != 0) {
            SanityManager.THROWASSERT((String)("level (" + this.level + ") expected to be >= decrement (" + decrement + ")"));
        }
        if (this.level > 0) {
            this.level -= decrement;
        }
    }

    SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.getSchemaDescriptor(this.corrTableName);
    }

    SchemaDescriptor getSchemaDescriptor(TableName tableName) throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor(tableName.getSchemaName());
        return sd;
    }

    @Override
    FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        if (schemaName != null) {
            return null;
        }
        if (this.getExposedName().equals(name)) {
            return this;
        }
        return null;
    }

    boolean isFlattenableJoinNode() {
        return false;
    }

    boolean LOJ_reorderable(int numTables) throws StandardException {
        return false;
    }

    FromTable transformOuterJoins(ValueNode predicateTree, int numTables) throws StandardException {
        return this;
    }

    @Override
    void fillInReferencedTableMap(JBitSet passedMap) {
        if (this.tableNumber != -1) {
            passedMap.set(this.tableNumber);
        }
    }

    protected void markUpdatableByCursor(List<String> updateColumns) {
        this.getResultColumns().markUpdatableByCursor(updateColumns);
    }

    boolean columnsAreUpdatable() {
        return this.getResultColumns().columnsAreUpdatable();
    }

    FromList flatten(ResultColumnList rcl, PredicateList outerPList, SubqueryList sql, GroupByList gbl, ValueNode havingClause) throws StandardException {
        SanityManager.THROWASSERT((String)("flatten() not expected to be called for " + String.valueOf(this)));
        return null;
    }

    void optimizeSubqueries(DataDictionary dd, double rowCount) throws StandardException {
    }

    protected void tellRowOrderingAboutConstantColumns(RowOrdering rowOrdering, OptimizablePredicateList predList) {
        if (predList != null) {
            for (int i = 0; i < predList.size(); ++i) {
                ColumnReference cr;
                Predicate pred = (Predicate)predList.getOptPredicate(i);
                if (!pred.equalsComparisonWithConstantExpression(this) || (cr = pred.getRelop().getColumnOperand(this)) == null) continue;
                rowOrdering.columnAlwaysOrdered(this, cr.getColumnNumber());
            }
        }
    }

    boolean needsSpecialRCLBinding() {
        return false;
    }

    void setOrigTableName(TableName tableName) {
        this.origTableName = tableName;
    }

    TableName getOrigTableName() {
        return this.origTableName;
    }

    void setMergeTableID(int mergeTableID) {
        this._mergeTableID = mergeTableID;
    }

    int getMergeTableID() {
        return this._mergeTableID;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.origTableName != null) {
            this.origTableName = (TableName)this.origTableName.accept(v);
        }
        if (this.corrTableName != null) {
            this.corrTableName = (TableName)this.corrTableName.accept(v);
        }
    }
}

