/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.impl.io.CPStorageFactory;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.io.StorageFile;

class CPFile
extends InputStreamFile<CPStorageFactory> {
    CPFile(CPStorageFactory storageFactory, String path) {
        super(storageFactory, path);
    }

    CPFile(CPStorageFactory storageFactory, String parent, String name) {
        super(storageFactory, parent, name);
    }

    CPFile(CPFile dir, String name) {
        super(dir, name);
    }

    private CPFile(CPStorageFactory storageFactory, String child, int pathLen) {
        super(storageFactory, child, pathLen);
    }

    @Override
    public boolean exists() {
        return this.getURL() != null;
    }

    @Override
    StorageFile getParentDir(int pathLen) {
        return new CPFile((CPStorageFactory)this.storageFactory, this.path, pathLen);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        InputStream is = null;
        ClassLoader cl = CPFile.getContextClassLoader(Thread.currentThread());
        if (cl != null) {
            is = CPFile.getResourceAsStream(cl, this.path);
        }
        if (is == null) {
            cl = this.getClass().getClassLoader();
            is = cl != null ? CPFile.getResourceAsStream(cl, this.path) : CPFile.getSystemResourceAsStream(this.path);
        }
        if (is == null) {
            throw new FileNotFoundException(this.toString());
        }
        return is;
    }

    private URL getURL() {
        URL myURL;
        ClassLoader cl = CPFile.getContextClassLoader(Thread.currentThread());
        if (cl != null && (myURL = CPFile.getResource(cl, this.path)) != null) {
            return myURL;
        }
        cl = this.getClass().getClassLoader();
        if (cl != null) {
            return CPFile.getResource(cl, this.path);
        }
        return CPFile.getSystemResource(this.path);
    }

    private static ClassLoader getContextClassLoader(final Thread thread) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return thread.getContextClassLoader();
            }
        });
    }

    private static URL getResource(final ClassLoader cl, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return cl.getResource(name);
            }
        });
    }

    private static URL getSystemResource(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ClassLoader.getSystemResource(name);
            }
        });
    }

    private static InputStream getResourceAsStream(final ClassLoader cl, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return cl.getResourceAsStream(name);
            }
        });
    }

    private static InputStream getSystemResourceAsStream(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
    }
}

