/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class CompressedNumber {
    public static final int MAX_INT_STORED_SIZE = 4;
    public static final int MAX_LONG_STORED_SIZE = 8;
    public static final int MAX_COMPRESSED_INT_ONE_BYTE = 63;
    public static final int MAX_COMPRESSED_INT_TWO_BYTES = 16383;

    public static final int writeInt(DataOutput out, int value) throws IOException {
        if (value < 0) {
            throw new IOException();
        }
        if (value <= 63) {
            out.writeByte(value);
            return 1;
        }
        if (value <= 16383) {
            out.writeByte(0x40 | value >>> 8);
            out.writeByte(value & 0xFF);
            return 2;
        }
        out.writeByte((value >>> 24 | 0x80) & 0xFF);
        out.writeByte(value >>> 16 & 0xFF);
        out.writeByte(value >>> 8 & 0xFF);
        out.writeByte(value & 0xFF);
        return 4;
    }

    public static final int writeInt(OutputStream out, int value) throws IOException {
        if (value < 0) {
            throw new IOException();
        }
        if (value <= 63) {
            out.write(value);
            return 1;
        }
        if (value <= 16383) {
            out.write(0x40 | value >>> 8);
            out.write(value & 0xFF);
            return 2;
        }
        out.write((value >>> 24 | 0x80) & 0xFF);
        out.write(value >>> 16 & 0xFF);
        out.write(value >>> 8 & 0xFF);
        out.write(value & 0xFF);
        return 4;
    }

    public static final int readInt(DataInput in) throws IOException {
        int value = in.readUnsignedByte();
        if ((value & 0xFFFFFFC0) == 0) {
            return value;
        }
        if ((value & 0x80) == 0) {
            SanityManager.ASSERT(((value & 0x40) == 64 ? 1 : 0) != 0);
            return (value & 0x3F) << 8 | in.readUnsignedByte();
        }
        SanityManager.ASSERT(((value & 0x80) == 128 ? 1 : 0) != 0);
        return (value & 0x7F) << 24 | in.readUnsignedByte() << 16 | in.readUnsignedByte() << 8 | in.readUnsignedByte();
    }

    public static final int readInt(InputStream in) throws IOException {
        int value = InputStreamUtil.readUnsignedByte(in);
        if ((value & 0xFFFFFFC0) == 0) {
            return value;
        }
        if ((value & 0x80) == 0) {
            return (value & 0x3F) << 8 | InputStreamUtil.readUnsignedByte(in);
        }
        return (value & 0x7F) << 24 | InputStreamUtil.readUnsignedByte(in) << 16 | InputStreamUtil.readUnsignedByte(in) << 8 | InputStreamUtil.readUnsignedByte(in);
    }

    public static final int readInt(byte[] data, int offset) {
        byte value;
        if (((value = data[offset++]) & 0xFFFFFFC0) == 0) {
            return value;
        }
        if ((value & 0x80) == 0) {
            SanityManager.ASSERT(((value & 0x40) == 64 ? 1 : 0) != 0);
            return (value & 0x3F) << 8 | data[offset] & 0xFF;
        }
        SanityManager.ASSERT(((value & 0x80) == 128 ? 1 : 0) != 0);
        return (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
    }

    public static final int sizeInt(int value) {
        if (value <= 63) {
            return 1;
        }
        if (value <= 16383) {
            return 2;
        }
        return 4;
    }

    public static final int writeLong(DataOutput out, long value) throws IOException {
        if (value < 0L) {
            throw new IOException();
        }
        if (value <= 16383L) {
            out.writeByte((int)(value >>> 8 & 0xFFL));
            out.writeByte((int)(value & 0xFFL));
            return 2;
        }
        if (value <= 0x3FFFFFFFL) {
            out.writeByte((int)((value >>> 24 | 0x40L) & 0xFFL));
            out.writeByte((int)(value >>> 16 & 0xFFL));
            out.writeByte((int)(value >>> 8 & 0xFFL));
            out.writeByte((int)(value & 0xFFL));
            return 4;
        }
        out.writeByte((int)((value >>> 56 | 0x80L) & 0xFFL));
        out.writeByte((int)(value >>> 48 & 0xFFL));
        out.writeByte((int)(value >>> 40 & 0xFFL));
        out.writeByte((int)(value >>> 32 & 0xFFL));
        out.writeByte((int)(value >>> 24 & 0xFFL));
        out.writeByte((int)(value >>> 16 & 0xFFL));
        out.writeByte((int)(value >>> 8 & 0xFFL));
        out.writeByte((int)(value & 0xFFL));
        return 8;
    }

    public static final int writeLong(OutputStream out, long value) throws IOException {
        if (value < 0L) {
            throw new IOException();
        }
        if (value <= 16383L) {
            out.write((int)(value >>> 8 & 0xFFL));
            out.write((int)(value & 0xFFL));
            return 2;
        }
        if (value <= 0x3FFFFFFFL) {
            out.write((int)((value >>> 24 | 0x40L) & 0xFFL));
            out.write((int)(value >>> 16 & 0xFFL));
            out.write((int)(value >>> 8 & 0xFFL));
            out.write((int)(value & 0xFFL));
            return 4;
        }
        out.write((int)((value >>> 56 | 0x80L) & 0xFFL));
        out.write((int)(value >>> 48 & 0xFFL));
        out.write((int)(value >>> 40 & 0xFFL));
        out.write((int)(value >>> 32 & 0xFFL));
        out.write((int)(value >>> 24 & 0xFFL));
        out.write((int)(value >>> 16 & 0xFFL));
        out.write((int)(value >>> 8 & 0xFFL));
        out.write((int)(value & 0xFFL));
        return 8;
    }

    public static final long readLong(DataInput in) throws IOException {
        int int_value = in.readUnsignedByte();
        if ((int_value & 0xFFFFFFC0) == 0) {
            return int_value << 8 | in.readUnsignedByte();
        }
        if ((int_value & 0x80) == 0) {
            return (int_value & 0x3F) << 24 | in.readUnsignedByte() << 16 | in.readUnsignedByte() << 8 | in.readUnsignedByte();
        }
        return (long)(int_value & 0x7F) << 56 | (long)in.readUnsignedByte() << 48 | (long)in.readUnsignedByte() << 40 | (long)in.readUnsignedByte() << 32 | (long)in.readUnsignedByte() << 24 | (long)in.readUnsignedByte() << 16 | (long)in.readUnsignedByte() << 8 | (long)in.readUnsignedByte();
    }

    public static final long readLong(InputStream in) throws IOException {
        int int_value = InputStreamUtil.readUnsignedByte(in);
        if ((int_value & 0xFFFFFFC0) == 0) {
            return int_value << 8 | InputStreamUtil.readUnsignedByte(in);
        }
        if ((int_value & 0x80) == 0) {
            return (int_value & 0x3F) << 24 | InputStreamUtil.readUnsignedByte(in) << 16 | InputStreamUtil.readUnsignedByte(in) << 8 | InputStreamUtil.readUnsignedByte(in);
        }
        long value = int_value;
        return (value & 0x7FL) << 56 | (long)InputStreamUtil.readUnsignedByte(in) << 48 | (long)InputStreamUtil.readUnsignedByte(in) << 40 | (long)InputStreamUtil.readUnsignedByte(in) << 32 | (long)InputStreamUtil.readUnsignedByte(in) << 24 | (long)InputStreamUtil.readUnsignedByte(in) << 16 | (long)InputStreamUtil.readUnsignedByte(in) << 8 | (long)InputStreamUtil.readUnsignedByte(in);
    }

    public static final long readLong(byte[] data, int offset) {
        byte int_value;
        if (((int_value = data[offset++]) & 0xFFFFFFC0) == 0) {
            return int_value << 8 | data[offset] & 0xFF;
        }
        if ((int_value & 0x80) == 0) {
            return (int_value & 0x3F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
        }
        return (long)(int_value & 0x7F) << 56 | (long)(data[offset++] & 0xFF) << 48 | (long)(data[offset++] & 0xFF) << 40 | (long)(data[offset++] & 0xFF) << 32 | (long)(data[offset++] & 0xFF) << 24 | (long)(data[offset++] & 0xFF) << 16 | (long)(data[offset++] & 0xFF) << 8 | (long)(data[offset] & 0xFF);
    }

    public static final int sizeLong(long value) {
        if (value <= 16383L) {
            return 2;
        }
        if (value <= 0x3FFFFFFFL) {
            return 4;
        }
        return 8;
    }
}

