/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ScanResultSet;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class LastIndexKeyResultSet
extends ScanResultSet {
    protected long conglomId;
    protected int startSearchOperator;
    protected int stopSearchOperator;
    protected Qualifier[][] qualifiers;
    public String userSuppliedOptimizerOverrides;
    protected boolean runTimeStatisticsOn;
    public String stopPositionString;
    public boolean coarserLock;
    public boolean returnedRow;

    public LastIndexKeyResultSet(Activation activation, int resultSetNumber, int resultRowTemplate, long conglomId, String tableName, String userSuppliedOptimizerOverrides, String indexName, int colRefItem, int lockMode, boolean tableLocked, int isolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, resultRowTemplate, lockMode, tableLocked, isolationLevel, colRefItem, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.conglomId = conglomId;
        SanityManager.ASSERT((activation != null ? 1 : 0) != 0, (String)"this scan must get activation context");
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = indexName;
        this.runTimeStatisticsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        if (SanityManager.DEBUG_ON((String)"ScanTrace")) {
            // empty if block
        }
        activation.informOfRowCount(this, 1L);
        this.recordConstructorTime();
    }

    @Override
    boolean canGetInstantaneousLocks() {
        return true;
    }

    @Override
    public void openCore() throws StandardException {
        ExecRow candidateCopy = this.candidate.getClone();
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"LastIndexKeyResultSet already open");
        this.isOpen = true;
        TransactionController tc = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (tc.fetchMaxOnBtree(this.conglomId, 0, this.lockMode, this.isolationLevel, this.accessedCols, candidateCopy.getRowArray())) {
            this.setCurrentRow(this.getCompactRow(candidateCopy, this.accessedCols, true));
        } else {
            this.clearCurrentRow();
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (this.returnedRow || !this.isOpen) {
            this.clearCurrentRow();
        } else {
            this.returnedRow = true;
        }
        return this.currentRow;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.isOpen = false;
            this.returnedRow = false;
            this.clearCurrentRow();
            super.close();
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of LastIndexKeyResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime;
        }
        return totTime;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }
}

