/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.database.jpa;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.runtime.configuration.DurationConverter;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.io.File;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.ServerStartupError;
import org.keycloak.common.Version;
import org.keycloak.config.DatabaseOptions;
import org.keycloak.config.database.Database;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.migration.MigrationModelManager;
import org.keycloak.migration.ModelVersion;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.dblock.DBLockManager;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.storage.database.jpa.AbstractJpaConnectionProviderFactory;

public class QuarkusJpaConnectionProviderFactory
extends AbstractJpaConnectionProviderFactory
implements ServerInfoAwareProviderFactory {
    public static final String QUERY_PROPERTY_PREFIX = "kc.query.";
    public static final String DEFAULT_PERSISTENCE_UNIT = "keycloak-default";
    private static final Logger logger = Logger.getLogger(QuarkusJpaConnectionProviderFactory.class);
    private static final String SQL_GET_LATEST_VERSION = "SELECT ID, VERSION FROM %sMIGRATION_MODEL ORDER BY UPDATE_TIME DESC";
    private Map<String, String> operationalInfo;

    public String getId() {
        return "quarkus";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSpecificNamedQueries(KeycloakSession session) {
        EntityManager em = this.createEntityManager(this.entityManagerFactory, session, false);
        try {
            Map unitProperties = this.entityManagerFactory.getProperties();
            for (Map.Entry entry : unitProperties.entrySet()) {
                if (!((String)entry.getKey()).startsWith(QUERY_PROPERTY_PREFIX)) continue;
                JpaUtils.configureNamedQuery((String)((String)entry.getKey()).substring(QUERY_PROPERTY_PREFIX.length()), (String)entry.getValue().toString(), (EntityManager)em);
            }
        }
        finally {
            JpaUtils.closeEntityManager((EntityManager)em);
        }
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        boolean schemaChanged;
        super.postInit(factory);
        this.checkMySQLWaitTimeout();
        this.checkMSSQLIsolationLevel();
        String id = null;
        String version = null;
        String schema = this.getSchema();
        try (Connection connection = this.getConnection();
             KeycloakSession session = factory.create();){
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery(String.format(SQL_GET_LATEST_VERSION, this.getSchema(schema)));){
                if (rs.next()) {
                    id = rs.getString(1);
                    version = rs.getString(2);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.createOperationalInfo(connection);
            this.addSpecificNamedQueries(session);
            schemaChanged = this.createOrUpdateSchema(schema, version, connection, session);
        }
        catch (SQLException cause) {
            throw new RuntimeException("Failed to update database.", cause);
        }
        if (schemaChanged || Environment.isNonServerMode()) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, this::initSchema);
        } else {
            Version.RESOURCES_VERSION = id;
        }
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("initializeEmpty").type("boolean").helpText("Initialize database if empty. If set to false the database has to be manually initialized. If you want to manually initialize the database set migrationStrategy to manual which will create a file with SQL commands to initialize the database.").defaultValue((Object)true).add().property().name("migrationStrategy").type("string").helpText("Strategy to use to migrate database. Valid values are update, manual and validate. Update will automatically migrate the database schema. Manual will export the required changes to a file with SQL commands that you can manually execute on the database. Validate will simply check if the database is up-to-date.").options(new String[]{"update", "manual", "validate"}).defaultValue((Object)"update").add().property().name("migrationExport").type("string").helpText("Path for where to write manual database initialization/migration file.").add().build();
    }

    @Override
    protected EntityManagerFactory getEntityManagerFactory() {
        InjectableInstance instance = Arc.container().select(EntityManagerFactory.class, new Annotation[0]);
        if (instance.isResolvable()) {
            return (EntityManagerFactory)instance.get();
        }
        return this.getEntityManagerFactory(DEFAULT_PERSISTENCE_UNIT).orElseThrow(() -> new IllegalStateException("Failed to resolve the default entity manager factory"));
    }

    public Map<String, String> getOperationalInfo() {
        return this.operationalInfo;
    }

    public int order() {
        return 100;
    }

    private MigrationStrategy getMigrationStrategy() {
        String migrationStrategy = this.config.get("migrationStrategy");
        if (migrationStrategy == null) {
            migrationStrategy = this.config.get("databaseSchema");
        }
        if (migrationStrategy != null) {
            return MigrationStrategy.valueOf(migrationStrategy.toUpperCase());
        }
        return MigrationStrategy.UPDATE;
    }

    private void initSchema(KeycloakSession session) {
        logger.debug((Object)"Calling migrateModel");
        this.migrateModel(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateModel(KeycloakSession session) {
        DBLockManager dbLockManager = new DBLockManager(session);
        DBLockProvider dbLock = dbLockManager.getDBLock();
        dbLock.waitForLock(DBLockProvider.Namespace.DATABASE);
        try {
            MigrationModelManager.migrate((KeycloakSession)session);
        }
        finally {
            dbLock.releaseLock();
        }
    }

    private String getSchema(String schema) {
        return schema == null ? "" : schema + ".";
    }

    private File getDatabaseUpdateFile() {
        String databaseUpdateFile = this.config.get("migrationExport", "keycloak-database-update.sql");
        return new File(databaseUpdateFile);
    }

    private void createOperationalInfo(Connection connection) {
        try {
            this.operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            this.operationalInfo.put("databaseUrl", md.getURL());
            this.operationalInfo.put("databaseUser", md.getUserName());
            this.operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            this.operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
            logger.debugf("Database info: %s", (Object)this.operationalInfo.toString());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    private boolean createOrUpdateSchema(String schema, String version, Connection connection, KeycloakSession session) {
        MigrationStrategy strategy = this.getMigrationStrategy();
        boolean initializeEmpty = this.config.getBoolean("initializeEmpty", Boolean.valueOf(true));
        File databaseUpdateFile = this.getDatabaseUpdateFile();
        JpaUpdaterProvider updater = (JpaUpdaterProvider)session.getProvider(JpaUpdaterProvider.class);
        boolean requiresMigration = version == null || !version.equals(new ModelVersion(Version.VERSION).toString());
        session.setAttribute("VERIFY_AND_RUN_MASTER_CHANGELOG", (Object)requiresMigration);
        JpaUpdaterProvider.Status status = updater.validate(connection, schema);
        if (status == JpaUpdaterProvider.Status.VALID) {
            logger.debug((Object)"Database is up-to-date");
        } else if (status == JpaUpdaterProvider.Status.EMPTY) {
            if (initializeEmpty) {
                this.update(connection, schema, session, updater);
            } else {
                switch (strategy) {
                    case UPDATE: {
                        this.update(connection, schema, session, updater);
                        break;
                    }
                    case MANUAL: {
                        this.export(connection, schema, databaseUpdateFile, session, updater);
                        throw new ServerStartupError("Database not initialized, please initialize database with " + databaseUpdateFile.getAbsolutePath(), false);
                    }
                    case VALIDATE: {
                        throw new ServerStartupError("Database not initialized, please enable database initialization", false);
                    }
                }
            }
        } else {
            switch (strategy) {
                case UPDATE: {
                    this.update(connection, schema, session, updater);
                    break;
                }
                case MANUAL: {
                    this.export(connection, schema, databaseUpdateFile, session, updater);
                    throw new ServerStartupError("Database not up-to-date, please migrate database with " + databaseUpdateFile.getAbsolutePath(), false);
                }
                case VALIDATE: {
                    throw new ServerStartupError("Database not up-to-date, please enable database migration", false);
                }
            }
        }
        return requiresMigration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection connection, String schema, KeycloakSession session, JpaUpdaterProvider updater) {
        DBLockManager dbLockManager = new DBLockManager(session);
        DBLockProvider dbLock2 = dbLockManager.getDBLock();
        dbLock2.waitForLock(DBLockProvider.Namespace.DATABASE);
        try {
            updater.update(connection, schema);
        }
        finally {
            dbLock2.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(Connection connection, String schema, File databaseUpdateFile, KeycloakSession session, JpaUpdaterProvider updater) {
        DBLockManager dbLockManager = new DBLockManager(session);
        DBLockProvider dbLock2 = dbLockManager.getDBLock();
        dbLock2.waitForLock(DBLockProvider.Namespace.DATABASE);
        try {
            updater.export(connection, schema, databaseUpdateFile);
        }
        finally {
            dbLock2.releaseLock();
        }
    }

    private void checkMySQLWaitTimeout() {
        String db = Configuration.getConfigValue(DatabaseOptions.DB).getValue();
        Database.Vendor vendor = (Database.Vendor)Database.getVendor((String)db).orElseThrow();
        if (Database.Vendor.MYSQL != vendor && Database.Vendor.MARIADB != vendor) {
            return;
        }
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("SHOW VARIABLES LIKE 'wait_timeout'");){
            if (rs.next()) {
                int waitTimeout = rs.getInt(2);
                Duration poolMaxLifetime = DurationConverter.parseDuration((String)Configuration.getConfigValue(DatabaseOptions.DB_POOL_MAX_LIFETIME).getValue());
                if (poolMaxLifetime.getSeconds() >= (long)waitTimeout) {
                    logger.warnf("%1$s 'wait_timeout=%2$d' is less than or equal to the configured '%3$s' duration. This can cause 'No operations allowed after connection closed' exceptions, which can impact Keycloak operations. To avoid such issues, set '%3$s' to a duration smaller than '%2$d' seconds.", new Object[]{vendor, waitTimeout, DatabaseOptions.DB_POOL_MAX_LIFETIME.getKey(), poolMaxLifetime});
                }
            }
        }
        catch (SQLException e) {
            logger.warnf((Throwable)e, "Unable to validate %s 'wait_timeout' due to database exception", (Object)vendor);
        }
    }

    private void checkMSSQLIsolationLevel() {
        String db = Configuration.getConfigValue(DatabaseOptions.DB).getValue();
        Database.Vendor vendor = (Database.Vendor)Database.getVendor((String)db).orElseThrow();
        if (Database.Vendor.MSSQL != vendor) {
            return;
        }
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();
             Statement statement2 = connection.createStatement();
             ResultSet rs = statement.executeQuery("DBCC USEROPTIONS");
             ResultSet dbnameRs = statement2.executeQuery("SELECT DB_NAME() as db");){
            dbnameRs.next();
            String dbName = dbnameRs.getString(1);
            while (rs.next()) {
                String option = rs.getString(1);
                String value = rs.getString(2);
                if (!"isolation level".equalsIgnoreCase(option) || "read committed snapshot".equalsIgnoreCase(value)) continue;
                logger.warnf("%s 'isolation level' for database '%s' is set to '%s'. Keycloak recommends 'read committed snapshot' isolation level to avoid deadlocks under high load. Please adjust the isolation level by executing 'ALTER DATABASE %s SET READ_COMMITTED_SNAPSHOT ON'.", new Object[]{vendor, dbName, rs.getString(2), dbName});
            }
        }
        catch (SQLException e) {
            logger.warnf((Throwable)e, "Unable to validate %s 'isolation level' due to database exception", (Object)vendor);
        }
    }

    static enum MigrationStrategy {
        UPDATE,
        VALIDATE,
        MANUAL;

    }
}

