/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;
import java.util.List;
import org.keycloak.client.cli.common.AttributeOperation;
import org.keycloak.client.cli.util.AttributeException;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.registration.cli.EndpointType;
import org.keycloak.client.registration.cli.ReflectionUtil;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.util.JsonSerialization;

public class CmdStdinContext {
    private EndpointType regType;
    private ClientRepresentation client;
    private OIDCClientRepresentation oidcClient;
    private String content;
    public static final String CLIENT_OPTION_WARN = "You're using what looks like an OPTION as CLIENT: %s";
    public static final String TOKEN_OPTION_WARN = "You're using what looks like an OPTION as TOKEN: %s";

    public EndpointType getEndpointType() {
        return this.regType;
    }

    public void setEndpointType(EndpointType regType) {
        this.regType = regType;
    }

    public ClientRepresentation getClient() {
        return this.client;
    }

    public void setClient(ClientRepresentation client) {
        this.client = client;
    }

    public OIDCClientRepresentation getOidcClient() {
        return this.oidcClient;
    }

    public void setOidcClient(OIDCClientRepresentation oidcClient) {
        this.oidcClient = oidcClient;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getRegistrationAccessToken() {
        if (this.client != null) {
            return this.client.getRegistrationAccessToken();
        }
        if (this.oidcClient != null) {
            return this.oidcClient.getRegistrationAccessToken();
        }
        return null;
    }

    public static CmdStdinContext parseFileOrStdin(String file, EndpointType type) {
        String content = IoUtil.readFileOrStdin(file).trim();
        ClientRepresentation client = null;
        OIDCClientRepresentation oidcClient = null;
        if (type == null) {
            if (content.startsWith("<")) {
                type = EndpointType.SAML2;
            } else if (content.startsWith("{")) {
                try {
                    client = JsonSerialization.readValue(content, ClientRepresentation.class);
                    type = EndpointType.DEFAULT;
                }
                catch (JsonParseException e) {
                    throw new RuntimeException("Failed to read the input document as JSON: " + e.getMessage(), e);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (client == null) {
                    try {
                        oidcClient = JsonSerialization.readValue(content, OIDCClientRepresentation.class);
                        type = EndpointType.OIDC;
                    }
                    catch (IOException ne) {
                        throw new RuntimeException("Unable to determine input document type. Use -e TYPE to specify the registration endpoint to use");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to read the input document as JSON", e);
                    }
                }
            } else {
                if (content.length() == 0) {
                    throw new RuntimeException("Document provided by --file option is empty");
                }
                throw new RuntimeException("Unable to determine input document type. Use -e TYPE to specify the registration endpoint to use");
            }
        }
        if (content != null) {
            try {
                if (type == EndpointType.DEFAULT && client == null) {
                    client = JsonSerialization.readValue(content, ClientRepresentation.class);
                } else if (type == EndpointType.OIDC && oidcClient == null) {
                    oidcClient = JsonSerialization.readValue(content, OIDCClientRepresentation.class);
                }
            }
            catch (JsonParseException e) {
                throw new RuntimeException("Not a valid JSON document - " + e.getMessage(), e);
            }
            catch (UnrecognizedPropertyException e) {
                throw new RuntimeException("Attribute '" + e.getPropertyName() + "' not supported on document type '" + type.getName() + "'", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Not a valid JSON document", e);
            }
        }
        CmdStdinContext ctx = new CmdStdinContext();
        ctx.setEndpointType(type);
        ctx.setContent(content);
        ctx.setClient(client);
        ctx.setOidcClient(oidcClient);
        return ctx;
    }

    public static CmdStdinContext mergeAttributes(CmdStdinContext ctx, List<AttributeOperation> attrs) {
        String content = ctx.getContent();
        ClientRepresentation client = ctx.getClient();
        OIDCClientRepresentation oidcClient = ctx.getOidcClient();
        EndpointType type = ctx.getEndpointType();
        try {
            Object rep;
            if (content == null) {
                if (type == EndpointType.DEFAULT) {
                    client = new ClientRepresentation();
                } else if (type == EndpointType.OIDC) {
                    oidcClient = new OIDCClientRepresentation();
                }
            }
            Object object = rep = client != null ? client : oidcClient;
            if (rep != null) {
                try {
                    ReflectionUtil.setAttributes(rep, attrs);
                }
                catch (AttributeException e) {
                    throw new RuntimeException("Failed to set attribute '" + e.getAttributeName() + "' on document type '" + type.getName() + "'", e);
                }
            } else {
                throw new RuntimeException("Setting attributes is not supported for type: " + type.getName());
            }
            content = JsonSerialization.writeValueAsString(rep);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to merge set attributes with configuration from file", e);
        }
        ctx.setContent(content);
        ctx.setClient(client);
        ctx.setOidcClient(oidcClient);
        return ctx;
    }
}

