/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.api;

import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.TYPE, ElementType.PARAMETER})
public @interface ManagedExecutorConfig {
    public String[] cleared() default {};

    public String[] propagated() default {"Remaining"};

    public int maxAsync() default -1;

    public int maxQueued() default -1;

    public static final class Literal
    extends AnnotationLiteral<ManagedExecutorConfig>
    implements ManagedExecutorConfig {
        public static final Literal DEFAULT_INSTANCE = Literal.of(-1, -1, new String[0], new String[]{"Remaining"});
        private static final long serialVersionUID = 1L;
        private final int maxAsync;
        private final int maxQueued;
        private final String[] cleared;
        private final String[] propagated;

        private Literal(int maxAsync, int maxQueued, String[] cleared, String[] propagated) {
            this.cleared = cleared;
            this.propagated = propagated;
            this.maxAsync = maxAsync;
            this.maxQueued = maxQueued;
        }

        public static Literal of(int maxAsync, int maxQueued, String[] cleared, String[] propagated) {
            return new Literal(maxAsync, maxQueued, cleared, propagated);
        }

        @Override
        public int maxAsync() {
            return this.maxAsync;
        }

        @Override
        public int maxQueued() {
            return this.maxQueued;
        }

        @Override
        public String[] cleared() {
            return this.cleared;
        }

        @Override
        public String[] propagated() {
            return this.propagated;
        }
    }
}

