/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Objects;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpressionHelper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public class SqmParameterizedEntityType<T>
extends AbstractSqmExpression<T>
implements SqmSelectableNode<T> {
    private final SqmParameter<T> discriminatorSource;

    public SqmExpression<T> getDiscriminatorSource() {
        return this.discriminatorSource;
    }

    public SqmParameterizedEntityType(SqmParameter<T> parameterExpression, NodeBuilder nodeBuilder) {
        super(SqmExpressionHelper.toSqmType(parameterExpression.getAnticipatedType(), nodeBuilder), nodeBuilder);
        this.discriminatorSource = parameterExpression;
    }

    @Override
    public SqmParameterizedEntityType<T> copy(SqmCopyContext context) {
        SqmParameterizedEntityType existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmParameterizedEntityType<T> expression = context.registerCopy(this, new SqmParameterizedEntityType<T>(this.discriminatorSource.copy(context), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(expression, context);
        return expression;
    }

    @Override
    public void internalApplyInferableType(SqmBindableType<?> type) {
        this.setExpressibleType(type);
        this.discriminatorSource.applyInferableType(type);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitParameterizedEntityTypeExpression(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("type(");
        this.discriminatorSource.appendHqlString(hql, context);
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmParameterizedEntityType)) return false;
        SqmParameterizedEntityType that = (SqmParameterizedEntityType)object;
        if (!Objects.equals(this.discriminatorSource, that.discriminatorSource)) return false;
        return true;
    }

    public int hashCode() {
        return this.discriminatorSource.hashCode();
    }
}

