/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.PathException;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.TreatException;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmEmbeddedValuedSimplePath<T>
extends AbstractSqmSimplePath<T>
implements SqmBindableType<T> {
    public SqmEmbeddedValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, nodeBuilder);
        assert (referencedPathSource.getPathType() instanceof EmbeddableDomainType);
    }

    public SqmEmbeddedValuedSimplePath(NavigablePath navigablePath, SqmPathSource<T> referencedPathSource, SqmPath<?> lhs, String explicitAlias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, explicitAlias, nodeBuilder);
        assert (referencedPathSource.getPathType() instanceof EmbeddableDomainType);
    }

    @Override
    public SqmEmbeddedValuedSimplePath<T> copy(SqmCopyContext context) {
        SqmEmbeddedValuedSimplePath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmExpression lhsCopy = this.getLhs().copy(context);
        SqmEmbeddedValuedSimplePath<T> path = context.registerCopy(this, new SqmEmbeddedValuedSimplePath<T>(this.getNavigablePathCopy((SqmPath<?>)lhsCopy), this.getModel(), (SqmPath<?>)lhsCopy, this.getExplicitAlias(), this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmBindableType<T> getExpressible() {
        return this;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    @Override
    public SqmDomainType<T> getSqmType() {
        return this.getResolvedModel().getSqmType();
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        SqmPath sqmPath = this.get(name, true);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register(sqmPath);
        return sqmPath;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEmbeddableValuedPath(this);
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> treatJavaType) throws PathException {
        return this.getTreatedPath(this.nodeBuilder().getDomainModel().embeddable(treatJavaType));
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        throw new TreatException("Embeddable paths cannot be TREAT-ed to an entity type");
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return super.getExpressible().getExpressibleJavaType();
    }

    @Override
    public Class<T> getJavaType() {
        return this.getJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public JavaType<?> getRelationalJavaType() {
        return super.getExpressible().getRelationalJavaType();
    }
}

