/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jitsi.utils.logging.Logger;

public final class JNIUtils {
    private static final String DELETE_ON_EXIT_PROPERTY = "org.jitsi.utils.JniUtils.AlwaysDeleteOnExit";
    private static final Logger logger = Logger.getLogger(JNIUtils.class);

    public static void loadLibrary(String libname, ClassLoader classLoader) {
        JNIUtils.loadLibrary(libname, null, classLoader);
    }

    public static <T> void loadLibrary(String libname, Class<T> clazz) {
        JNIUtils.loadLibrary(libname, clazz, clazz.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void loadLibrary(String libname, Class<T> clazz, ClassLoader classLoader) {
        try {
            System.loadLibrary(libname);
            logger.info("Loading library " + libname + " from java.library.path rather than bundled version");
            return;
        }
        catch (UnsatisfiedLinkError e) {
            try {
                if (clazz == null) {
                    throw e;
                }
                JNIUtils.loadNativeInClassloader(libname, clazz, false);
            }
            catch (UnsatisfiedLinkError ulerr) {
                File embedded;
                libname = System.mapLibraryName(libname);
                try {
                    embedded = Native.extractFromResourcePath("/" + Platform.RESOURCE_PREFIX + "/" + libname, classLoader);
                }
                catch (IOException ioex) {
                    throw ulerr;
                }
                try {
                    if (clazz != null) {
                        JNIUtils.loadNativeInClassloader(embedded.getAbsolutePath(), clazz, true);
                    } else {
                        System.load(embedded.getAbsolutePath());
                    }
                }
                finally {
                    if (embedded.getName().startsWith("jna") && (System.getProperty(DELETE_ON_EXIT_PROPERTY) != null || !embedded.delete())) {
                        embedded.deleteOnExit();
                    }
                }
            }
            return;
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private static <T> void loadNativeInClassloader(String lib, Class<T> clazz, boolean isAbsolute) {
        try {
            Method loadLibrary0 = Runtime.getRuntime().getClass().getDeclaredMethod(isAbsolute ? "load0" : "loadLibrary0", Class.class, String.class);
            loadLibrary0.setAccessible(true);
            loadLibrary0.invoke((Object)Runtime.getRuntime(), clazz, lib);
        }
        catch (Exception e) {
            if (isAbsolute) {
                System.load(lib);
            }
            System.loadLibrary(lib);
        }
    }

    private JNIUtils() {
    }
}

