/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.solaris_sparc;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.sparc.SPARCThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.sparc.SPARCFrame;
import sun.jvm.hotspot.runtime.sparc.SPARCRegisterMap;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class SolarisSPARCJavaThreadPDAccess
implements JavaThreadPDAccess {
    private static AddressField baseOfStackPointerField;
    private static AddressField postJavaStateField;
    private static AddressField osThreadField;
    private static int isPC;
    private static int hasFlushed;
    private static CIntegerField osThreadThreadIDField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaThread");
        Type anchorType = db.lookupType("JavaFrameAnchor");
        baseOfStackPointerField = type.getAddressField("_base_of_stack_pointer");
        osThreadField = type.getAddressField("_osthread");
        hasFlushed = db.lookupIntConstant("JavaFrameAnchor::flushed");
        type = db.lookupType("OSThread");
        osThreadThreadIDField = type.getCIntegerField("_thread_id");
    }

    @Override
    public Address getLastJavaFP(Address addr) {
        return null;
    }

    @Override
    public Address getLastJavaPC(Address addr) {
        return null;
    }

    @Override
    public Address getBaseOfStackPointer(Address addr) {
        return baseOfStackPointerField.getValue(addr);
    }

    @Override
    public Frame getLastFramePD(JavaThread thread, Address addr) {
        if (thread.getLastJavaSP() == null) {
            return null;
        }
        if (thread.getLastJavaPC() != null) {
            return new SPARCFrame(SPARCFrame.biasSP(thread.getLastJavaSP()), thread.getLastJavaPC());
        }
        Frame top = this.getCurrentFrameGuess(thread, addr);
        return new SPARCFrame(SPARCFrame.biasSP(thread.getLastJavaSP()), SPARCFrame.biasSP(SPARCFrame.findYoungerSP(top.getSP(), thread.getLastJavaSP())), false);
    }

    @Override
    public RegisterMap newRegisterMap(JavaThread thread, boolean updateMap) {
        return new SPARCRegisterMap(thread, updateMap);
    }

    @Override
    public Frame getCurrentFrameGuess(JavaThread thread, Address addr) {
        if (thread.getLastJavaSP() != null && thread.getLastJavaPC() != null) {
            return new SPARCFrame(SPARCFrame.biasSP(thread.getLastJavaSP()), thread.getLastJavaPC());
        }
        ThreadProxy t = this.getThreadProxy(addr);
        SPARCThreadContext context = (SPARCThreadContext)t.getContext();
        Address sp = context.getRegisterAsAddress(14);
        Address pc = context.getRegisterAsAddress(33);
        if (sp == null || pc == null) {
            return null;
        }
        return new SPARCFrame(sp, pc);
    }

    @Override
    public void printThreadIDOn(Address addr, PrintStream tty) {
        tty.print(this.getThreadProxy(addr));
    }

    @Override
    public Address getLastSP(Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        SPARCThreadContext context = (SPARCThreadContext)t.getContext();
        return SPARCFrame.unBiasSP(context.getRegisterAsAddress(14));
    }

    @Override
    public void printInfoOn(Address threadAddr, PrintStream tty) {
    }

    @Override
    public ThreadProxy getThreadProxy(Address addr) {
        Address osThreadAddr = osThreadField.getValue(addr);
        Address tidAddr = osThreadAddr.addOffsetTo(osThreadThreadIDField.getOffset());
        JVMDebugger debugger = VM.getVM().getDebugger();
        return debugger.getThreadForIdentifierAddress(tidAddr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                SolarisSPARCJavaThreadPDAccess.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

