/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersion;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionEdge;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsGraph;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;
import org.jetbrains.java.decompiler.util.SFormsFastMapDirect;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public final class DotExporter {
    private static String toDotFormat(Statement stat) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("digraph G {\r\n");
        for (Statement st : stat.getStats()) {
            String destid;
            String sourceid = st.id + (st.getSuccessorEdges(StatEdge.EdgeType.EXCEPTION).isEmpty() ? "" : "000000");
            buffer.append(sourceid).append(" [shape=box,label=\"").append(sourceid).append("\"];\r\n");
            for (StatEdge edge : st.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL)) {
                destid = edge.getDestination().id + (edge.getDestination().getSuccessorEdges(StatEdge.EdgeType.EXCEPTION).isEmpty() ? "" : "000000");
                buffer.append(sourceid).append("->").append(destid).append(";\r\n");
                if (stat.getStats().contains(edge.getDestination())) continue;
                buffer.append(destid).append(" [label=\"").append(destid).append("\"];\r\n");
            }
            for (StatEdge edge : st.getSuccessorEdges(StatEdge.EdgeType.EXCEPTION)) {
                destid = edge.getDestination().id + (edge.getDestination().getSuccessorEdges(StatEdge.EdgeType.EXCEPTION).isEmpty() ? "" : "000000");
                buffer.append(sourceid).append(" -> ").append(destid).append(" [style=dotted];\r\n");
                if (stat.getStats().contains(edge.getDestination())) continue;
                buffer.append(destid).append(" [label=\"").append(destid).append("\"];\r\n");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static String toDotFormat(ControlFlowGraph graph, boolean showMultipleEdges) {
        StringBuilder buffer = new StringBuilder();
        String nl = "\r\n";
        buffer.append("digraph G {").append(nl);
        VBStyleCollection<BasicBlock, Integer> blocks = graph.getBlocks();
        for (int i = 0; i < blocks.size(); ++i) {
            BasicBlock block = (BasicBlock)blocks.get(i);
            buffer.append(block.id).append('[').append(nl).append("  shape=box").append(nl).append("  label=\"").append(block.toString().replaceAll(DecompilerContext.getNewLineSeparator(), "\\\\l")).append('\"').append(nl).append(']').append(nl);
            for (BasicBlock edge : DotExporter.unique(block.getSuccessors(), showMultipleEdges)) {
                buffer.append(block.id).append(" -> ").append(edge.id).append(';').append(nl);
            }
            for (BasicBlock edge : DotExporter.unique(block.getSuccessorExceptions(), showMultipleEdges)) {
                buffer.append(block.id).append(" -> ").append(edge.id).append(" [style=dotted];").append(nl);
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static Collection<BasicBlock> unique(List<BasicBlock> blocks, boolean showMultipleEdges) {
        if (showMultipleEdges) {
            return blocks;
        }
        return new LinkedHashSet<BasicBlock>(blocks);
    }

    private static String toDotFormat(VarVersionsGraph graph) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("digraph G {\r\n");
        VBStyleCollection<VarVersionNode, VarVersion> blocks = graph.nodes;
        for (int i = 0; i < blocks.size(); ++i) {
            VarVersionNode block = (VarVersionNode)blocks.get(i);
            buffer.append(block.var * 1000 + block.version).append(" [shape=box,label=\"").append(block.var).append("_").append(block.version).append("\"];\r\n");
            for (VarVersionEdge edge : block.successors) {
                VarVersionNode dest = edge.dest;
                buffer.append(block.var * 1000 + block.version).append("->").append(dest.var * 1000 + dest.version).append(edge.type == 1 ? " [style=dotted]" : "").append(";\r\n");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static String toDotFormat(DirectGraph graph, Map<String, SFormsFastMapDirect> vars) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("digraph G {\r\n");
        for (DirectNode block : graph.nodes) {
            SFormsFastMapDirect map;
            List<Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>>> lst;
            StringBuilder label = new StringBuilder(block.id);
            if (vars != null && vars.containsKey(block.id) && (lst = (map = vars.get(block.id)).entryList()) != null) {
                for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> entry : lst) {
                    label.append("\\n").append(entry.getKey());
                    Set<Integer> set = entry.getValue().toPlainSet();
                    label.append("=").append(set);
                }
            }
            buffer.append(DotExporter.directBlockIdToDot(block.id)).append(" [shape=box,label=\"").append((CharSequence)label).append("\"];\r\n");
            for (DirectNode dest : block.successors) {
                buffer.append(DotExporter.directBlockIdToDot(block.id)).append("->").append(DotExporter.directBlockIdToDot(dest.id)).append(";\r\n");
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static String directBlockIdToDot(String id) {
        id = id.replaceAll("_try", "999");
        id = id.replaceAll("_tail", "888");
        id = id.replaceAll("_init", "111");
        id = id.replaceAll("_cond", "222");
        id = id.replaceAll("_inc", "333");
        return id;
    }

    private static File getFile(StructMethod mt, String suffix) {
        String folder = DecompilerContext.getProperty("dsf").toString();
        File root = new File(folder + mt.getClassQualifiedName());
        if (!root.isDirectory()) {
            root.mkdirs();
        }
        StringBuilder name = new StringBuilder();
        name.append(mt.getName().replace('<', '_').replace('>', '_'));
        name.append('(');
        MethodDescriptor desc = MethodDescriptor.parseDescriptor(mt.getDescriptor());
        for (VarType par : desc.params) {
            name.append(ExprProcessor.getCastTypeName(par, Collections.emptyList())).append(", ");
        }
        if (desc.params.length > 0) {
            name.delete(name.length() - 2, name.length());
        }
        name.append(')');
        name.append(ExprProcessor.getCastTypeName(desc.ret, Collections.emptyList()));
        name.append('_').append(suffix).append(".dot");
        return new File(root, name.toString());
    }

    public static void toDotFile(DirectGraph dgraph, StructMethod mt, String suffix) {
        if (DecompilerContext.getProperty("dsf") == null) {
            return;
        }
        DotExporter.toDotFile(dgraph, mt, suffix, null);
    }

    public static void toDotFile(DirectGraph dgraph, StructMethod mt, String suffix, Map<String, SFormsFastMapDirect> vars) {
        if (DecompilerContext.getProperty("dsf") == null) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(mt, suffix)));
            out.write(DotExporter.toDotFormat(dgraph, vars).getBytes(Charset.defaultCharset()));
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toDotFile(Statement stat, StructMethod mt, String suffix) {
        if (DecompilerContext.getProperty("dsf") == null) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(mt, suffix)));
            out.write(DotExporter.toDotFormat(stat).getBytes(Charset.defaultCharset()));
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toDotFile(VarVersionsGraph graph, StructMethod mt, String suffix) {
        if (DecompilerContext.getProperty("dsf") == null) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(mt, suffix)));
            out.write(DotExporter.toDotFormat(graph).getBytes(Charset.defaultCharset()));
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toDotFile(ControlFlowGraph graph, StructMethod mt, String suffix, boolean showMultipleEdges) {
        if (DecompilerContext.getProperty("dsf") == null) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(mt, suffix)));
            out.write(DotExporter.toDotFormat(graph, showMultipleEdges).getBytes(Charset.defaultCharset()));
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

