"""Generated client library for configdelivery version v1beta."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.configdelivery.v1beta import configdelivery_v1beta_messages as messages


class ConfigdeliveryV1beta(base_api.BaseApiClient):
  """Generated client library for service configdelivery version v1beta."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://configdelivery.googleapis.com/'
  MTLS_BASE_URL = 'https://configdelivery.mtls.googleapis.com/'

  _PACKAGE = 'configdelivery'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1beta'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ConfigdeliveryV1beta'
  _URL_VERSION = 'v1beta'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new configdelivery handle."""
    url = url or self.BASE_URL
    super(ConfigdeliveryV1beta, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_fleetPackages_rollouts = self.ProjectsLocationsFleetPackagesRolloutsService(self)
    self.projects_locations_fleetPackages = self.ProjectsLocationsFleetPackagesService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_resourceBundles_releases_variants = self.ProjectsLocationsResourceBundlesReleasesVariantsService(self)
    self.projects_locations_resourceBundles_releases = self.ProjectsLocationsResourceBundlesReleasesService(self)
    self.projects_locations_resourceBundles = self.ProjectsLocationsResourceBundlesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsFleetPackagesRolloutsService(base_api.BaseApiService):
    """Service class for the projects_locations_fleetPackages_rollouts resource."""

    _NAME = 'projects_locations_fleetPackages_rollouts'

    def __init__(self, client):
      super(ConfigdeliveryV1beta.ProjectsLocationsFleetPackagesRolloutsService, self).__init__(client)
      self._upload_configs = {
          }

    def Abort(self, request, global_params=None):
      r"""Abort a Rollout.

      Args:
        request: (ConfigdeliveryProjectsLocationsFleetPackagesRolloutsAbortRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Abort')
      return self._RunMethod(
          config, request, global_params=global_params)

    Abort.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/fleetPackages/{fleetPackagesId}/rollouts/{rolloutsId}:abort',
        http_method='POST',
        method_id='configdelivery.projects.locations.fleetPackages.rollouts.abort',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}:abort',
        request_field='abortRolloutRequest',
        request_type_name='ConfigdeliveryProjectsLocationsFleetPackagesRolloutsAbortRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Rollout.

      Args:
        request: (ConfigdeliveryProjectsLocationsFleetPackagesRolloutsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Rollout) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/fleetPackages/{fleetPackagesId}/rollouts/{rolloutsId}',
        http_method='GET',
        method_id='configdelivery.projects.locations.fleetPackages.rollouts.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsFleetPackagesRolloutsGetRequest',
        response_type_name='Rollout',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Rollouts in a given project, location, and Fleet Package.

      Args:
        request: (ConfigdeliveryProjectsLocationsFleetPackagesRolloutsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRolloutsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/fleetPackages/{fleetPackagesId}/rollouts',
        http_method='GET',
        method_id='configdelivery.projects.locations.fleetPackages.rollouts.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta/{+parent}/rollouts',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsFleetPackagesRolloutsListRequest',
        response_type_name='ListRolloutsResponse',
        supports_download=False,
    )

    def Resume(self, request, global_params=None):
      r"""Resume a Rollout.

      Args:
        request: (ConfigdeliveryProjectsLocationsFleetPackagesRolloutsResumeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Resume')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resume.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/fleetPackages/{fleetPackagesId}/rollouts/{rolloutsId}:resume',
        http_method='POST',
        method_id='configdelivery.projects.locations.fleetPackages.rollouts.resume',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}:resume',
        request_field='resumeRolloutRequest',
        request_type_name='ConfigdeliveryProjectsLocationsFleetPackagesRolloutsResumeRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Suspend(self, request, global_params=None):
      r"""Suspend a Rollout.

      Args:
        request: (ConfigdeliveryProjectsLocationsFleetPackagesRolloutsSuspendRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Suspend')
      return self._RunMethod(
          config, request, global_params=global_params)

    Suspend.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/fleetPackages/{fleetPackagesId}/rollouts/{rolloutsId}:suspend',
        http_method='POST',
        method_id='configdelivery.projects.locations.fleetPackages.rollouts.suspend',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}:suspend',
        request_field='suspendRolloutRequest',
        request_type_name='ConfigdeliveryProjectsLocationsFleetPackagesRolloutsSuspendRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsFleetPackagesService(base_api.BaseApiService):
    """Service class for the projects_locations_fleetPackages resource."""

    _NAME = 'projects_locations_fleetPackages'

    def __init__(self, client):
      super(ConfigdeliveryV1beta.ProjectsLocationsFleetPackagesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new FleetPackage in a given project and location.

      Args:
        request: (ConfigdeliveryProjectsLocationsFleetPackagesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/fleetPackages',
        http_method='POST',
        method_id='configdelivery.projects.locations.fleetPackages.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['fleetPackageId', 'requestId'],
        relative_path='v1beta/{+parent}/fleetPackages',
        request_field='fleetPackage',
        request_type_name='ConfigdeliveryProjectsLocationsFleetPackagesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single FleetPackage.

      Args:
        request: (ConfigdeliveryProjectsLocationsFleetPackagesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/fleetPackages/{fleetPackagesId}',
        http_method='DELETE',
        method_id='configdelivery.projects.locations.fleetPackages.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['allowMissing', 'force', 'requestId'],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsFleetPackagesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single FleetPackage.

      Args:
        request: (ConfigdeliveryProjectsLocationsFleetPackagesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FleetPackage) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/fleetPackages/{fleetPackagesId}',
        http_method='GET',
        method_id='configdelivery.projects.locations.fleetPackages.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsFleetPackagesGetRequest',
        response_type_name='FleetPackage',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists FleetPackages in a given project and location.

      Args:
        request: (ConfigdeliveryProjectsLocationsFleetPackagesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFleetPackagesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/fleetPackages',
        http_method='GET',
        method_id='configdelivery.projects.locations.fleetPackages.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta/{+parent}/fleetPackages',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsFleetPackagesListRequest',
        response_type_name='ListFleetPackagesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single FleetPackage.

      Args:
        request: (ConfigdeliveryProjectsLocationsFleetPackagesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/fleetPackages/{fleetPackagesId}',
        http_method='PATCH',
        method_id='configdelivery.projects.locations.fleetPackages.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1beta/{+name}',
        request_field='fleetPackage',
        request_type_name='ConfigdeliveryProjectsLocationsFleetPackagesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(ConfigdeliveryV1beta.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (ConfigdeliveryProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='configdelivery.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='ConfigdeliveryProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (ConfigdeliveryProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='configdelivery.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (ConfigdeliveryProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='configdelivery.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (ConfigdeliveryProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='configdelivery.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1beta/{+name}/operations',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsResourceBundlesReleasesVariantsService(base_api.BaseApiService):
    """Service class for the projects_locations_resourceBundles_releases_variants resource."""

    _NAME = 'projects_locations_resourceBundles_releases_variants'

    def __init__(self, client):
      super(ConfigdeliveryV1beta.ProjectsLocationsResourceBundlesReleasesVariantsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Variant in a given project, location, resource bundle, and release.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}/releases/{releasesId}/variants',
        http_method='POST',
        method_id='configdelivery.projects.locations.resourceBundles.releases.variants.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['requestId', 'variantId'],
        relative_path='v1beta/{+parent}/variants',
        request_field='variant',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Variant.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}/releases/{releasesId}/variants/{variantsId}',
        http_method='DELETE',
        method_id='configdelivery.projects.locations.resourceBundles.releases.variants.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Variant.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Variant) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}/releases/{releasesId}/variants/{variantsId}',
        http_method='GET',
        method_id='configdelivery.projects.locations.resourceBundles.releases.variants.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsGetRequest',
        response_type_name='Variant',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Variants in a given project and location.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListVariantsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}/releases/{releasesId}/variants',
        http_method='GET',
        method_id='configdelivery.projects.locations.resourceBundles.releases.variants.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta/{+parent}/variants',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsListRequest',
        response_type_name='ListVariantsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Variant.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}/releases/{releasesId}/variants/{variantsId}',
        http_method='PATCH',
        method_id='configdelivery.projects.locations.resourceBundles.releases.variants.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1beta/{+name}',
        request_field='variant',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesReleasesVariantsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsResourceBundlesReleasesService(base_api.BaseApiService):
    """Service class for the projects_locations_resourceBundles_releases resource."""

    _NAME = 'projects_locations_resourceBundles_releases'

    def __init__(self, client):
      super(ConfigdeliveryV1beta.ProjectsLocationsResourceBundlesReleasesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Release in a given project, location and resource bundle.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesReleasesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}/releases',
        http_method='POST',
        method_id='configdelivery.projects.locations.resourceBundles.releases.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['releaseId', 'requestId'],
        relative_path='v1beta/{+parent}/releases',
        request_field='release',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesReleasesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Release.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesReleasesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}/releases/{releasesId}',
        http_method='DELETE',
        method_id='configdelivery.projects.locations.resourceBundles.releases.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'requestId'],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesReleasesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Release.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesReleasesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Release) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}/releases/{releasesId}',
        http_method='GET',
        method_id='configdelivery.projects.locations.resourceBundles.releases.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesReleasesGetRequest',
        response_type_name='Release',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Releases in a given project and location.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesReleasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListReleasesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}/releases',
        http_method='GET',
        method_id='configdelivery.projects.locations.resourceBundles.releases.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta/{+parent}/releases',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesReleasesListRequest',
        response_type_name='ListReleasesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Release.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesReleasesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}/releases/{releasesId}',
        http_method='PATCH',
        method_id='configdelivery.projects.locations.resourceBundles.releases.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1beta/{+name}',
        request_field='release',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesReleasesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsResourceBundlesService(base_api.BaseApiService):
    """Service class for the projects_locations_resourceBundles resource."""

    _NAME = 'projects_locations_resourceBundles'

    def __init__(self, client):
      super(ConfigdeliveryV1beta.ProjectsLocationsResourceBundlesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new ResourceBundle in a given project and location.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles',
        http_method='POST',
        method_id='configdelivery.projects.locations.resourceBundles.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['requestId', 'resourceBundleId'],
        relative_path='v1beta/{+parent}/resourceBundles',
        request_field='resourceBundle',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single ResourceBundle.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}',
        http_method='DELETE',
        method_id='configdelivery.projects.locations.resourceBundles.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'requestId'],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single ResourceBundle.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ResourceBundle) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}',
        http_method='GET',
        method_id='configdelivery.projects.locations.resourceBundles.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesGetRequest',
        response_type_name='ResourceBundle',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ResourceBundles in a given project and location.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListResourceBundlesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles',
        http_method='GET',
        method_id='configdelivery.projects.locations.resourceBundles.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta/{+parent}/resourceBundles',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesListRequest',
        response_type_name='ListResourceBundlesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single ResourceBundle.

      Args:
        request: (ConfigdeliveryProjectsLocationsResourceBundlesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/resourceBundles/{resourceBundlesId}',
        http_method='PATCH',
        method_id='configdelivery.projects.locations.resourceBundles.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1beta/{+name}',
        request_field='resourceBundle',
        request_type_name='ConfigdeliveryProjectsLocationsResourceBundlesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(ConfigdeliveryV1beta.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (ConfigdeliveryProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='configdelivery.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service. This method can be called in two ways: * **List all public locations:** Use the path `GET /v1/locations`. * **List project-visible locations:** Use the path `GET /v1/projects/{project_id}/locations`. This may include public locations as well as private or other locations specifically visible to the project.

      Args:
        request: (ConfigdeliveryProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations',
        http_method='GET',
        method_id='configdelivery.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1beta/{+name}/locations',
        request_field='',
        request_type_name='ConfigdeliveryProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(ConfigdeliveryV1beta.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
