/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type ToolCall } from '@google/gemini-cli-core';
import { type HistoryItemToolGroup } from '../types.js';
/**
 * Transforms `ToolCall` objects into `HistoryItemToolGroup` objects for UI
 * display. This is a pure projection layer and does not track interaction
 * state.
 */
export declare function mapToDisplay(toolOrTools: ToolCall[] | ToolCall, options?: {
    borderTop?: boolean;
    borderBottom?: boolean;
}): HistoryItemToolGroup;
