/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionMap;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class ColonyProductionTest
extends FreeColTestCase {
    private static final BuildingType countryType = ColonyProductionTest.spec().getBuildingType("model.building.country");
    private static final BuildingType depotType = ColonyProductionTest.spec().getBuildingType("model.building.depot");
    private static final BuildingType townHallType = ColonyProductionTest.spec().getBuildingType("model.building.townHall");
    private static final GoodsType bellsType = ColonyProductionTest.spec().getGoodsType("model.goods.bells");
    private static final GoodsType clothType = ColonyProductionTest.spec().getGoodsType("model.goods.cloth");
    private static final GoodsType cottonType = ColonyProductionTest.spec().getGoodsType("model.goods.cotton");
    private static final GoodsType crossesType = ColonyProductionTest.spec().getGoodsType("model.goods.crosses");
    private static final GoodsType foodType = ColonyProductionTest.spec().getGoodsType("model.goods.food");
    private static final GoodsType grainType = ColonyProductionTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType horsesType = ColonyProductionTest.spec().getGoodsType("model.goods.horses");
    private static final ResourceType grainResource = ColonyProductionTest.spec().getResourceType("model.resource.grain");
    private static final TileType plainsType = ColonyProductionTest.spec().getTileType("model.tile.plains");
    private static final UnitType freeColonistType = ColonyProductionTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType pioneerType = ColonyProductionTest.spec().getUnitType("model.unit.hardyPioneer");
    private static final UnitType veteranSoldierType = ColonyProductionTest.spec().getUnitType("model.unit.veteranSoldier");

    public void testProductionSoldier() {
        Game game = ColonyProductionTest.getStandardGame();
        Map map = ColonyProductionTest.getTestMap();
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile tile = map.getTile(5, 8);
        Resource grain = new Resource(game, tile, grainResource);
        tile.addResource(grain);
        Tile tileOfColony = map.getTile(6, 8);
        ServerUnit soldier = new ServerUnit(game, tileOfColony, dutch, veteranSoldierType);
        ServerColony colony = new ServerColony(game, dutch, "New Amsterdam", tileOfColony);
        dutch.addSettlement(colony);
        this.nonServerBuildColony(soldier, colony);
        soldier.setLocation(colony.getWorkLocationFor(soldier, grainType));
        ColonyProductionTest.assertEquals((Object)map.getTile(6, 8), (Object)colony.getTile());
        ColonyProductionTest.assertEquals((String)"New Amsterdam", (String)colony.getName());
        ColonyProductionTest.assertEquals((Object)colony, (Object)colony.getTile().getSettlement());
        ColonyProductionTest.assertEquals((Object)dutch, (Object)colony.getTile().getOwner());
        ColonyProductionTest.assertEquals((Object)grainType, (Object)soldier.getWorkType());
        ColonyProductionTest.assertEquals((Object)tileOfColony, (Object)soldier.getTile());
        ColonyProductionTest.assertEquals((int)0, (int)soldier.getMovesLeft());
    }

    public void testProductionPioneer() {
        Game game = ColonyProductionTest.getStandardGame();
        Map map = ColonyProductionTest.getTestMap();
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile tile = map.getTile(5, 8);
        Resource grain = new Resource(game, tile, grainResource);
        tile.addResource(grain);
        Tile tileOfColony = map.getTile(6, 8);
        ServerUnit pioneer = new ServerUnit(game, tileOfColony, dutch, pioneerType);
        ServerColony colony = new ServerColony(game, dutch, "New Amsterdam", tileOfColony);
        dutch.addSettlement(colony);
        this.nonServerBuildColony(pioneer, colony);
        pioneer.setLocation(colony.getWorkLocationFor(pioneer, grainType));
        ColonyProductionTest.assertEquals((Object)map.getTile(6, 8), (Object)colony.getTile());
        ColonyProductionTest.assertEquals((String)"New Amsterdam", (String)colony.getName());
        ColonyProductionTest.assertEquals((Object)colony, (Object)colony.getTile().getSettlement());
        ColonyProductionTest.assertEquals((Object)dutch, (Object)colony.getTile().getOwner());
        ColonyProductionTest.assertEquals((Object)grainType, (Object)pioneer.getWorkType());
        ColonyProductionTest.assertEquals((Object)tileOfColony, (Object)pioneer.getTile());
        ColonyProductionTest.assertEquals((int)0, (int)pioneer.getMovesLeft());
    }

    public void testBellNetProduction() {
        Game game = ColonyProductionTest.getStandardGame();
        game.changeMap(ColonyProductionTest.getTestMap());
        Colony colony = this.getStandardColony(1);
        Player player = colony.getOwner();
        int noBellUnits = colony.getSpecification().getInteger("model.option.unitsThatUseNoBells");
        Building townHall = colony.getBuilding(townHallType);
        for (Unit u : townHall.getUnitList()) {
            u.setLocation(colony.getWorkLocationFor(u, foodType));
        }
        ColonyProductionTest.assertTrue((boolean)townHall.isEmpty());
        int initialBellCount = colony.getGoodsCount(bellsType);
        int expectedBellCount = 0;
        ColonyProductionTest.assertEquals((String)"Wrong initial bell count", (int)expectedBellCount, (int)initialBellCount);
        int bellsUpkeep = colony.getConsumptionOf(bellsType);
        int expectedBellUpkeep = Math.max(colony.getUnitCount() - noBellUnits, 0);
        ColonyProductionTest.assertEquals((String)"Wrong bell upkeep", (int)expectedBellUpkeep, (int)bellsUpkeep);
        for (int i = 0; i < noBellUnits; ++i) {
            ServerUnit u = new ServerUnit(game, colony.getTile(), player, freeColonistType);
            ColonyProductionTest.assertTrue((boolean)u.setLocation(colony.getWorkLocationFor(u, foodType)));
        }
        ColonyProductionTest.assertTrue((boolean)townHall.isEmpty());
        colony.invalidateCache();
        bellsUpkeep = colony.getConsumptionOf(bellsType);
        expectedBellUpkeep = Math.max(colony.getUnitCount() - noBellUnits, 0);
        ColonyProductionTest.assertEquals((String)"Wrong bell upkeep (more units)", (int)expectedBellUpkeep, (int)bellsUpkeep);
        int bellsProdPerTurn = colony.getTotalProductionOf(bellsType);
        int expectedBellProd = townHallType.getBaseProduction(null, bellsType, null);
        ColonyProductionTest.assertEquals((String)"Wrong unattended bell production", (int)expectedBellProd, (int)bellsProdPerTurn);
        int bellsNetProdPerTurn = colony.getNetProductionOf(bellsType);
        int expectedBellNetProd = expectedBellProd - expectedBellUpkeep;
        ColonyProductionTest.assertEquals((String)"Wrong unattended bell net production", (int)expectedBellNetProd, (int)bellsNetProdPerTurn);
        Unit unit = colony.getFirstUnit();
        ColonyProductionTest.assertTrue((boolean)unit.setLocation(townHall));
        colony.invalidateCache();
        ProductionType productionType = townHall.getProductionType();
        bellsProdPerTurn = colony.getTotalProductionOf(bellsType);
        expectedBellProd = townHallType.getBaseProduction(productionType, bellsType, unit.getType()) + townHallType.getBaseProduction(null, bellsType, null);
        ColonyProductionTest.assertEquals((String)"Wrong attended bell production", (int)expectedBellProd, (int)bellsProdPerTurn);
        bellsNetProdPerTurn = colony.getNetProductionOf(bellsType);
        expectedBellNetProd = expectedBellProd - expectedBellUpkeep;
        ColonyProductionTest.assertEquals((String)"Wrong attended bell net production", (int)expectedBellNetProd, (int)bellsNetProdPerTurn);
    }

    public void testNoHorsesOverProduction() {
        Game game = ColonyProductionTest.getGame();
        game.changeMap(ColonyProductionTest.getTestMap());
        Colony colony = this.getStandardColony(1);
        Building pasture = colony.getBuilding(countryType);
        Unit unit = colony.getFirstUnit();
        unit.setLocation(colony.getWorkLocationFor(unit, foodType));
        List<AbstractGoods> outputs = CollectionUtils.toList(pasture.getOutputs());
        ColonyProductionTest.assertEquals((int)1, (int)outputs.size());
        ColonyProductionTest.assertEquals((Object)horsesType, (Object)outputs.get(0).getType());
        ColonyProductionTest.assertEquals((String)"Wrong warehouse capacity in colony", (int)100, (int)colony.getWarehouseCapacity());
        colony.addGoods(horsesType, 99);
        colony.invalidateCache();
        ColonyProductionTest.assertEquals((int)99, (int)colony.getGoodsCount(horsesType));
        ColonyProductionTest.assertTrue((colony.getNetProductionOf(foodType) > 1 ? 1 : 0) != 0);
        ColonyProductionTest.assertEquals((String)"Wrong horse production", (int)1, (int)pasture.getTotalProductionOf(horsesType));
        ColonyProductionTest.assertEquals((String)"Wrong maximum horse production", (int)1, (int)pasture.getMaximumProductionOf(horsesType));
        ColonyProductionTest.assertEquals((String)"Wrong net horse production", (int)1, (int)colony.getNetProductionOf(horsesType));
        colony.addGoods(horsesType, 1);
        colony.invalidateCache();
        ColonyProductionTest.assertEquals((String)"Wrong number of horses in colony", (int)colony.getWarehouseCapacity(), (int)colony.getGoodsCount(horsesType));
        ColonyProductionTest.assertEquals((String)"Wrong horse production", (int)0, (int)pasture.getTotalProductionOf(horsesType));
        ColonyProductionTest.assertEquals((String)"Wrong maximum horse production", (int)0, (int)pasture.getMaximumProductionOf(horsesType));
        ColonyProductionTest.assertEquals((String)"Wrong net horse production", (int)0, (int)colony.getNetProductionOf(horsesType));
    }

    public void testConsumers() {
        int index;
        Game game = ColonyProductionTest.getGame();
        game.changeMap(ColonyProductionTest.getTestMap());
        Colony colony = this.getStandardColony(3);
        int units = colony.getUnitCount();
        int buildings = colony.getBuildings().size();
        List<Consumer> consumers = colony.getConsumers();
        for (index = 0; index < units; ++index) {
            ColonyProductionTest.assertTrue((String)consumers.get(index).toString(), (boolean)(consumers.get(index) instanceof Unit));
        }
        for (index = units; index < units + buildings; ++index) {
            ColonyProductionTest.assertTrue((String)consumers.get(index).toString(), (boolean)(consumers.get(index) instanceof Building));
        }
        for (index = units + buildings; index < units + buildings + 2; ++index) {
            ColonyProductionTest.assertTrue((String)consumers.get(index).toString(), (boolean)(consumers.get(index) instanceof BuildQueue));
        }
        Building country = colony.getBuilding(countryType);
        ColonyProductionTest.assertTrue((boolean)consumers.contains(country));
        Building depot = colony.getBuilding(depotType);
        ColonyProductionTest.assertTrue((boolean)consumers.contains(depot));
        int countryIndex = consumers.indexOf(country);
        int depotIndex = consumers.indexOf(depot);
        ColonyProductionTest.assertTrue((countryIndex >= 0 ? 1 : 0) != 0);
        ColonyProductionTest.assertTrue((depotIndex >= 0 ? 1 : 0) != 0);
        ColonyProductionTest.assertTrue((String)"Priority of depot should be higher than that of country", (depotIndex < countryIndex ? 1 : 0) != 0);
        BuildingType armoryType = ColonyProductionTest.spec().getBuildingType("model.building.armory");
        ServerBuilding armory = new ServerBuilding(ColonyProductionTest.getGame(), colony, armoryType);
        colony.addBuilding(armory);
        consumers = colony.getConsumers();
        for (int index2 = 0; index2 < units; ++index2) {
            ColonyProductionTest.assertTrue((String)consumers.get(index2).toString(), (boolean)(consumers.get(index2) instanceof Unit));
        }
        int offset = units + buildings;
        for (int index3 = units; index3 < offset; ++index3) {
            ColonyProductionTest.assertTrue((String)consumers.get(index3).toString(), (boolean)(consumers.get(index3) instanceof Building));
        }
        ColonyProductionTest.assertTrue((String)consumers.get(offset).toString(), (boolean)(consumers.get(offset) instanceof BuildQueue));
        ColonyProductionTest.assertTrue((String)consumers.get(offset + 1).toString(), (boolean)(consumers.get(offset + 1) instanceof Building));
        ColonyProductionTest.assertEquals((Object)armoryType, (Object)((Building)consumers.get(offset + 1)).getType());
        ColonyProductionTest.assertTrue((String)consumers.get(offset + 2).toString(), (boolean)(consumers.get(offset + 2) instanceof BuildQueue));
    }

    public void testProductionMap() {
        ProductionMap pm = new ProductionMap();
        pm.add(new AbstractGoods(cottonType, 33));
        ColonyProductionTest.assertEquals((int)33, (int)pm.get(cottonType).getAmount());
        pm.add(new AbstractGoods(grainType, 44));
        ColonyProductionTest.assertEquals((int)44, (int)pm.get(grainType).getAmount());
        ColonyProductionTest.assertEquals((int)44, (int)pm.get(foodType).getAmount());
        pm.remove(new AbstractGoods(grainType, 22));
        ColonyProductionTest.assertEquals((int)22, (int)pm.get(grainType).getAmount());
        ColonyProductionTest.assertEquals((int)22, (int)pm.get(foodType).getAmount());
        pm.remove(new AbstractGoods(foodType, 11));
        ColonyProductionTest.assertEquals((int)11, (int)pm.get(grainType).getAmount());
        ColonyProductionTest.assertEquals((int)11, (int)pm.get(foodType).getAmount());
    }

    public void testProduction() {
        Game game = ColonyProductionTest.getGame();
        game.changeMap(ColonyProductionTest.getTestMap());
        Colony colony = this.getStandardColony(3);
        ColonyTile tile = colony.getColonyTile(colony.getTile());
        ColonyProductionTest.assertEquals((int)0, (int)colony.getGoodsCount(foodType));
        ColonyProductionTest.assertEquals((Object)grainType, (Object)tile.getProduction().get(0).getType());
        ColonyProductionTest.assertEquals((int)3, (int)tile.getProduction().get(0).getAmount());
        ColonyProductionTest.assertEquals((Object)cottonType, (Object)tile.getProduction().get(1).getType());
        ColonyProductionTest.assertEquals((int)2, (int)tile.getProduction().get(1).getAmount());
        for (Unit unit : colony.getUnitList()) {
            ProductionInfo unitInfo = colony.getProductionInfo(unit);
            ColonyProductionTest.assertNotNull((Object)unitInfo);
            ColonyProductionTest.assertEquals((int)2, (int)unitInfo.getConsumption().size());
            ColonyProductionTest.assertEquals((int)2, (int)unitInfo.getMaximumConsumption().size());
            ProductionInfo pi = colony.getProductionInfo(unit.getLocation());
            if (unit.getLocation() instanceof ColonyTile) {
                ColonyProductionTest.assertEquals((int)1, (int)pi.getProduction().size());
                ColonyProductionTest.assertEquals((Object)grainType, (Object)pi.getProduction().get(0).getType());
                ColonyProductionTest.assertEquals((int)5, (int)pi.getProduction().get(0).getAmount());
                continue;
            }
            ColonyProductionTest.assertEquals((int)1, (int)pi.getProduction().size());
            ColonyProductionTest.assertEquals((Object)bellsType, (Object)pi.getProduction().get(0).getType());
            ColonyProductionTest.assertEquals((int)3, (int)pi.getProduction().get(0).getAmount());
        }
    }

    public void testGetPotentialProduction() {
        Game game = ColonyProductionTest.getGame();
        game.changeMap(ColonyProductionTest.getTestMap());
        Colony colony = this.getStandardColony(1);
        ColonyTile colonyTile = colony.getColonyTile(colony.getTile());
        ColonyProductionTest.assertNotNull((Object)colonyTile);
        ColonyProductionTest.assertEquals((Object)plainsType, (Object)colony.getTile().getType());
        Building townHall = colony.getBuilding(townHallType);
        ColonyProductionTest.assertNotNull((Object)townHall);
        ColonyProductionTest.assertTrue((boolean)townHall.isEmpty());
        UnitType colonistType = ColonyProductionTest.spec().getDefaultUnitType(colony.getOwner());
        ColonyProductionTest.assertNotNull((Object)colonistType);
        ColonyProductionTest.assertEquals((String)"Zero potential production of cotton in town hall", (int)0, (int)townHall.getPotentialProduction(cottonType, null));
        ColonyProductionTest.assertEquals((String)"Basic potential production of bells in town hall", (int)townHallType.getBaseProduction(null, bellsType, null), (int)townHall.getPotentialProduction(bellsType, null));
        ColonyProductionTest.assertEquals((String)"Unit potential production of bells in town hall", (int)townHallType.getBaseProduction(null, bellsType, colonistType), (int)townHall.getPotentialProduction(bellsType, colonistType));
        ColonyProductionTest.assertEquals((String)"Zero potential production of bells on center tile", (int)0, (int)colonyTile.getPotentialProduction(bellsType, null));
        ColonyProductionTest.assertEquals((String)"Basic potential production of cotton on center tile", (int)plainsType.getBaseProduction(null, cottonType, null), (int)colonyTile.getPotentialProduction(cottonType, null));
        ColonyProductionTest.assertEquals((String)"Zero unit potential production of cotton on center tile", (int)0, (int)colonyTile.getPotentialProduction(cottonType, colonistType));
    }
}

