/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.io.PrintWriter;
import org.olap4j.mdx.MdxUtil;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.type.NullType;
import org.olap4j.type.NumericType;
import org.olap4j.type.StringType;
import org.olap4j.type.SymbolType;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralNode
implements ParseTreeNode {
    private final Object value;
    private final Type type;
    private final ParseRegion region;

    private LiteralNode(ParseRegion region, Type type, Object value) {
        assert (type != null);
        assert (type instanceof NullType == (value == null));
        this.region = region;
        this.type = type;
        this.value = value;
    }

    public static LiteralNode createNull(ParseRegion region) {
        return new LiteralNode(region, new NullType(), null);
    }

    public static LiteralNode createString(ParseRegion region, String value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return new LiteralNode(region, new StringType(), value);
    }

    public static LiteralNode createSymbol(ParseRegion region, String value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return new LiteralNode(region, new SymbolType(), value);
    }

    public static LiteralNode create(ParseRegion region, Double value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return new LiteralNode(region, new NumericType(), value);
    }

    public static LiteralNode create(ParseRegion region, Integer value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return new LiteralNode(region, new NumericType(), value);
    }

    @Override
    public <T> T accept(ParseTreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ParseRegion getRegion() {
        return this.region;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void unparse(ParseTreeWriter writer) {
        PrintWriter pw = writer.getPrintWriter();
        if (this.value == null) {
            pw.print("NULL");
        } else if (this.type instanceof SymbolType) {
            pw.print(this.value);
        } else if (this.type instanceof NumericType) {
            pw.print(this.value);
        } else if (this.type instanceof StringType) {
            pw.print(MdxUtil.quoteForMdx((String)this.value));
        } else {
            throw new AssertionError((Object)("unexpected literal type " + this.type));
        }
    }

    @Override
    public LiteralNode deepCopy() {
        return this;
    }
}

