/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ColumnEditPanel;
import ca.sqlpower.architect.swingui.ContainerPane;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.event.ItemSelectionEvent;
import ca.sqlpower.architect.swingui.event.ItemSelectionListener;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class EditColumnAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(EditColumnAction.class);
    private SelectionHandler selectionHandler = new SelectionHandler();

    public EditColumnAction(ArchitectSwingSession session) {
        super(session, Messages.getString("EditColumnAction.name"), Messages.getString("EditColumnAction.description"), "edit_column");
        this.setEnabled(false);
        session.getPlayPen().addSelectionListener(this.selectionHandler);
        this.setupAction(this.getPlaypen().getSelectedItems());
    }

    public EditColumnAction(ArchitectFrame frame) {
        super(frame, Messages.getString("EditColumnAction.name"), Messages.getString("EditColumnAction.description"), "edit_column");
        this.setEnabled(false);
        frame.addSelectionListener(this.selectionHandler);
        this.setupAction(this.getPlaypen().getSelectedItems());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ArrayList<SQLColumn> selectedCols = new ArrayList<SQLColumn>();
        for (PlayPenComponent ppc : this.getPlaypen().getSelectedItems()) {
            if (!(ppc instanceof TablePane)) continue;
            TablePane tp = (TablePane)ppc;
            selectedCols.addAll(tp.getSelectedItems());
        }
        if (selectedCols.isEmpty()) {
            JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditColumnAction.noColumnSelected"));
            return;
        }
        try {
            String dialogTitle;
            ColumnEditPanel cep = new ColumnEditPanel(selectedCols, this.getSession());
            if (selectedCols.size() == 1) {
                SQLColumn column = (SQLColumn)selectedCols.get(0);
                dialogTitle = Messages.getString("EditColumnAction.columnPropertiesDialogTitle", column.getName());
            } else {
                dialogTitle = Messages.getString("EditColumnAction.multiEditDialogTitle");
            }
            JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)cep, (Component)this.frame, (String)dialogTitle, (String)DataEntryPanelBuilder.OK_BUTTON_LABEL);
            d.setLocationRelativeTo(this.frame);
            d.setVisible(true);
        }
        catch (SQLObjectException ex) {
            ASUtils.showExceptionDialog(this.getSession(), "Failed to create column property editor", ex);
        }
    }

    protected void showDialog(SQLTable st, int colIdx) throws SQLObjectException {
        this.showDialog(st, colIdx, false, null);
    }

    protected void showDialog(SQLTable st, final int colIdx, final boolean addToTable, final TablePane tp) throws SQLObjectException {
        SQLColumn column;
        logger.debug((Object)"Creating new column editor panel");
        if (!addToTable) {
            column = st.getColumn(colIdx);
        } else {
            if (this.getSession().getSQLTypes().size() > 0) {
                UserDefinedSQLType defaultType = null;
                for (UserDefinedSQLType type : this.getSession().getSQLTypes()) {
                    if (type.getType() != SQLColumn.getDefaultType()) continue;
                    defaultType = type;
                    break;
                }
                if (defaultType == null) {
                    defaultType = this.getSession().getSQLTypes().get(0);
                }
                column = new SQLColumn(defaultType);
            } else {
                column = new SQLColumn();
            }
            if (st.getPhysicalName() != null && !st.getPhysicalName().trim().equals("")) {
                column.setAutoIncrementSequenceName(st.getPhysicalName() + "_" + column.getName() + "_seq");
            } else {
                column.setAutoIncrementSequenceName(st.getName() + "_" + column.getName() + "_seq");
            }
        }
        final ColumnEditPanel columnEditPanel = new ColumnEditPanel(column, this.getSession());
        JDialog editDialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)columnEditPanel, (Component)this.frame, (String)Messages.getString("EditColumnAction.columnPropertiesDialogTitle", column.getName()), (String)DataEntryPanelBuilder.OK_BUTTON_LABEL, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (addToTable) {
                    ((SQLTable)tp.getModel()).begin("adding a new column '" + columnEditPanel.getColPhysicalName().getText() + "'");
                    try {
                        ((SQLTable)tp.getModel()).addColumn(column, colIdx);
                        tp.selectNone();
                        tp.selectItem(colIdx);
                    }
                    catch (SQLObjectException e) {
                        ASUtils.showExceptionDialog(EditColumnAction.this.getSession(), "Error Could not add column to table", e);
                    }
                }
                Boolean ret = columnEditPanel.applyChanges();
                if (addToTable) {
                    ((SQLTable)tp.getModel()).commit();
                }
                return ret;
            }
        }, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                columnEditPanel.discardChanges();
                return Boolean.TRUE;
            }
        });
        editDialog.pack();
        editDialog.setLocationRelativeTo(this.frame);
        editDialog.setVisible(true);
    }

    private void setupAction(List<PlayPenComponent> selectedItems) {
        if (selectedItems.size() == 0) {
            this.setEnabled(false);
            logger.debug((Object)"Disabling EditColumnAction");
            this.putValue("ShortDescription", Messages.getString("EditColumnAction.shortDescription"));
        } else {
            Selectable item = selectedItems.get(0);
            String name = Messages.getString("EditColumnAction.selected");
            logger.debug((Object)"Selected Table");
            if (item instanceof TablePane) {
                TablePane tp = (TablePane)item;
                if (tp.getSelectedItemIndex() > -1) {
                    try {
                        logger.debug((Object)"Enabling EditColumnAction");
                        this.setEnabled(true);
                        name = ((SQLTable)tp.getModel()).getColumn(tp.getSelectedItemIndex()).getName();
                    }
                    catch (SQLObjectException ex) {
                        logger.error((Object)"Couldn't get selected column name", (Throwable)ex);
                    }
                } else {
                    name = ((SQLTable)tp.getModel()).toString();
                    this.setEnabled(false);
                    logger.debug((Object)"Disabling EditColumnAction");
                }
            }
            this.putValue("ShortDescription", Messages.getString("EditColumnAction.specificColumnShortDescription", name));
        }
    }

    private class SelectionHandler
    implements SelectionListener,
    ItemSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void itemSelected(SelectionEvent e) {
            EditColumnAction.this.setupAction(EditColumnAction.this.getPlaypen().getSelectedItems());
            if (e.getSource() instanceof ContainerPane) {
                ((ContainerPane)e.getSource()).addItemSelectionListener(this);
            }
        }

        @Override
        public void itemDeselected(SelectionEvent e) {
            EditColumnAction.this.setupAction(EditColumnAction.this.getPlaypen().getSelectedItems());
            if (e.getSource() instanceof ContainerPane) {
                ((ContainerPane)e.getSource()).removeItemSelectionListener(this);
            }
        }

        public void itemsDeselected(ItemSelectionEvent e) {
            EditColumnAction.this.setupAction(EditColumnAction.this.getPlaypen().getSelectedItems());
        }

        public void itemsSelected(ItemSelectionEvent e) {
            EditColumnAction.this.setupAction(EditColumnAction.this.getPlaypen().getSelectedItems());
        }
    }
}

