/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.profiler.actions.ResetResultsAction;
import org.graalvm.visualvm.lib.profiler.actions.TakeSnapshotAction;
import org.graalvm.visualvm.lib.profiler.api.ActionsSupport;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.cpu.LiveCPUView;
import org.graalvm.visualvm.lib.ui.cpu.LiveCPUViewUpdater;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.graalvm.visualvm.lib.ui.swing.MultiButtonGroup;
import org.graalvm.visualvm.profiler.Bundle;
import org.graalvm.visualvm.profiler.ProfilingResultsSupport;
import org.openide.util.Lookup;

class CPULivePanel
extends ProfilingResultsSupport.ResultsView {
    private ProfilerToolbar toolbar;
    private LiveCPUView cpuView;
    private LiveCPUViewUpdater updater;
    private ProfilingResultsSupport.ResultsResetter resetter;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private JLabel pdLabel;
    private JButton pdSnapshotButton;
    private JButton pdResetResultsButton;
    private boolean popupPause;
    private JToggleButton[] toggles;

    CPULivePanel(Application application) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.initUI(application);
        this.add((Component)this.toolbar.getComponent(), "North");
        this.add((Component)this.cpuView, "Center");
    }

    @Override
    void refreshResults() {
        this.refreshResults(false);
    }

    @Override
    void resetResults() {
        if (this.lrDeltasButton != null) {
            this.lrDeltasButton.setSelected(false);
            this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        }
        if (this.cpuView != null) {
            this.cpuView.resetData();
            this.cpuView.setDiffView(false);
        }
    }

    @Override
    void sessionStateChanged(int sessionState) {
        this.refreshToolbar(sessionState);
    }

    private void refreshResults(final boolean forceRefresh) {
        RESULTS_PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (CPULivePanel.this.updater != null) {
                        if (forceRefresh) {
                            CPULivePanel.this.updater.setForceRefresh(true);
                        }
                        CPULivePanel.this.updater.update();
                    }
                }
                catch (Throwable t) {
                    CPULivePanel.this.cleanup();
                }
            }
        });
    }

    @Override
    void cleanup() {
        if (this.updater != null) {
            this.updater.cleanup();
            this.updater = null;
        }
        if (this.resetter != null) {
            this.resetter.unregisterView(this);
            this.resetter = null;
        }
    }

    private void initUI(Application application) {
        assert (SwingUtilities.isEventDispatchThread());
        this.cpuView = new LiveCPUView(null){

            protected boolean showSourceSupported() {
                return GoToSource.isAvailable();
            }

            protected boolean profileMethodSupported() {
                return false;
            }

            protected boolean profileClassSupported() {
                return false;
            }

            protected void showSource(ClientUtils.SourceCodeSelection value) {
                Lookup.Provider project = null;
                String className = value.getClassName();
                String methodName = value.getMethodName();
                String methodSig = value.getMethodSignature();
                GoToSource.openSource(project, (String)className, (String)methodName, (String)methodSig);
            }

            protected void selectForProfiling(ClientUtils.SourceCodeSelection value) {
            }

            protected void popupShowing() {
                if (CPULivePanel.this.lrPauseButton.isEnabled() && !CPULivePanel.this.lrRefreshButton.isEnabled()) {
                    CPULivePanel.this.popupPause = true;
                    CPULivePanel.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (CPULivePanel.this.lrPauseButton.isEnabled() && CPULivePanel.this.popupPause) {
                    CPULivePanel.this.popupPause = false;
                    CPULivePanel.this.lrPauseButton.setSelected(false);
                }
            }

            protected void foundInForwardCalls() {
                super.foundInForwardCalls();
                CPULivePanel.this.toggles[0].setSelected(true);
            }

            protected void foundInHotSpots() {
                super.foundInHotSpots();
                CPULivePanel.this.toggles[1].setSelected(true);
            }

            protected void foundInReverseCalls() {
                super.foundInReverseCalls();
                CPULivePanel.this.toggles[2].setSelected(true);
            }
        };
        this.cpuView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileMethods.HelpCtx");
        this.cpuView.putClientProperty((Object)"profiled_application", (Object)application);
        this.updater = new LiveCPUViewUpdater(this.cpuView, Profiler.getDefault().getTargetAppRunner().getProfilerClient());
        this.resetter = ProfilingResultsSupport.ResultsResetter.registerView(this);
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        String filterKey = "filter-action-key";
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = CPULivePanel.this.cpuView.getActionMap().get("filter-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
        String findKey = "find-action-key";
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = CPULivePanel.this.cpuView.getActionMap().get("find-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)findAction, (ActionMap)actionMap, (InputMap)inputMap);
        this.lrLabel = new GrayLabel(Bundle.MethodsFeatureUI_liveResults());
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = this.isSelected();
                if (CPULivePanel.this.updater != null) {
                    CPULivePanel.this.updater.setPaused(paused);
                }
                CPULivePanel.this.lrRefreshButton.setEnabled(paused && !CPULivePanel.this.popupPause);
                if (!paused) {
                    CPULivePanel.this.refreshResults(true);
                }
            }
        };
        this.lrPauseButton.setToolTipText(Bundle.MethodsFeatureUI_pauseResults());
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                CPULivePanel.this.refreshResults(true);
            }
        };
        this.lrRefreshButton.setToolTipText(Bundle.MethodsFeatureUI_updateResults());
        this.lrRefreshButton.setEnabled(false);
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                if (!CPULivePanel.this.cpuView.setDiffView(this.isSelected())) {
                    this.setSelected(false);
                }
                this.setToolTipText(this.isSelected() ? Bundle.MethodsFeatureUI_showAbsolute() : Bundle.MethodsFeatureUI_showDeltas());
            }
        };
        this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        MultiButtonGroup group = new MultiButtonGroup();
        this.toggles = new JToggleButton[3];
        JToggleButton forwardCalls = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeForward")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                CPULivePanel.this.cpuView.setView(this.isSelected(), CPULivePanel.this.toggles[1].isSelected(), CPULivePanel.this.toggles[2].isSelected());
                CPULivePanel.this.refreshResults(true);
            }
        };
        forwardCalls.putClientProperty("JButton.buttonType", "segmented");
        forwardCalls.putClientProperty("JButton.segmentPosition", "first");
        forwardCalls.setToolTipText(Bundle.MethodsFeatureUI_viewForward());
        group.add((AbstractButton)forwardCalls);
        this.toggles[0] = forwardCalls;
        forwardCalls.setSelected(true);
        JToggleButton hotSpots = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                CPULivePanel.this.cpuView.setView(CPULivePanel.this.toggles[0].isSelected(), this.isSelected(), CPULivePanel.this.toggles[2].isSelected());
                CPULivePanel.this.refreshResults(true);
            }
        };
        hotSpots.putClientProperty("JButton.buttonType", "segmented");
        hotSpots.putClientProperty("JButton.segmentPosition", "middle");
        hotSpots.setToolTipText(Bundle.MethodsFeatureUI_viewHotSpots());
        group.add((AbstractButton)hotSpots);
        this.toggles[1] = hotSpots;
        hotSpots.setSelected(false);
        JToggleButton reverseCalls = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeReverse")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                CPULivePanel.this.cpuView.setView(CPULivePanel.this.toggles[0].isSelected(), CPULivePanel.this.toggles[1].isSelected(), this.isSelected());
                CPULivePanel.this.refreshResults(true);
            }
        };
        reverseCalls.putClientProperty("JButton.buttonType", "segmented");
        reverseCalls.putClientProperty("JButton.segmentPosition", "last");
        reverseCalls.setToolTipText(Bundle.MethodsFeatureUI_viewReverse());
        group.add((AbstractButton)reverseCalls);
        this.toggles[2] = reverseCalls;
        reverseCalls.setSelected(false);
        this.pdLabel = new GrayLabel(Bundle.MethodsFeatureUI_profilingData());
        this.pdSnapshotButton = new JButton((Action)TakeSnapshotAction.getInstance());
        this.pdSnapshotButton.setText(Bundle.MethodsFeatureUI_snapshot());
        this.pdSnapshotButton.putClientProperty("JComponent.sizeVariant", "regular");
        this.pdResetResultsButton = new JButton((Action)ResetResultsAction.getInstance());
        this.pdResetResultsButton.setHideActionText(true);
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrDeltasButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.MethodsFeatureUI_view()));
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)forwardCalls);
        this.toolbar.add((Component)hotSpots);
        this.toolbar.add((Component)reverseCalls);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.cpuView.createThreadSelector());
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.pdLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.pdSnapshotButton);
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)this.pdResetResultsButton);
        this.cpuView.setView(true, false, false);
    }

    private void refreshToolbar(final int state) {
        if (this.toolbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean running = state == 4;
                    CPULivePanel.this.lrPauseButton.setEnabled(running);
                    CPULivePanel.this.lrRefreshButton.setEnabled(!CPULivePanel.this.popupPause && running && CPULivePanel.this.lrPauseButton.isSelected());
                    CPULivePanel.this.lrDeltasButton.setEnabled(running);
                }
            });
        }
    }
}

