/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2;

import java.util.Properties;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.profiler.api.ProfilerStorage;
import org.graalvm.visualvm.lib.profiler.v2.impl.WeakProcessor;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public final class SessionStorage {
    private static final String SETTINGS_FILENAME = "settings";
    private static final WeakProcessor PROCESSOR = new WeakProcessor("Profiler Storage Processor");
    private boolean dirty;
    private Properties properties;
    private final Lookup.Provider project;

    SessionStorage(Lookup.Provider project) {
        this.project = project;
    }

    public synchronized void storeFlag(String flag, String value) {
        if (this.properties == null) {
            this.loadProperties();
        }
        boolean _dirty = value != null ? !value.equals(this.properties.put(flag, value)) : this.properties.remove(flag) != null;
        this.dirty |= _dirty;
    }

    public synchronized String readFlag(String flag, String defaultValue) {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties.getProperty(flag, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void persist(boolean immediately) {
        if (this.dirty) {
            if (immediately) {
                WeakProcessor weakProcessor = PROCESSOR;
                synchronized (weakProcessor) {
                    this.saveProperties(this.properties);
                }
            } else {
                final Properties _properties = new Properties();
                for (String key : this.properties.stringPropertyNames()) {
                    _properties.setProperty(key, this.properties.getProperty(key));
                }
                PROCESSOR.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        WeakProcessor weakProcessor = PROCESSOR;
                        synchronized (weakProcessor) {
                            SessionStorage.this.saveProperties(_properties);
                        }
                    }
                });
            }
            this.dirty = false;
        }
    }

    private void loadProperties() {
        this.properties = new Properties();
        assert (!SwingUtilities.isEventDispatchThread());
        try {
            ProfilerStorage.loadProjectProperties((Properties)this.properties, (Lookup.Provider)this.project, (String)SETTINGS_FILENAME);
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveProperties(Properties _properties) {
        assert (!SwingUtilities.isEventDispatchThread());
        try {
            ProfilerStorage.saveProjectProperties((Properties)_properties, (Lookup.Provider)this.project, (String)SETTINGS_FILENAME);
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
            e.printStackTrace();
        }
    }
}

