/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import java.util.Arrays;
import org.apache.commons.digester3.CallMethodRule;
import org.apache.commons.digester3.binder.AbstractBackToLinkedRuleBuilder;
import org.apache.commons.digester3.binder.LinkedRuleBuilder;
import org.apache.commons.digester3.binder.RulesBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallMethodBuilder
extends AbstractBackToLinkedRuleBuilder<CallMethodRule> {
    private final String methodName;
    private final ClassLoader classLoader;
    private int targetOffset;
    private int paramCount = 0;
    private Class<?>[] paramTypes = new Class[0];
    private boolean useExactMatch = false;

    CallMethodBuilder(String keyPattern, String namespaceURI, RulesBinder mainBinder, LinkedRuleBuilder mainBuilder, String methodName, ClassLoader classLoader) {
        super(keyPattern, namespaceURI, mainBinder, mainBuilder);
        this.methodName = methodName;
        this.classLoader = classLoader;
    }

    public CallMethodBuilder withTargetOffset(int targetOffset) {
        this.targetOffset = targetOffset;
        return this;
    }

    public CallMethodBuilder withParamTypes(String ... paramTypeNames) {
        Class[] paramTypes = null;
        if (paramTypeNames != null) {
            paramTypes = new Class[paramTypeNames.length];
            for (int i = 0; i < paramTypeNames.length; ++i) {
                try {
                    paramTypes[i] = this.classLoader.loadClass(paramTypeNames[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.reportError(String.format("callMethod( \"%s\" ).withParamTypes( %s )", this.methodName, Arrays.toString(paramTypeNames)), String.format("class '%s' cannot be load", paramTypeNames[i]));
                }
            }
        }
        return this.withParamTypes(paramTypes);
    }

    public CallMethodBuilder withParamTypes(Class<?> ... paramTypes) {
        this.paramTypes = paramTypes;
        this.paramCount = paramTypes != null ? paramTypes.length : 0;
        return this;
    }

    public CallMethodBuilder useExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
        return this;
    }

    public CallMethodBuilder withParamCount(int paramCount) {
        if (paramCount < 0) {
            this.reportError(String.format("callMethod(\"%s\").withParamCount(int)", this.methodName), "negative parameters counter not allowed");
        }
        this.paramCount = paramCount;
        if (this.paramCount == 0) {
            if (this.paramTypes == null || this.paramTypes.length != 1) {
                this.paramTypes = new Class[]{String.class};
            }
        } else {
            this.paramTypes = new Class[this.paramCount];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                this.paramTypes[i] = String.class;
            }
        }
        return this;
    }

    public CallMethodBuilder usingElementBodyAsArgument() {
        return this.withParamCount(0);
    }

    @Override
    protected CallMethodRule createRule() {
        CallMethodRule callMethodRule = new CallMethodRule(this.targetOffset, this.methodName, this.paramCount, this.paramTypes);
        callMethodRule.setUseExactMatch(this.useExactMatch);
        return callMethodRule;
    }
}

