/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.util.Key;
import java.util.ArrayList;
import java.util.List;

public final class GetAccountInfoRequest {
    @Key(value="localId")
    private List<String> uids = null;
    @Key(value="email")
    private List<String> emails = null;
    @Key(value="phoneNumber")
    private List<String> phoneNumbers = null;
    @Key(value="federatedUserId")
    private List<FederatedUserId> federatedUserIds = null;

    public void addUid(String uid) {
        if (this.uids == null) {
            this.uids = new ArrayList<String>();
        }
        this.uids.add(uid);
    }

    public void addEmail(String email) {
        if (this.emails == null) {
            this.emails = new ArrayList<String>();
        }
        this.emails.add(email);
    }

    public void addPhoneNumber(String phoneNumber) {
        if (this.phoneNumbers == null) {
            this.phoneNumbers = new ArrayList<String>();
        }
        this.phoneNumbers.add(phoneNumber);
    }

    public void addFederatedUserId(String providerId, String providerUid) {
        if (this.federatedUserIds == null) {
            this.federatedUserIds = new ArrayList<FederatedUserId>();
        }
        this.federatedUserIds.add(new FederatedUserId(providerId, providerUid));
    }

    private static final class FederatedUserId {
        @Key(value="providerId")
        private String providerId = null;
        @Key(value="rawId")
        private String rawId = null;

        FederatedUserId(String providerId, String rawId) {
            this.providerId = providerId;
            this.rawId = rawId;
        }
    }
}

