/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoArray;
import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoObjectType;
import com.azure.core.models.GeoPosition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoLineStringCollection
extends GeoObject {
    private final List<GeoLineString> lines;

    public GeoLineStringCollection(List<GeoLineString> lines) {
        this(lines, null, null);
    }

    public GeoLineStringCollection(List<GeoLineString> lines, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(lines, "'lines' cannot be null.");
        this.lines = Collections.unmodifiableList(new ArrayList<GeoLineString>(lines));
    }

    public List<GeoLineString> getLines() {
        return this.lines;
    }

    GeoArray<GeoArray<GeoPosition>> getCoordinates() {
        return new GeoArray<GeoArray<GeoPosition>>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.MULTI_LINE_STRING;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lines, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoLineStringCollection)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoLineStringCollection other = (GeoLineStringCollection)obj;
        return super.equals(obj) && Objects.equals(this.lines, other.lines);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", GeoObjectType.MULTI_LINE_STRING.toString()).writeArrayField("coordinates", this.lines, (writer, geoLineString) -> writer.writeArray(geoLineString.getCoordinates(), JsonWriter::writeJson)).writeJsonField("bbox", (JsonSerializable)this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter).writeEndObject();
    }

    public static GeoLineStringCollection fromJson(JsonReader jsonReader) throws IOException {
        return (GeoLineStringCollection)jsonReader.readObject(reader -> {
            ArrayList<GeoLineString> lines = null;
            GeoBoundingBox boundingBox = null;
            LinkedHashMap<String, Object> customProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    String type = reader.getString();
                    if (GeoObjectType.MULTI_LINE_STRING.toString().equals(type)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'MultiLineString'. The found 'type' was '" + type + "'.");
                }
                if ("coordinates".equals(fieldName)) {
                    List positionList = reader.readArray(reader2 -> reader2.readArray(GeoPosition::fromJson));
                    lines = new ArrayList<GeoLineString>(positionList.size());
                    for (List positions : positionList) {
                        lines.add(new GeoLineString(positions));
                    }
                    continue;
                }
                if ("bbox".equals(fieldName)) {
                    boundingBox = GeoBoundingBox.fromJson(reader);
                    continue;
                }
                if (customProperties == null) {
                    customProperties = new LinkedHashMap<String, Object>();
                }
                customProperties.put(fieldName, reader.readUntyped());
            }
            return new GeoLineStringCollection(lines, boundingBox, customProperties);
        });
    }
}

