/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.serial.internal;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class SerialPortUtil {
    private static final String GNU_IO_RXTX_SERIAL_PORTS = "gnu.io.rxtx.SerialPorts";

    private static synchronized boolean isSerialPortsKeySet() {
        return System.getProperties().containsKey(GNU_IO_RXTX_SERIAL_PORTS);
    }

    public static synchronized CommPortIdentifier getPortIdentifier(String port) throws NoSuchPortException {
        if (System.getProperty("os.name").toLowerCase().indexOf("linux") != -1) {
            SerialPortUtil.appendSerialPortProperty(port);
        }
        return CommPortIdentifier.getPortIdentifier((String)port);
    }

    private static synchronized void appendSerialPortProperty(String port) {
        String serialPortsProperty = System.getProperty(GNU_IO_RXTX_SERIAL_PORTS);
        String newValue = SerialPortUtil.initSerialPort(port, serialPortsProperty);
        if (newValue != null) {
            System.setProperty(GNU_IO_RXTX_SERIAL_PORTS, newValue);
        }
    }

    public static synchronized Stream<CommPortIdentifier> getPortIdentifiersUsingScan() {
        Enumeration identifiers;
        if (SerialPortUtil.isSerialPortsKeySet()) {
            String value = System.getProperty(GNU_IO_RXTX_SERIAL_PORTS);
            System.clearProperty(GNU_IO_RXTX_SERIAL_PORTS);
            identifiers = CommPortIdentifier.getPortIdentifiers();
            if (value != null) {
                System.setProperty(GNU_IO_RXTX_SERIAL_PORTS, value);
            }
        } else {
            identifiers = CommPortIdentifier.getPortIdentifiers();
        }
        return Collections.list(identifiers).stream();
    }

    public static synchronized Stream<CommPortIdentifier> getPortIdentifiersUsingProperty() {
        if (SerialPortUtil.isSerialPortsKeySet()) {
            return Collections.list(CommPortIdentifier.getPortIdentifiers()).stream();
        }
        return Stream.empty();
    }

    static @Nullable String initSerialPort(String port, @Nullable String serialPortsProperty) {
        String pathSeparator = File.pathSeparator;
        Set<String> serialPorts = serialPortsProperty != null ? Stream.of(serialPortsProperty.split(pathSeparator)).collect(Collectors.toSet()) : new HashSet<String>();
        if (serialPorts.add(port)) {
            return String.join((CharSequence)pathSeparator, serialPorts);
        }
        return null;
    }
}

