/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.nativeimage.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.nativeimage.api.debug.NIDebugger;
import org.netbeans.modules.nativeimage.api.debug.NILineBreakpointDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class JPDABreakpointsHandler
extends DebuggerManagerAdapter
implements PropertyChangeListener {
    private static final String SOURCES_FOLDER = "sources";
    private final File niFileSources;
    private final NIDebugger debugger;
    private final Set<JPDABreakpoint> attachedBreakpoints = new HashSet<JPDABreakpoint>();

    public JPDABreakpointsHandler(File niFile, NIDebugger debugger) {
        Breakpoint[] bs;
        this.niFileSources = JPDABreakpointsHandler.getNativeSources(niFile);
        this.debugger = debugger;
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        dm.addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        for (Breakpoint b : bs = dm.getBreakpoints()) {
            this.add(b);
        }
    }

    private static File getNativeSources(File niFile) {
        File sources = new File(niFile.getParentFile(), SOURCES_FOLDER);
        if (sources.isDirectory()) {
            return sources;
        }
        return null;
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.add(breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof JPDABreakpoint) {
            breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
            this.debugger.removeBreakpoint((Object)breakpoint);
            Set<JPDABreakpoint> set = this.attachedBreakpoints;
            synchronized (set) {
                this.attachedBreakpoints.remove(breakpoint);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (source instanceof JPDABreakpoint && !"disposed".equals(propertyName) && !"validity".equals(propertyName)) {
            this.added((JPDABreakpoint)source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Breakpoint b) {
        if (b instanceof JPDABreakpoint && !((JPDABreakpoint)b).isHidden()) {
            JPDABreakpoint jb = (JPDABreakpoint)b;
            jb.addPropertyChangeListener((PropertyChangeListener)this);
            Set<JPDABreakpoint> set = this.attachedBreakpoints;
            synchronized (set) {
                this.attachedBreakpoints.add(jb);
            }
            Breakpoint nativeBreakpoint = this.added(jb);
            if (nativeBreakpoint != null) {
                nativeBreakpoint.addPropertyChangeListener("validity", e -> {
                    Breakpoint.VALIDITY validity = nativeBreakpoint.getValidity();
                    String validityMessage = nativeBreakpoint.getValidityMessage();
                    ((ChangeListener)jb).stateChanged(new ValidityChanger(validity, validityMessage));
                });
            }
        }
    }

    private Breakpoint added(JPDABreakpoint b) {
        if (b instanceof LineBreakpoint) {
            URL url;
            LineBreakpoint lb = (LineBreakpoint)b;
            try {
                url = new URL(lb.getURL());
            }
            catch (MalformedURLException ex) {
                return null;
            }
            Object filePath = null;
            FileObject fo = URLMapper.findFileObject((URL)url);
            for (FileObject root : GlobalPathRegistry.getDefault().getSourceRoots()) {
                if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
                String path = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
                filePath = SOURCES_FOLDER + File.separator + path;
                break;
            }
            if (filePath == null) {
                try {
                    filePath = new File(url.toURI()).getAbsolutePath();
                }
                catch (URISyntaxException ex) {
                    return null;
                }
            }
            NILineBreakpointDescriptor niBreakpointDescriptor = NILineBreakpointDescriptor.newBuilder(filePath, (int)lb.getLineNumber()).condition(lb.getCondition()).enabled(lb.isEnabled()).hidden(true).build();
            Breakpoint nativeBreakpoint = this.debugger.addLineBreakpoint((Object)lb, niBreakpointDescriptor);
            return nativeBreakpoint;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Set<JPDABreakpoint> set = this.attachedBreakpoints;
        synchronized (set) {
            for (JPDABreakpoint jb : this.attachedBreakpoints) {
                jb.removePropertyChangeListener((PropertyChangeListener)this);
                this.debugger.removeBreakpoint((Object)jb);
                ((ChangeListener)jb).stateChanged(new ValidityChanger(Breakpoint.VALIDITY.UNKNOWN, null));
            }
            this.attachedBreakpoints.clear();
        }
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    private static class ValidityChanger
    extends ChangeEvent {
        private final String validityMessage;

        ValidityChanger(Breakpoint.VALIDITY validity, String validityMessage) {
            super(validity);
            this.validityMessage = validityMessage;
        }

        @Override
        public String toString() {
            return this.validityMessage;
        }
    }
}

