/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ui.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.modules.junit.api.JUnitSettings;
import org.netbeans.modules.junit.api.JUnitTestUtil;
import org.netbeans.modules.junit.api.JUnitUtils;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.ui.wizards.StepProblemMessage;
import org.netbeans.modules.junit.ui.wizards.TestSuiteStepLocation;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class TestSuiteWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wizard;
    private WizardDescriptor.Panel<WizardDescriptor> targetPanel;
    private Project lastSelectedProject = null;
    private WizardDescriptor.Panel optionsPanel;
    private SourceGroup[] testSrcGroups;

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.index = 0;
        this.panels = this.createPanels(wizard);
        this.loadSettings(wizard);
        String[] beforeSteps = null;
        Object prop = wizard.getProperty("WizardPanel_contentData");
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.wizard = null;
        this.targetPanel = null;
        this.lastSelectedProject = null;
        this.optionsPanel = null;
        this.testSrcGroups = null;
    }

    public Set<DataObject> instantiate() throws IOException {
        this.saveSettings(this.wizard);
        String name = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        FileObject testRootFolder = this.findTestRootFolder(targetFolder);
        assert (testRootFolder != null);
        DataObject suite = JUnitUtils.createSuiteTest((FileObject)testRootFolder, (FileObject)targetFolder, (String)name, (Map)JUnitTestUtil.getSettingsMap((boolean)true));
        if (suite != null) {
            return Collections.singleton(suite);
        }
        throw new IOException();
    }

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        return new WizardDescriptor.Panel[]{this.getTargetPanel()};
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        assert (panels != null);
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    private FileObject findTestRootFolder(FileObject targetFolder) {
        for (int i = 0; i < this.testSrcGroups.length; ++i) {
            FileObject rootFolder = this.testSrcGroups[i].getRootFolder();
            if (rootFolder != targetFolder && !FileUtil.isParentOf((FileObject)rootFolder, (FileObject)targetFolder)) continue;
            return rootFolder;
        }
        return null;
    }

    private WizardDescriptor.Panel<WizardDescriptor> getTargetPanel() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (project == null) {
            return new StepProblemMessage(project, NbBundle.getMessage(this.getClass(), (String)"MSG_UnsupportedPlugin"));
        }
        if (this.targetPanel == null || project != this.lastSelectedProject) {
            JUnitPlugin plugin = JUnitTestUtil.getPluginForProject((Project)project);
            if (JUnitUtils.isInstanceOfDefaultPlugin((JUnitPlugin)plugin)) {
                this.targetPanel = new StepProblemMessage(project, NbBundle.getMessage(TestSuiteWizardIterator.class, (String)"MSG_UnsupportedPlugin"));
            } else {
                Collection sourceGroups = JUnitUtils.getTestTargets((Project)project, (boolean)true);
                if (sourceGroups.isEmpty() && SourceGroupModifier.createSourceGroup((Project)project, (String)"java", (String)"test") != null) {
                    sourceGroups = JUnitUtils.getTestTargets((Project)project, (boolean)true);
                }
                if (sourceGroups.isEmpty()) {
                    this.targetPanel = new StepProblemMessage(project, NbBundle.getMessage(TestSuiteWizardIterator.class, (String)"MSG_NoTestSourceGroup"));
                } else {
                    this.testSrcGroups = new SourceGroup[sourceGroups.size()];
                    sourceGroups.toArray(this.testSrcGroups);
                    if (this.optionsPanel == null) {
                        this.optionsPanel = new TestSuiteStepLocation();
                    }
                    this.targetPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])this.testSrcGroups, (WizardDescriptor.Panel)this.optionsPanel);
                }
            }
            this.lastSelectedProject = project;
        }
        return this.targetPanel;
    }

    private void loadSettings(WizardDescriptor wizard) {
        JUnitSettings settings = JUnitSettings.getDefault();
        wizard.putProperty("SetUp", (Object)settings.isGenerateSetUp());
        wizard.putProperty("TearDown", (Object)settings.isGenerateTearDown());
        wizard.putProperty("BeforeClass", (Object)settings.isGenerateClassSetUp());
        wizard.putProperty("AfterClass", (Object)settings.isGenerateClassTearDown());
        wizard.putProperty("Comments", (Object)settings.isBodyComments());
    }

    private void saveSettings(WizardDescriptor wizard) {
        JUnitSettings settings = JUnitSettings.getDefault();
        settings.setGenerateSetUp(Boolean.TRUE.equals(wizard.getProperty("SetUp")));
        settings.setGenerateTearDown(Boolean.TRUE.equals(wizard.getProperty("TearDown")));
        settings.setGenerateClassSetUp(Boolean.TRUE.equals(wizard.getProperty("BeforeClass")));
        settings.setGenerateClassTearDown(Boolean.TRUE.equals(wizard.getProperty("AfterClass")));
        settings.setBodyComments(Boolean.TRUE.equals(wizard.getProperty("Comments")));
    }
}

