/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.netbeans.modules.project.dependency.spi.ProjectReloadImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class MavenReloadImplementation
implements ProjectReloadImplementation,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(MavenReloadImplementation.class.getName());
    private final Project project;
    private volatile Reference<ProjectReloadImplementation.ProjectStateData> lastData = new WeakReference<Object>(null);

    public MavenReloadImplementation(Project project) {
        this.project = project;
        NbMavenProject.addPropertyChangeListener(project, WeakListeners.propertyChange((PropertyChangeListener)this, (Object)project));
    }

    public void projectDataReleased(ProjectReloadImplementation.ProjectStateData data) {
        if (this.lastData.get() == data) {
            this.lastData.clear();
        }
    }

    ProjectReloadImplementation.ProjectStateData getLastCachedData() {
        return this.lastData.get();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null) {
            return;
        }
        ProjectReloadImplementation.ProjectStateData st = this.lastData.get();
        if (st == null) {
            return;
        }
        if ("MavenProject".equals(evt.getPropertyName())) {
            st.fireChanged(true, false);
        }
    }

    public Set<FileObject> findProjectFiles() {
        NbMavenProject p = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        return this.findProjectFiles0(p.getMavenProject());
    }

    Set<FileObject> findProjectFiles0(MavenProject mp) {
        File pomFile = mp.getFile();
        HashSet<FileObject> fileSet = new HashSet<FileObject>();
        fileSet.add(FileUtil.toFileObject((File)pomFile));
        MavenExecutionRequest rq = EmbedderFactory.getProjectEmbedder().createMavenExecutionRequest();
        File userSettings = rq.getUserSettingsFile();
        File toolchains = rq.getGlobalToolchainsFile();
        File globalSettings = rq.getGlobalSettingsFile();
        if (userSettings != null && userSettings.exists()) {
            fileSet.add(FileUtil.toFileObject((File)userSettings));
        }
        if (toolchains != null && toolchains.exists()) {
            fileSet.add(FileUtil.toFileObject((File)toolchains));
        }
        if (globalSettings != null && globalSettings.exists()) {
            fileSet.add(FileUtil.toFileObject((File)globalSettings));
        }
        HashSet<Artifact> processed = new HashSet<Artifact>();
        ArrayDeque<Artifact> toProcess = new ArrayDeque<Artifact>();
        Artifact a = mp.getParentArtifact();
        if (a != null) {
            toProcess.add(a);
        }
        toProcess.addAll(mp.getArtifacts());
        while ((a = (Artifact)toProcess.poll()) != null) {
            NbMavenProject p2;
            File pom;
            if (!processed.add(a) || (pom = MavenFileOwnerQueryImpl.getInstance().getOwnerPOM(a.getGroupId(), a.getArtifactId(), a.getVersion())) == null) continue;
            Project parentOwner = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)pom));
            FileObject parentPom = parentOwner.getProjectDirectory().getFileObject("pom.xml");
            if (parentPom != null) {
                fileSet.add(parentPom);
            }
            if ((a = (p2 = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getParentArtifact()) != null) {
                toProcess.add(a);
            }
            toProcess.addAll(p2.getMavenProject().getArtifacts());
        }
        return fileSet;
    }

    static ProjectReload.Quality getProjectQuality(MavenProject mp) {
        if (mp == null) {
            return ProjectReload.Quality.NONE;
        }
        if (MavenProjectCache.isFallbackproject(mp)) {
            MavenProject fallback = MavenProjectCache.getPartialProject(mp);
            return fallback != null ? ProjectReload.Quality.BROKEN : ProjectReload.Quality.FALLBACK;
        }
        if (!MavenProjectCache.getPlaceholderArtifacts(mp).isEmpty()) {
            return ProjectReload.Quality.LOADED;
        }
        return ProjectReload.Quality.RESOLVED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectReloadImplementation.ProjectStateData createStateData(MavenProject mp, ProjectReload.Quality q) {
        if (q == null) {
            q = MavenReloadImplementation.getProjectQuality(mp);
        }
        ProjectReloadImplementation.ProjectStateBuilder builder = ProjectReloadImplementation.ProjectStateData.builder((ProjectReload.Quality)q).files(this.findProjectFiles()).timestamp(MavenProjectCache.getLoadTimestamp(mp));
        builder.data((Object)mp);
        builder.attachLookup(Lookups.fixed((Object[])new Object[]{mp}));
        ProjectReloadImplementation.ProjectStateData d = builder.build();
        MavenReloadImplementation mavenReloadImplementation = this;
        synchronized (mavenReloadImplementation) {
            ProjectReloadImplementation.ProjectStateData d2 = this.lastData.get();
            if (d2 != null) {
                if (d2.getProjectData() == mp) {
                    return d2;
                }
                d2.fireChanged(true, false);
            }
            this.lastData = new WeakReference<ProjectReloadImplementation.ProjectStateData>(d);
        }
        return d;
    }

    public CompletableFuture reload(Project project, ProjectReload.StateRequest request, ProjectReloadImplementation.LoadContext context) {
        CF cf = new CF();
        this.loadMavenProject(request, cf);
        return cf;
    }

    private void loadMavenProject(ProjectReload.StateRequest request, CF future) {
        NbMavenProjectImpl nbImpl = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
        if (!request.isForceReload()) {
            if (request.isConsistent()) {
                nbImpl.getFreshOriginalMavenProject().thenAccept(mp -> this.loadMavenProject2((MavenProject)mp, request, future));
            } else {
                MavenProject mp2 = nbImpl.getOriginalMavenProjectOrNull();
                if (mp2 != null) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Got already loaded Maven project {0}@{1}", new Object[]{mp2, Integer.toHexString(System.identityHashCode(mp2))});
                    }
                    this.loadMavenProject2(mp2, request, future);
                }
            }
            return;
        }
        this.loadMavenProject3(future);
    }

    private void loadMavenProject2(MavenProject p, ProjectReload.StateRequest request, CF future) {
        if (p != null) {
            ProjectReload.Quality q = MavenReloadImplementation.getProjectQuality(p);
            long ts = MavenProjectCache.getLoadTimestamp(p);
            LOG.log(Level.FINE, "Got Maven Project {0}@{1}, with quality {2}, timestamp {3}", new Object[]{p, Integer.toHexString(System.identityHashCode(p)), q, ts});
            if (q.isAtLeast(request.getMinQuality()) && !request.isConsistent()) {
                future.complete(this.createStateData(p, null));
                return;
            }
            Set<FileObject> fos = this.findProjectFiles0(p);
            boolean obsolete = false;
            for (FileObject f : fos) {
                if (f.lastModified().getTime() <= ts) continue;
                LOG.log(Level.FINE, "Maven Project {0}@{1} is obsolete because of {2}, file stamp: {3}", new Object[]{p, Integer.toHexString(System.identityHashCode(p)), f, f.lastModified().getTime()});
                obsolete = true;
            }
            if (!obsolete) {
                future.complete(this.createStateData(p, null));
                return;
            }
        }
        this.loadMavenProject3(future);
    }

    private void loadMavenProject3(final CF future) {
        final NbMavenProjectImpl nbImpl = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
        final MavenProject current = nbImpl.getOriginalMavenProjectOrNull();
        RequestProcessor.Task t = nbImpl.fireProjectReload(true);
        LOG.log(Level.FINE, "Scheduled project reload: {0}", t);
        t.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                task.removeTaskListener((TaskListener)this);
                ((CompletableFuture)nbImpl.getFreshOriginalMavenProject().thenAccept(mp -> {
                    if (LOG.isLoggable(Level.FINE)) {
                        ProjectReload.Quality q = MavenReloadImplementation.getProjectQuality(mp);
                        long ts = MavenProjectCache.getLoadTimestamp(mp);
                        LOG.log(Level.FINE, "Reloaded Maven project {0}@{1}, with quality {2}, timestamp {3}", new Object[]{mp, Integer.toHexString(System.identityHashCode(mp)), q, ts});
                    }
                    future.complete(MavenReloadImplementation.this.createStateData((MavenProject)mp, null));
                })).exceptionally(ex -> {
                    MavenProject renewed = nbImpl.getOriginalMavenProjectOrNull();
                    LOG.log(Level.FINE, "Failed to load maven project, got {0}, previous {1}", new Object[]{renewed, current});
                    if (renewed == current) {
                        ProjectReloadImplementation.ProjectStateData sd = MavenReloadImplementation.this.createStateData(current, ProjectReload.Quality.BROKEN);
                        sd.fireChanged(false, true);
                        future.complete(sd);
                    } else {
                        future.complete(MavenReloadImplementation.this.createStateData(renewed, ProjectReload.Quality.BROKEN));
                    }
                    return null;
                });
            }
        });
    }

    private static class CF
    extends CompletableFuture<ProjectReloadImplementation.ProjectStateData<MavenProject>> {
        private CF() {
        }
    }
}

