/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.owsm;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javaee.specs.support.api.JaxWsPoliciesSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.core.jaxws.policies.JaxWsPoliciesCodeGenerator;
import org.netbeans.modules.websvc.owsm.OWSMPolicyCodeGenerator;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class OWSMPoliciesCodeGenerator
implements JaxWsPoliciesCodeGenerator {
    private static final String ORACLE = "oracle/";
    private static final String SECURITY_POLICY_FEATURE = "weblogic.wsee.jws.jaxws.owsm.SecurityPolicyFeature";
    private static final String SECURITY_FEATURE_INIT = "private static final SecurityPolicyFeature[] securityFeature = new SecurityPolicyFeature[] { new SecurityPolicyFeature(\"";
    private static Map<String, OWSMPolicyCodeGenerator> GENERATORS = new HashMap<String, OWSMPolicyCodeGenerator>();

    public Collection<String> getRequiredClasses(String id) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(SECURITY_POLICY_FEATURE);
        result.add("com.sun.xml.ws.developer.WSBindingProvider");
        result.add("javax.xml.ws.BindingProvider");
        result.add("javax.xml.ws.WebServiceFeature");
        result.add(Map.class.getCanonicalName());
        OWSMPolicyCodeGenerator generator = GENERATORS.get(id);
        if (generator != null) {
            generator.addRequiredClassesFqns(result);
        }
        return result;
    }

    public String generatePolicyAccessCode(Set<String> policyIds, Client client, StringBuilder code) {
        if (policyIds.isEmpty()) {
            return "";
        }
        HashMap<String, OWSMPolicyCodeGenerator> map = new HashMap<String, OWSMPolicyCodeGenerator>(GENERATORS);
        Set keySet = map.keySet();
        keySet.retainAll(policyIds);
        if (keySet.isEmpty()) {
            String id = policyIds.iterator().next();
            this.generateDefaultCode(id, client, code);
            return id;
        }
        String mainId = null;
        for (Map.Entry entry : map.entrySet()) {
            String id = (String)entry.getKey();
            OWSMPolicyCodeGenerator generator = (OWSMPolicyCodeGenerator)entry.getValue();
            if (mainId == null) {
                mainId = id;
                generator.generatePolicyAccessCode(code, client);
                continue;
            }
            StringBuilder builder = new StringBuilder();
            generator.generatePolicyAccessCode(builder, client);
            code.append("/* ");
            code.append(builder.toString());
            code.append(" */");
        }
        return mainId;
    }

    public boolean isApplicable(Set<String> policyIds, J2eePlatform platform, FileObject wsdl) {
        boolean result;
        JaxWsPoliciesSupport support = JaxWsPoliciesSupport.getInstance((J2eePlatform)platform);
        if (support == null) {
            return false;
        }
        String id = support.getId();
        boolean bl = result = id != null && ORACLE.startsWith(id) && id.length() == ORACLE.length() - 1;
        if (result) {
            policyIds.retainAll(GENERATORS.keySet());
        }
        return result;
    }

    public Tree createSecurityFeatureType(WorkingCopy workingCopy, TreeMaker make) {
        return make.ArrayType(this.createSecurityFeatureComponentType(workingCopy, make));
    }

    private Tree createSecurityFeatureComponentType(WorkingCopy workingCopy, TreeMaker make) {
        TypeElement securityType = workingCopy.getElements().getTypeElement(SECURITY_POLICY_FEATURE);
        Tree securityTreeType = securityType != null ? make.Type(securityType.asType()) : make.Identifier((CharSequence)SECURITY_POLICY_FEATURE);
        return securityTreeType;
    }

    private void generateDefaultCode(String id, Client client, StringBuilder code) {
        code.append("WSBindingProvider wsbp = (WSBindingProvider)port;\n");
        code.append("Map<String, Object> requestContext = wsbp.getRequestContext();\n");
        code.append("// Override the endpoint - useful when switching target environments without regenerating the jax-ws client\n");
        code.append("requestContext.put(WSBindingProvider.ENDPOINT_ADDRESS_PROPERTY, \"");
        code.append(client.getWsdlUrl());
        code.append("\");\n");
        code.append("// Use request context to initialize poliy access \n");
        code.append("//requestContext.put( some_property_key,  some_property_value );\n");
    }

    public ExpressionTree createSecurityFeatureInitializer(WorkingCopy workingCopy, TreeMaker make, String id) {
        String clientId = id;
        OWSMPolicyCodeGenerator generator = GENERATORS.get(id);
        if (generator != null) {
            clientId = generator.getClientId();
        }
        if (!clientId.startsWith(ORACLE)) {
            clientId = ORACLE + clientId;
        }
        TypeElement securityType = workingCopy.getElements().getTypeElement(SECURITY_POLICY_FEATURE);
        NewClassTree initClassTree = make.NewClass(null, Collections.emptyList(), (ExpressionTree)(securityType != null ? make.Identifier((Element)securityType) : make.Identifier((CharSequence)SECURITY_POLICY_FEATURE)), Collections.singletonList(make.Literal((Object)clientId)), null);
        return make.NewArray(this.createSecurityFeatureComponentType(workingCopy, make), Collections.emptyList(), Collections.singletonList(initClassTree));
    }

    public void modifySecurityFeatureAttribute(VariableTree var, WorkingCopy workingCopy, TreeMaker make, String id, Set<String> ids) {
        LinkedList<String> clientIds = new LinkedList<String>();
        HashSet<String> otherIds = new HashSet<String>(ids);
        otherIds.remove(id);
        HashMap<String, OWSMPolicyCodeGenerator> map = new HashMap<String, OWSMPolicyCodeGenerator>(GENERATORS);
        Set keySet = map.keySet();
        keySet.retainAll(otherIds);
        for (OWSMPolicyCodeGenerator generator : map.values()) {
            clientIds.add(generator.getClientId());
        }
        OWSMPolicyCodeGenerator generator = GENERATORS.get(id);
        if (generator != null) {
            for (String relatedId : generator.getRelatedPolicyIds()) {
                clientIds.add(relatedId);
            }
        }
        this.addComments(var, make, clientIds);
    }

    private void addComments(VariableTree var, TreeMaker make, Collection<String> ids) {
        for (String relatedId : ids) {
            if (!relatedId.startsWith(ORACLE)) {
                relatedId = ORACLE + relatedId;
            }
            StringBuilder builder = new StringBuilder(SECURITY_FEATURE_INIT);
            builder.append(relatedId);
            builder.append("\")};\n");
            make.addComment((Tree)var, Comment.create((Comment.Style)Comment.Style.LINE, (String)builder.toString()), true);
        }
    }

    private static void initGenerators() {
        Collection generators = Lookup.getDefault().lookupAll(OWSMPolicyCodeGenerator.class);
        for (OWSMPolicyCodeGenerator generator : generators) {
            GENERATORS.put(generator.getId(), generator);
        }
    }

    static {
        OWSMPoliciesCodeGenerator.initGenerators();
    }
}

