/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.eval.ui;

import java.util.List;
import javax.swing.JEditorPane;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.javascript.debugger.locals.VariablesModel;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.openide.util.RequestProcessor;

public class WebCodeEvaluator
extends CodeEvaluator.EvaluatorService {
    private final Debugger debugger;
    private final CodeEvaluator.DefaultExpressionsHistoryPersistence historyPersistence;
    private String expression;
    private static RequestProcessor rp = new RequestProcessor("Debugger Evaluator", 1);
    private final RequestProcessor.Task evalTask = rp.create((Runnable)new EvaluateTask());
    private CodeEvaluator.Result<VariablesModel.ScopedRemoteObject, CodeEvaluator.Result.DefaultHistoryItem> result;

    public WebCodeEvaluator(ContextProvider contextProvider) {
        this.debugger = (Debugger)contextProvider.lookupFirst(null, Debugger.class);
        this.historyPersistence = CodeEvaluator.DefaultExpressionsHistoryPersistence.create((String)"javascript-debuggerengine");
        this.result = CodeEvaluator.Result.get((DebuggerEngine)((DebuggerEngine)contextProvider.lookupFirst(null, DebuggerEngine.class)));
    }

    public void setupContext(JEditorPane editorPane, Runnable contextSetUp) {
        MiscEditorUtil.setupContext(editorPane, contextSetUp);
    }

    public boolean canEvaluate() {
        return this.debugger.isEnabled() && this.debugger.isSuspended() && this.debugger.getCurrentCallFrame() != null;
    }

    public void evaluate(String expression) {
        this.expression = expression;
        this.evalTask.schedule(0);
    }

    private String getExpression() {
        return this.expression;
    }

    public List<String> getExpressionsHistory() {
        return this.historyPersistence.getExpressions();
    }

    private class EvaluateTask
    implements Runnable {
        private EvaluateTask() {
        }

        @Override
        public void run() {
            String exp = WebCodeEvaluator.this.getExpression();
            if (exp == null || "".equals(exp)) {
                return;
            }
            CallFrame frame = WebCodeEvaluator.this.debugger.getCurrentCallFrame();
            if (frame != null) {
                RemoteObject ro = frame.evaluate(exp);
                VariablesModel.ScopedRemoteObject var = ro != null ? new VariablesModel.ScopedRemoteObject(ro, exp, VariablesModel.ViewScope.LOCAL) : null;
                WebCodeEvaluator.this.result.setAndOpen(exp, (Object)var, (Object)this.getHistoryItem(exp, var));
                WebCodeEvaluator.this.historyPersistence.addExpression(exp);
                WebCodeEvaluator.this.firePropertyChange("expressionsHistory", null, null);
            }
        }

        private CodeEvaluator.Result.DefaultHistoryItem getHistoryItem(String expr, VariablesModel.ScopedRemoteObject result) {
            if (result != null) {
                String clazz;
                RemoteObject var = result.getRemoteObject();
                RemoteObject.Type type = var.getType();
                String typeStr = type == RemoteObject.Type.OBJECT ? ((clazz = var.getClassName()) == null ? type.getName() : clazz) : type.getName();
                String value = var.getValueAsString();
                if (value.isEmpty() && (type == RemoteObject.Type.OBJECT || type == RemoteObject.Type.FUNCTION)) {
                    value = var.getDescription();
                }
                String toString = var.getValueAsString();
                return new CodeEvaluator.Result.DefaultHistoryItem(expr, typeStr, value, toString);
            }
            return null;
        }
    }
}

