/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.ui.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.spi.framework.actions.GoToViewAction;
import org.netbeans.modules.php.symfony2.preferences.SymfonyPreferences;
import org.netbeans.modules.php.symfony2.util.SymfonyUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

final class SymfonyGoToViewAction
extends GoToViewAction {
    private static final Logger LOGGER = Logger.getLogger(SymfonyGoToViewAction.class.getName());
    private final PhpModule phpModule;
    private final FileObject controller;
    private final int offset;

    SymfonyGoToViewAction(PhpModule phpModule, FileObject controller, int offset) {
        assert (phpModule != null);
        assert (controller != null);
        this.phpModule = phpModule;
        this.controller = controller;
        this.offset = offset;
    }

    public boolean goToView() {
        FileObject sources = this.phpModule.getSourceDirectory();
        if (sources == null) {
            LOGGER.log(Level.INFO, "No Source Files for project {0}", this.phpModule.getDisplayName());
            return false;
        }
        FileObject appDir = sources.getFileObject(SymfonyPreferences.getAppDir(this.phpModule));
        if (appDir == null) {
            LOGGER.log(Level.INFO, "No App dir for project {0}", this.phpModule.getDisplayName());
            return false;
        }
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        PhpBaseElement phpElement = editorSupport.getElement(this.controller, this.offset);
        if (phpElement == null) {
            return false;
        }
        FileObject view = SymfonyUtils.getView(this.controller, appDir, phpElement);
        if (view != null) {
            UiUtils.open((FileObject)view, (int)0);
            return true;
        }
        return false;
    }
}

