/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class NodeRegistry
implements ChangeListener {
    private static final String PATH = "Databases/Explorer/";
    private static final String NODEPROVIDERS = "/NodeProviders";
    private final ChangeSupport changeSupport;
    private final List<NodeProvider> providers = new CopyOnWriteArrayList<NodeProvider>();
    private Lookup.Result lookupResult;
    private LookupListener lookupListener;

    public static NodeRegistry create(String folder, NodeDataLookup dataLookup) {
        NodeRegistry registry = new NodeRegistry();
        registry.init(folder, (Lookup)dataLookup);
        return registry;
    }

    private NodeRegistry() {
        this.changeSupport = new ChangeSupport((Object)this);
    }

    private void init(String folder, final Lookup dataLookup) {
        Lookup lookup = Lookups.forPath((String)(PATH + folder + NODEPROVIDERS));
        this.lookupResult = lookup.lookupResult(NodeProviderFactory.class);
        this.initProviders(dataLookup);
        this.lookupListener = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                NodeRegistry.this.initProviders(dataLookup);
                NodeRegistry.this.changeSupport.fireChange();
            }
        };
        this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, (Object)this.lookupResult));
    }

    private void initProviders(Lookup lookup) {
        this.providers.clear();
        Collection factoryList = this.lookupResult.allInstances();
        for (NodeProviderFactory factory : factoryList) {
            NodeProvider provider = factory.createInstance(lookup);
            provider.addChangeListener(this);
            this.providers.add(provider);
        }
    }

    public synchronized void refresh() {
        for (NodeProvider provider : this.providers) {
            provider.refresh();
        }
    }

    public synchronized void removeAllNodes() {
        for (NodeProvider provider : this.providers) {
            provider.removeAllNodes();
        }
    }

    public synchronized Collection<? extends Node> getNodes() {
        ArrayList<Node> results = new ArrayList<Node>();
        for (NodeProvider provider : this.providers) {
            results.addAll(provider.getNodes());
        }
        return Collections.unmodifiableCollection(results);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.changeSupport.fireChange();
    }

    public static synchronized void handleMetadataModelException(Class<?> clazz, DatabaseConnection connection, MetadataModelException e, boolean closeConnectionIfBroken) {
        Logger.getLogger(clazz.getName()).log(Level.FINE, e.getLocalizedMessage(), e);
        if (connection == null) {
            return;
        }
        if (!connection.isVitalConnection()) {
            try {
                if (connection.isConnected() && closeConnectionIfBroken) {
                    Object msg = e.getCause().getLocalizedMessage();
                    if (((String)msg).length() > 280) {
                        msg = ((String)msg).substring(0, 280) + NbBundle.getMessage(NodeRegistry.class, (String)"NodeRegistry_CloseBrokenConnectionMore");
                    }
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(NodeRegistry.class, (String)"NodeRegistry_CloseBrokenConnection", (Object)connection.getName(), (Object)msg)));
                    connection.disconnect();
                }
            }
            catch (DatabaseException ex) {
                Logger.getLogger(clazz.getName()).log(Level.INFO, "While disconnecting a broken connection: " + connection + " was thrown " + ex.getLocalizedMessage(), ex);
            }
        }
    }
}

