/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.jsp.tagext.PageData;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageDataImpl;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.Validator;

public class NbValidator {
    private static final Logger LOGGER = Logger.getLogger(NbValidator.class.getName());
    private static Method validateXmlViewM;
    private static Field bufF;

    private static void initReflection() {
        try {
            validateXmlViewM = Validator.class.getDeclaredMethod("validateXmlView", PageData.class, Compiler.class);
            validateXmlViewM.setAccessible(true);
            bufF = PageDataImpl.class.getDeclaredField("buf");
            bufF.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (NoSuchFieldException e) {
            LOGGER.log(Level.INFO, null, e);
        }
    }

    public static String validate(Compiler compiler, Node.Nodes page) throws JasperException {
        page.visit((Node.Visitor)new Validator.DirectiveVisitor(compiler));
        PageInfo pageInfo = compiler.getPageInfo();
        String contentType = pageInfo.getContentType();
        if (contentType == null || contentType.indexOf("charset=") < 0) {
            boolean isXml = page.getRoot().isXmlSyntax();
            String defaultType = contentType == null ? (isXml ? "text/xml" : "text/html") : contentType;
            String charset = null;
            if (isXml) {
                charset = "UTF-8";
            } else if (!page.getRoot().isDefaultPageEncoding()) {
                charset = page.getRoot().getPageEncoding();
            }
            if (charset != null) {
                pageInfo.setContentType(defaultType + ";charset=" + charset);
            } else {
                pageInfo.setContentType(defaultType);
            }
        }
        page.visit((Node.Visitor)new Validator.ValidateVisitor(compiler));
        try {
            PageDataImpl pdi = new PageDataImpl(page, compiler);
            validateXmlViewM.invoke(null, pdi, compiler);
            page.visit((Node.Visitor)new Validator.TagExtraInfoVisitor(compiler));
            StringBuilder sb = (StringBuilder)bufF.get(pdi);
            return sb.toString();
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.INFO, null, e);
            throw new JasperException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof JasperException) {
                throw (JasperException)target;
            }
            LOGGER.log(Level.INFO, null, e);
            throw new JasperException(e.getMessage());
        }
    }

    static {
        NbValidator.initReflection();
    }
}

