/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.plugins.InnerToOuterTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class InnerToOuterRefactoringPlugin
extends JavaRefactoringPlugin {
    private final InnerToOuterRefactoring refactoring;
    private TreePathHandle treePathHandle;

    InnerToOuterRefactoringPlugin(InnerToOuterRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            case PRECHECK: {
                ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
                return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
            }
        }
        return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
    }

    @Override
    protected Problem preCheck(CompilationController info) throws IOException {
        this.fireProgressListenerStart(1, 4);
        Problem preCheckProblem = null;
        info.toPhase(JavaSource.Phase.RESOLVED);
        Element el = this.treePathHandle.resolveElement((CompilationInfo)info);
        TreePathHandle sourceType = this.refactoring.getSourceType();
        Problem result = InnerToOuterRefactoringPlugin.isElementAvail(sourceType, (CompilationInfo)info);
        if (result != null) {
            return result;
        }
        result = JavaPluginUtils.isSourceElement(el, (CompilationInfo)info);
        if (result != null) {
            return result;
        }
        this.refactoring.setClassName(sourceType.resolveElement((CompilationInfo)info).getSimpleName().toString());
        this.fireProgressListenerStep();
        if (el instanceof TypeElement) {
            if (((TypeElement)el).getNestingKind() == NestingKind.ANONYMOUS) {
                preCheckProblem = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_Anonymous"));
                return preCheckProblem;
            }
            if (!((TypeElement)el).getNestingKind().isNested()) {
                preCheckProblem = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_MustBeInnerClass"));
                return preCheckProblem;
            }
        } else {
            preCheckProblem = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_MustBeInnerClass"));
            return preCheckProblem;
        }
        this.fireProgressListenerStep();
        this.fireProgressListenerStop();
        return preCheckProblem;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Problem fastCheckParameters(CompilationController javac) throws IOException {
        Problem problem = null;
        String name = this.refactoring.getReferenceName();
        javac.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        Element resolved = this.refactoring.getSourceType().resolveElement((CompilationInfo)javac);
        if (resolved != null && resolved.getKind().isClass()) {
            TypeElement outer;
            Element element;
            String className;
            if (name != null) {
                List<VariableElement> fieldsIn = ElementFilter.fieldsIn(((TypeElement)resolved).getEnclosedElements());
                for (VariableElement variableElement : fieldsIn) {
                    if (!variableElement.getSimpleName().toString().equals(name)) continue;
                    problem = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_OuterNameAlreadyUsed", (Object)name, (Object)variableElement.getEnclosingElement().getSimpleName()));
                    return problem;
                }
                fieldsIn = ElementFilter.fieldsIn(javac.getElements().getAllMembers((TypeElement)resolved));
                for (VariableElement variableElement : fieldsIn) {
                    if (!variableElement.getSimpleName().toString().equals(name)) continue;
                    problem = new Problem(false, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"WRN_OuterNameAlreadyUsed", (Object)name, (Object)variableElement.getEnclosingElement().getSimpleName()));
                    break;
                }
                List<ExecutableElement> constructors = ElementFilter.constructorsIn(((TypeElement)resolved).getEnclosedElements());
                for (ExecutableElement execElement : constructors) {
                    List<? extends VariableElement> parameters = execElement.getParameters();
                    for (VariableElement variableElement : parameters) {
                        if (!variableElement.getSimpleName().toString().equals(name)) continue;
                        return new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_OuterNameClash", (Object)name, (Object)resolved.getSimpleName()));
                    }
                }
            }
            if ((className = this.refactoring.getClassName()) != null && (element = (outer = javac.getElementUtilities().enclosingTypeElement(resolved)).getEnclosingElement()).getKind() != ElementKind.PACKAGE) {
                void var7_13;
                if (!element.getKind().isClass()) {
                    TypeElement typeElement = javac.getElementUtilities().enclosingTypeElement(element);
                }
                List<TypeElement> types = ElementFilter.typesIn(javac.getElements().getAllMembers((TypeElement)var7_13));
                for (TypeElement type : types) {
                    if (!className.contentEquals(type.getSimpleName()) || type == resolved) continue;
                    return new Problem(true, Bundle.ERR_InnerToOuter_ClassNameClash(className));
                }
            }
        }
        return problem;
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject[] children;
        Problem result = null;
        String newName = this.refactoring.getClassName();
        if (!Utilities.isJavaIdentifier((String)newName)) {
            result = InnerToOuterRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)newName));
            return result;
        }
        String referenceName = this.refactoring.getReferenceName();
        if (referenceName != null) {
            if (referenceName.length() < 1) {
                result = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_EmptyReferenceName"));
                return result;
            }
            if (!Utilities.isJavaIdentifier((String)referenceName)) {
                result = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)referenceName));
                return result;
            }
        }
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        FileObject folder = primFile.getParent();
        for (FileObject child : children = folder.getChildren()) {
            if (child.isVirtual() || !child.getName().equals(newName) || !"java".equals(child.getExt())) continue;
            result = InnerToOuterRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)newName, (Object)folder.getName()));
            return result;
        }
        return super.fastCheckParameters();
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        LinkedHashSet<FileObject> set = new LinkedHashSet<FileObject>();
        set.add(this.refactoring.getSourceType().getFileObject());
        ClassIndex idx = cpInfo.getClassIndex();
        set.addAll(idx.getResources(this.refactoring.getSourceType().getElementHandle(), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        return set;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(3, a.size());
        InnerToOuterTransformer innerToOuter = new InnerToOuterTransformer(this.refactoring);
        JavaRefactoringPlugin.TransformTask transform = new JavaRefactoringPlugin.TransformTask(this, innerToOuter, this.refactoring.getSourceType());
        Problem problem = this.createAndAddElements(a, transform, refactoringElements, this.refactoring);
        this.fireProgressListenerStop();
        return problem != null ? problem : innerToOuter.getProblem();
    }
}

