/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetFastConnectProviderServiceKeyRequest
extends BmcRequest<Void> {
    private String providerServiceId;
    private String providerServiceKeyName;

    public String getProviderServiceId() {
        return this.providerServiceId;
    }

    public String getProviderServiceKeyName() {
        return this.providerServiceKeyName;
    }

    public Builder toBuilder() {
        return new Builder().providerServiceId(this.providerServiceId).providerServiceKeyName(this.providerServiceKeyName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",providerServiceId=").append(String.valueOf(this.providerServiceId));
        sb.append(",providerServiceKeyName=").append(String.valueOf(this.providerServiceKeyName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFastConnectProviderServiceKeyRequest)) {
            return false;
        }
        GetFastConnectProviderServiceKeyRequest other = (GetFastConnectProviderServiceKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.providerServiceId, other.providerServiceId) && Objects.equals(this.providerServiceKeyName, other.providerServiceKeyName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.providerServiceId == null ? 43 : this.providerServiceId.hashCode());
        result = result * 59 + (this.providerServiceKeyName == null ? 43 : this.providerServiceKeyName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetFastConnectProviderServiceKeyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String providerServiceId = null;
        private String providerServiceKeyName = null;

        public Builder providerServiceId(String providerServiceId) {
            this.providerServiceId = providerServiceId;
            return this;
        }

        public Builder providerServiceKeyName(String providerServiceKeyName) {
            this.providerServiceKeyName = providerServiceKeyName;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFastConnectProviderServiceKeyRequest o) {
            this.providerServiceId(o.getProviderServiceId());
            this.providerServiceKeyName(o.getProviderServiceKeyName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFastConnectProviderServiceKeyRequest build() {
            GetFastConnectProviderServiceKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetFastConnectProviderServiceKeyRequest buildWithoutInvocationCallback() {
            GetFastConnectProviderServiceKeyRequest request = new GetFastConnectProviderServiceKeyRequest();
            request.providerServiceId = this.providerServiceId;
            request.providerServiceKeyName = this.providerServiceKeyName;
            return request;
        }
    }
}

