/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.ImageMemoryConstraints;
import com.oracle.bmc.core.model.ImageOcpuConstraints;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ImageShapeCompatibilitySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="imageId")
    private final String imageId;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="memoryConstraints")
    private final ImageMemoryConstraints memoryConstraints;
    @JsonProperty(value="ocpuConstraints")
    private final ImageOcpuConstraints ocpuConstraints;

    @Deprecated
    @ConstructorProperties(value={"imageId", "shape", "memoryConstraints", "ocpuConstraints"})
    public ImageShapeCompatibilitySummary(String imageId, String shape, ImageMemoryConstraints memoryConstraints, ImageOcpuConstraints ocpuConstraints) {
        this.imageId = imageId;
        this.shape = shape;
        this.memoryConstraints = memoryConstraints;
        this.ocpuConstraints = ocpuConstraints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getShape() {
        return this.shape;
    }

    public ImageMemoryConstraints getMemoryConstraints() {
        return this.memoryConstraints;
    }

    public ImageOcpuConstraints getOcpuConstraints() {
        return this.ocpuConstraints;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImageShapeCompatibilitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("imageId=").append(String.valueOf(this.imageId));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", memoryConstraints=").append(String.valueOf((Object)this.memoryConstraints));
        sb.append(", ocpuConstraints=").append(String.valueOf((Object)this.ocpuConstraints));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageShapeCompatibilitySummary)) {
            return false;
        }
        ImageShapeCompatibilitySummary other = (ImageShapeCompatibilitySummary)((Object)o);
        return Objects.equals(this.imageId, other.imageId) && Objects.equals(this.shape, other.shape) && Objects.equals((Object)this.memoryConstraints, (Object)other.memoryConstraints) && Objects.equals((Object)this.ocpuConstraints, (Object)other.ocpuConstraints) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.memoryConstraints == null ? 43 : this.memoryConstraints.hashCode());
        result = result * 59 + (this.ocpuConstraints == null ? 43 : this.ocpuConstraints.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="imageId")
        private String imageId;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="memoryConstraints")
        private ImageMemoryConstraints memoryConstraints;
        @JsonProperty(value="ocpuConstraints")
        private ImageOcpuConstraints ocpuConstraints;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.__explicitlySet__.add("imageId");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder memoryConstraints(ImageMemoryConstraints memoryConstraints) {
            this.memoryConstraints = memoryConstraints;
            this.__explicitlySet__.add("memoryConstraints");
            return this;
        }

        public Builder ocpuConstraints(ImageOcpuConstraints ocpuConstraints) {
            this.ocpuConstraints = ocpuConstraints;
            this.__explicitlySet__.add("ocpuConstraints");
            return this;
        }

        public ImageShapeCompatibilitySummary build() {
            ImageShapeCompatibilitySummary model = new ImageShapeCompatibilitySummary(this.imageId, this.shape, this.memoryConstraints, this.ocpuConstraints);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImageShapeCompatibilitySummary model) {
            if (model.wasPropertyExplicitlySet("imageId")) {
                this.imageId(model.getImageId());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("memoryConstraints")) {
                this.memoryConstraints(model.getMemoryConstraints());
            }
            if (model.wasPropertyExplicitlySet("ocpuConstraints")) {
                this.ocpuConstraints(model.getOcpuConstraints());
            }
            return this;
        }
    }
}

