/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.annotations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.UnsufficientValueException;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.packets.EvalCommand;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.netbeans.modules.php.dbgp.packets.PropertyGetCommand;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class ToolTipAnnotation
extends Annotation
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor("Tool Tip Annotation");

    public String getAnnotationType() {
        return null;
    }

    public String getShortDescription() {
        final Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        if (part != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ToolTipAnnotation.this.evaluate(part);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object newValue;
        if ((event.getSource() instanceof EvalCommand || event.getSource() instanceof PropertyGetCommand) && (newValue = event.getNewValue()) instanceof Property) {
            Property value = (Property)event.getNewValue();
            this.firePropertyChange("shortDescription", null, this.getFormattedValue(value));
        }
    }

    private String getFormattedValue(Property value) {
        return this.getFormattedValue(value, 0);
    }

    private String getFormattedValue(Property value, int spaces) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(600);
        CommonTooltip.build(value, builder);
        return builder.toString();
    }

    private void evaluate(Line.Part part) {
        Line line = part.getLine();
        if (line == null) {
            return;
        }
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (!this.isPhpDataObject(dataObject)) {
            return;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
        StyledDocument document = editorCookie.getDocument();
        if (document == null) {
            return;
        }
        int offset = NbDocument.findLineOffset((StyledDocument)document, (int)part.getLine().getLineNumber()) + part.getColumn();
        JEditorPane ep = EditorContextDispatcher.getDefault().getCurrentEditor();
        String selectedText = this.getSelectedText(ep, offset);
        if (selectedText != null) {
            if (ToolTipAnnotation.isPHPIdentifier(selectedText)) {
                this.sendPropertyGetCommand(selectedText);
            } else if (PhpOptions.getInstance().isDebuggerWatchesAndEval()) {
                this.sendEvalCommand(selectedText);
            }
        } else {
            String identifier;
            String string = identifier = ep != null ? ToolTipAnnotation.getIdentifier(document, ep, offset) : null;
            if (identifier != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ToolTipAnnotation.this.sendPropertyGetCommand(identifier);
                    }
                };
                RP.post(runnable);
            }
        }
    }

    private static String getIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getCaret() != null) {
            if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
                t = ep.getSelectedText();
            }
            if (t != null) {
                return t;
            }
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
        try {
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            if (col + 1 >= lineLen) {
                return null;
            }
            t = doc.getText(lineStartOffset, lineLen);
            return ToolTipAnnotation.getExpressionToEvaluate(t, col);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    static String getExpressionToEvaluate(String text, int col) {
        int identEnd;
        int identStart = col;
        boolean isInFieldDeclaration = false;
        while (identStart > 0 && (text.charAt(identStart - 1) == ' ' || ToolTipAnnotation.isPHPIdentifier(text.charAt(identStart - 1)) || text.charAt(identStart - 1) == '.' || text.charAt(identStart - 1) == '>')) {
            if (--identStart > 0 && text.charAt(identStart) == '>') {
                if (text.charAt(identStart - 1) == '-') {
                    --identStart;
                } else {
                    ++identStart;
                    break;
                }
            }
            if (text.charAt(identStart) != ' ') continue;
            String possibleAccessModifier = text.substring(0, identStart).trim();
            if (!ToolTipAnnotation.endsWithAccessModifier(possibleAccessModifier)) break;
            isInFieldDeclaration = true;
            break;
        }
        for (identEnd = col; identEnd < text.length() && Character.isJavaIdentifierPart(text.charAt(identEnd)); ++identEnd) {
        }
        if (identStart == identEnd) {
            return null;
        }
        String simpleExpression = text.substring(identStart, identEnd).trim();
        Object result = simpleExpression;
        if (isInFieldDeclaration && simpleExpression.length() > 1) {
            result = "$this->" + simpleExpression.substring(1);
        }
        return result;
    }

    private static boolean endsWithAccessModifier(String possibleAccessModifier) {
        String lowerCased = possibleAccessModifier.toLowerCase(Locale.US);
        return lowerCased.endsWith("private") || lowerCased.endsWith("protected") || lowerCased.endsWith("public") || lowerCased.endsWith("var");
    }

    static boolean isPHPIdentifier(char ch) {
        return ToolTipAnnotation.isDollarMark(ch) || Character.isJavaIdentifierPart(ch);
    }

    static boolean isPHPIdentifier(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (ToolTipAnnotation.isPHPIdentifier(text.charAt(i))) continue;
            return false;
        }
        return text.length() > 0;
    }

    private static boolean isDollarMark(char ch) {
        return ch == '$';
    }

    private boolean isPhpDataObject(DataObject dataObject) {
        return Utils.isPhpFile(dataObject.getPrimaryFile());
    }

    private void sendEvalCommand(String str) {
        DebugSession session = this.getSession();
        if (session == null) {
            return;
        }
        EvalCommand command = new EvalCommand(session.getTransactionId());
        command.setData(str);
        command.addPropertyChangeListener(this);
        session.sendCommandLater(command);
    }

    private void sendPropertyGetCommand(String str) {
        DebugSession session = this.getSession();
        if (session == null) {
            return;
        }
        PropertyGetCommand command = new PropertyGetCommand(session.getTransactionId());
        command.setName(str);
        command.addPropertyChangeListener(this);
        session.sendCommandLater(command);
    }

    private String getSelectedText(JEditorPane pane, int offset) {
        if (pane != null && pane.getCaret() != null && pane.getSelectionStart() <= offset && offset <= pane.getSelectionEnd()) {
            return pane.getSelectedText();
        }
        return null;
    }

    private DebugSession getSession() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        SessionId id = (SessionId)currentEngine.lookupFirst(null, SessionId.class);
        if (id == null) {
            return null;
        }
        DebugSession session = SessionManager.getInstance().getSession(id);
        return session;
    }

    private static class CommonTooltip {
        protected static final String NEW_LINE = "\n";
        protected final Property property;
        protected final String type;
        protected final String result;
        protected final int spaces;

        protected CommonTooltip(Property property, String type, String result, int spaces) {
            this.property = property;
            this.type = type;
            this.result = result;
            this.spaces = spaces;
        }

        public static void build(Property property, StringBuilder builder) {
            CommonTooltip.build(property, builder, 0);
        }

        public static void build(Property property, StringBuilder builder, int spaces) {
            String result = null;
            String type = null;
            try {
                type = property.getType();
                result = property.getStringValue();
            }
            catch (UnsufficientValueException e) {
                Logger.getLogger(ToolTipAnnotation.class.getName()).log(Level.INFO, null, e);
            }
            if ("object".equalsIgnoreCase(type)) {
                new ObjectTooltip(property, type, result, spaces).build(builder);
            } else if ("array".equalsIgnoreCase(type)) {
                new ArrayTooltip(property, type, result, spaces).build(builder);
            } else if ("null".equalsIgnoreCase(type)) {
                new NullTooltip(property, type, result, spaces).build(builder);
            } else if ("bool".equalsIgnoreCase(type)) {
                new BooleanTooltip(property, type, result, spaces).build(builder);
            } else {
                new CommonTooltip(property, type, result, spaces).build(builder);
            }
        }

        public final void build(StringBuilder builder) {
            this.buildType(builder);
            this.buildResult(builder);
            this.buildChildren(builder);
        }

        protected void buildType(StringBuilder builder) {
            builder.append("(");
            builder.append(this.type);
            builder.append(")");
        }

        protected void buildResult(StringBuilder builder) {
            if (StringUtils.hasText((String)this.result)) {
                if (builder.length() > 0) {
                    this.appendSpaces(1, builder);
                }
                builder.append(this.result);
            }
        }

        protected void buildChildren(StringBuilder builder) {
            if (this.property.hasChildren()) {
                builder.append(this.getChildrenLeft());
                for (Property child : this.property.getChildren()) {
                    builder.append(NEW_LINE);
                    this.appendSpaces(this.spaces + 2, builder);
                    builder.append(this.getChildLeft());
                    builder.append(child.getName());
                    builder.append(this.getChildRight());
                    builder.append(" => ");
                    CommonTooltip.build(child, builder, this.spaces + 2);
                }
                builder.append(NEW_LINE);
                this.appendSpaces(this.spaces, builder);
                builder.append(this.getChildrenRight());
            }
        }

        public String getChildrenLeft() {
            return this.getEmptyString();
        }

        public String getChildrenRight() {
            return this.getEmptyString();
        }

        public String getChildLeft() {
            return this.getEmptyString();
        }

        public String getChildRight() {
            return this.getEmptyString();
        }

        private String getEmptyString() {
            assert (false) : "Unknown type: " + this.type;
            return "";
        }

        protected void appendSpaces(int count, StringBuilder builder) {
            for (int i = 0; i < count; ++i) {
                builder.append(" ");
            }
        }
    }

    private static final class ArrayTooltip
    extends CommonTooltip {
        public ArrayTooltip(Property property, String type, String result, int spaces) {
            super(property, type, result, spaces);
        }

        @Override
        protected void buildType(StringBuilder builder) {
            builder.append(this.type);
            builder.append("(");
            builder.append(this.property.getChildrenSize());
            builder.append(")");
        }

        @Override
        public String getChildrenLeft() {
            return " (";
        }

        @Override
        public String getChildrenRight() {
            return ")";
        }

        @Override
        public String getChildLeft() {
            return "[";
        }

        @Override
        public String getChildRight() {
            return "]";
        }
    }

    private static final class ObjectTooltip
    extends CommonTooltip {
        public ObjectTooltip(Property property, String type, String result, int spaces) {
            super(property, type, result, spaces);
        }

        @Override
        protected void buildType(StringBuilder builder) {
            builder.append(this.property.getClassName());
            builder.append(" ");
            builder.append(this.type);
        }

        @Override
        public String getChildrenLeft() {
            return " {";
        }

        @Override
        public String getChildrenRight() {
            return "}";
        }

        @Override
        public String getChildLeft() {
            return "";
        }

        @Override
        public String getChildRight() {
            return "";
        }
    }

    private static final class BooleanTooltip
    extends CommonTooltip {
        public BooleanTooltip(Property property, String type, String result, int spaces) {
            super(property, type, result, spaces);
        }

        @Override
        protected void buildResult(StringBuilder builder) {
            this.appendSpaces(1, builder);
            if ("1".equals(this.result)) {
                builder.append("true");
            } else {
                builder.append("false");
            }
        }
    }

    private static final class NullTooltip
    extends CommonTooltip {
        public NullTooltip(Property property, String type, String result, int spaces) {
            super(property, type, result, spaces);
        }

        @Override
        protected void buildType(StringBuilder builder) {
            builder.append(this.type);
        }
    }
}

