/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import java.util.Objects;

public class AttrRecover {
    protected static final Context.Key<AttrRecover> attrRepairKey = new Context.Key();
    final Attr attr;
    final Check chk;
    final DeferredAttr deferredAttr;
    final Names names;
    final TreeMaker make;
    final Symtab syms;
    final Types types;
    private final ListBuffer<RecoverTodo> recoveryTodo = new ListBuffer();

    public static AttrRecover instance(Context context) {
        AttrRecover instance = context.get(attrRepairKey);
        if (instance == null) {
            instance = new AttrRecover(context);
        }
        return instance;
    }

    protected AttrRecover(Context context) {
        context.put(attrRepairKey, this);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.names = Names.instance(context);
        this.make = TreeMaker.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
    }

    public void doRecovery() {
        while (this.recoveryTodo.nonEmpty()) {
            Type owntype;
            RecoverTodo todo = (RecoverTodo)this.recoveryTodo.remove();
            final ListBuffer<Runnable> rollback = new ListBuffer<Runnable>();
            boolean repaired = false;
            if (todo.env.tree.hasTag(JCTree.Tag.APPLY)) {
                boolean vararg;
                JCTree.JCMethodInvocation mit = (JCTree.JCMethodInvocation)todo.env.tree;
                boolean bl = vararg = (todo.candSym.flags() & 0x400000000L) != 0L;
                if (vararg || mit.args.length() <= todo.candSym.type.getParameterTypes().length()) {
                    List<JCTree.JCExpression> args = mit.args;
                    List<Type> formals = todo.candSym.type.getParameterTypes();
                    while (args.nonEmpty() && formals.nonEmpty()) {
                        Type formal;
                        JCTree.JCExpression arg = (JCTree.JCExpression)args.head;
                        Type type = formal = formals.tail.nonEmpty() || !vararg ? (Type)formals.head : ((Type.ArrayType)formals.head).elemtype;
                        if (arg.hasTag(JCTree.Tag.LAMBDA)) {
                            final JCTree.JCLambda lambda = (JCTree.JCLambda)arg;
                            if (lambda.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT) {
                                for (JCTree.JCVariableDecl var : lambda.params) {
                                    var.vartype = null;
                                }
                            }
                            if (this.types.isFunctionalInterface(formal)) {
                                Type functionalType = this.types.findDescriptorType(formal);
                                final boolean voidCompatible = functionalType.getReturnType().hasTag(TypeTag.VOID);
                                lambda.body = new TreeTranslator(this){
                                    final /* synthetic */ AttrRecover this$0;
                                    {
                                        this.this$0 = this$0;
                                    }

                                    @Override
                                    public void visitReturn(final JCTree.JCReturn tree) {
                                        this.result = tree;
                                        if (voidCompatible) {
                                            if (tree.expr != null) {
                                                final JCTree.JCErroneous err = this.this$0.make.Erroneous(List.of(tree));
                                                this.result = err;
                                                rollback.append(() -> {
                                                    lambda2.body = new TreeTranslator(this){
                                                        final /* synthetic */ 1 this$1;
                                                        {
                                                            this.this$1 = this$1;
                                                        }

                                                        @Override
                                                        public <T extends JCTree> T translate(T t) {
                                                            if (t == err) {
                                                                return (T)tree;
                                                            }
                                                            return super.translate(t);
                                                        }
                                                    }.translate(lambda2.body);
                                                });
                                            }
                                        } else if (tree.expr == null) {
                                            tree.expr = this.this$0.make.Erroneous().setType(this.this$0.syms.errType);
                                            rollback.append(() -> {
                                                tree.expr = null;
                                            });
                                        }
                                    }

                                    @Override
                                    public void visitLambda(JCTree.JCLambda tree) {
                                        this.result = tree;
                                    }

                                    @Override
                                    public void visitClassDef(JCTree.JCClassDecl tree) {
                                        this.result = tree;
                                    }
                                }.translate(lambda.body);
                                if (!voidCompatible && lambda.body.hasTag(JCTree.Tag.BLOCK)) {
                                    JCTree.JCReturn ret = this.make.Return(this.make.Erroneous().setType(this.syms.errType));
                                    ((JCTree.JCBlock)lambda.body).stats = ((JCTree.JCBlock)lambda.body).stats.append(ret);
                                    rollback.append(() -> {
                                        ((JCTree.JCBlock)lambda.body).stats = List.filter(((JCTree.JCBlock)lambda.body).stats, ret);
                                    });
                                }
                            }
                            repaired = true;
                        }
                        args = args.tail;
                        if (!formals.tail.nonEmpty() && vararg) continue;
                        formals = formals.tail;
                    }
                    List<JCTree.JCExpression> prevArgs = mit.args;
                    while (formals.nonEmpty()) {
                        mit.args = mit.args.append(this.make.Erroneous().setType(this.syms.errType));
                        formals = formals.tail;
                        repaired = true;
                    }
                    rollback.append(() -> {
                        mit.args = prevArgs;
                    });
                }
            }
            if (repaired) {
                List<JCTree.JCExpression> args = TreeInfo.args(todo.env.tree);
                List<Type> pats = todo.resultInfo.pt.getParameterTypes();
                while (pats.length() < args.length()) {
                    pats = pats.append(this.syms.errType);
                }
                Check.NestedCheckContext recoveryCheckContext = new Check.NestedCheckContext(todo.resultInfo.checkContext){

                    @Override
                    public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
                        AttrRecover.this.chk.basicHandler.report(pos, details);
                    }
                };
                Type type = todo.site;
                Symbol symbol = todo.candSym;
                Attr attr = this.attr;
                Objects.requireNonNull(attr);
                owntype = this.attr.checkMethod(type, symbol, attr.new Attr.ResultInfo(todo.resultInfo.pkind, todo.resultInfo.pt.getReturnType(), recoveryCheckContext, todo.resultInfo.checkMode), todo.env, args, pats, todo.resultInfo.pt.getTypeArguments());
                rollback.forEach(Runnable::run);
            } else {
                owntype = this.basicMethodInvocationRecovery(todo.tree, todo.site, todo.errSym, todo.env, todo.resultInfo);
            }
            todo.tree.type = owntype;
        }
    }

    Type recoverMethodInvocation(JCTree tree, Type site, Symbol sym, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
        if ((sym.flags_field & 0x10000000000L) != 0L && ((AttrContext)env.info).attributionMode.recover()) {
            this.recoveryTodo.append(new RecoverTodo(tree, site, sym, ((RecoveryErrorType)sym.type).candidateSymbol, this.attr.copyEnv(env), resultInfo));
            return this.syms.errType;
        }
        return this.basicMethodInvocationRecovery(tree, site, sym, env, resultInfo);
    }

    private Type basicMethodInvocationRecovery(JCTree tree, Type site, Symbol sym, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
        Type type = resultInfo.pt;
        DeferredAttr deferredAttr = this.deferredAttr;
        Objects.requireNonNull(deferredAttr);
        Type pt = type.map(new DeferredAttr.RecoveryDeferredTypeMap(deferredAttr, DeferredAttr.AttrMode.SPECULATIVE, sym, ((AttrContext)env.info).pendingResolutionPhase));
        Type owntype = this.attr.checkIdInternal(tree, site, sym, pt, env, resultInfo);
        Type type2 = resultInfo.pt;
        DeferredAttr deferredAttr2 = this.deferredAttr;
        Objects.requireNonNull(deferredAttr2);
        type2.map(new DeferredAttr.RecoveryDeferredTypeMap(deferredAttr2, DeferredAttr.AttrMode.CHECK, sym, ((AttrContext)env.info).pendingResolutionPhase));
        return owntype;
    }

    void wrongMethodSymbolCandidate(Symbol.TypeSymbol errSymbol, Symbol candSym, JCDiagnostic diag) {
        List<JCDiagnostic> diags = List.of(diag);
        boolean recoverable = false;
        while (!recoverable && diags.nonEmpty()) {
            JCDiagnostic d = (JCDiagnostic)diags.head;
            diags = diags.tail;
            switch (d.getCode()) {
                case "compiler.misc.missing.ret.val": 
                case "compiler.misc.unexpected.ret.val": 
                case "compiler.misc.infer.arg.length.mismatch": 
                case "compiler.misc.arg.length.mismatch": {
                    errSymbol.type = new RecoveryErrorType((Type.ErrorType)errSymbol.type, candSym);
                    errSymbol.flags_field |= 0x10000000000L;
                    return;
                }
            }
            for (Object a : d.getArgs()) {
                if (!(a instanceof JCDiagnostic)) continue;
                JCDiagnostic diagnostic = (JCDiagnostic)a;
                diags = diags.prepend(diagnostic);
            }
        }
    }

    private static class RecoverTodo {
        public final JCTree tree;
        public final Type site;
        public final Symbol errSym;
        public final Symbol candSym;
        public final Env<AttrContext> env;
        public final Attr.ResultInfo resultInfo;

        public RecoverTodo(JCTree tree, Type site, Symbol errSym, Symbol candSym, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
            this.tree = tree;
            this.site = site;
            this.errSym = errSym;
            this.candSym = candSym;
            this.env = env;
            this.resultInfo = resultInfo;
        }
    }

    private static class RecoveryErrorType
    extends Type.ErrorType {
        public final Symbol candidateSymbol;

        public RecoveryErrorType(Type.ErrorType original, Symbol candidateSymbol) {
            super(original.getOriginalType(), original.tsym);
            this.candidateSymbol = candidateSymbol;
        }
    }
}

