/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.print.util.Config;
import org.netbeans.modules.print.util.UI;
import org.openide.text.AttributedCharacters;

final class ComponentLine {
    private Font myFont;
    private Color myColor;
    private TextLayout myTextLayout;
    private List<Symbol> mySymbols = new ArrayList<Symbol>();

    ComponentLine(AttributedCharacterIterator it, Font defaultFont, Color defaultColor) {
        char c = it.first();
        while (c != '\uffff') {
            Font font = (Font)it.getAttribute(TextAttribute.FONT);
            Color color = (Color)it.getAttribute(TextAttribute.FOREGROUND);
            this.mySymbols.add(new Symbol(c, this.createFont(font, defaultFont), this.createColor(color, defaultColor)));
            c = it.next();
        }
        this.checkSpaces(defaultFont, defaultColor);
    }

    ComponentLine(String text, Font font, Color color) {
        for (int i = 0; i < text.length(); ++i) {
            this.mySymbols.add(new Symbol(text.charAt(i), font, color));
        }
        this.checkSpaces(font, color);
    }

    private ComponentLine(List<Symbol> symbols, Font font, Color color) {
        this.mySymbols = symbols;
        this.checkSpaces(font, color);
    }

    private Font createFont(Font attrFont, Font defaultFont) {
        if (!Config.getDefault().isUseFont()) {
            return defaultFont;
        }
        String name = defaultFont.getName();
        int size = defaultFont.getSize();
        int style = attrFont.getStyle();
        return new Font(name, style, size);
    }

    private Color createColor(Color attrColor, Color defaultColor) {
        if (Config.getDefault().isUseColor()) {
            return attrColor;
        }
        return defaultColor;
    }

    private void checkSpaces(Font font, Color color) {
        int i;
        this.myFont = font;
        this.myColor = color;
        for (i = this.length() - 1; i >= 1 && this.mySymbols.get(i).getChar() == ' '; --i) {
        }
        this.mySymbols = this.mySymbols.subList(0, i + 1);
        if (this.length() == 0) {
            this.mySymbols.add(new Symbol(' ', font, color));
        }
    }

    void prepend(String text) {
        Font firstFont = this.mySymbols.get(0).getFont();
        String name = firstFont.getName();
        int size = firstFont.getSize();
        Font font = new Font(name, 0, size);
        for (int i = text.length() - 1; i >= 0; --i) {
            this.mySymbols.add(0, new Symbol(text.charAt(i), font, this.myColor));
        }
    }

    boolean isEmpty() {
        for (int i = 0; i < this.length(); ++i) {
            if (this.mySymbols.get(i).getChar() == ' ') continue;
            return false;
        }
        return true;
    }

    int length() {
        return this.mySymbols.size();
    }

    ComponentLine substring(int index1, int index2) {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        for (int i = index1; i < index2; ++i) {
            list.add(this.mySymbols.get(i));
        }
        return new ComponentLine(list, this.myFont, this.myColor);
    }

    ComponentLine substring(int index) {
        return this.substring(index, this.mySymbols.size());
    }

    int getAscent() {
        return (int)Math.ceil(this.getTextLayout().getAscent());
    }

    int getDescent() {
        return (int)Math.ceil(this.getTextLayout().getDescent());
    }

    int getLeading() {
        return (int)Math.ceil(this.getTextLayout().getLeading());
    }

    int getWidth() {
        int offset = this.getOffset();
        if (offset > 0) {
            offset = 0;
        }
        return (int)Math.ceil(this.getTextLayout().getBounds().getMaxX() - (double)offset);
    }

    int getOffset() {
        return (int)Math.ceil(this.getTextLayout().getBounds().getX());
    }

    void draw(Graphics2D g, int x, int y) {
        this.getTextLayout().draw(g, x, y);
    }

    private TextLayout getTextLayout() {
        if (this.myTextLayout == null) {
            this.myTextLayout = new TextLayout(this.getIterator(), Config.FONT_RENDER_CONTEXT);
        }
        return this.myTextLayout;
    }

    private AttributedCharacterIterator getIterator() {
        AttributedCharacters characters = new AttributedCharacters();
        for (int i = 0; i < this.length(); ++i) {
            characters.append(this.mySymbols.get(i).getChar(), this.mySymbols.get(i).getFont(), this.mySymbols.get(i).getColor());
        }
        return characters.iterator();
    }

    int lastIndexOf(char c, int index) {
        for (int i = index; i >= 0; --i) {
            if (this.mySymbols.get(i).getChar() != c) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            builder.append(this.mySymbols.get(i).getChar());
        }
        return builder.toString();
    }

    void show() {
        for (int i = 0; i < this.length(); ++i) {
            UI.out(this.mySymbols.get(i));
        }
    }

    private static final class Symbol {
        private char myChar;
        private Font myFont;
        private Color myColor;

        Symbol(char c, Font font, Color color) {
            this.myChar = c;
            this.myFont = font;
            this.myColor = color;
        }

        char getChar() {
            return this.myChar;
        }

        Font getFont() {
            return this.myFont;
        }

        Color getColor() {
            return this.myColor;
        }

        void setColor(Color color) {
            this.myColor = color;
        }

        public String toString() {
            return "'" + this.myChar + "' " + this.getString(this.myFont) + " " + this.getString(this.myColor);
        }

        private String getString(Color color) {
            return "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
        }

        private String getString(Font font) {
            Object style = "";
            if (font.isBold()) {
                style = (String)style + "bold";
            }
            style = font.isItalic() ? (String)style + " italic" : (String)style + " plain";
            return "[" + font.getName() + ", " + (String)style + ", " + font.getSize() + "]";
        }
    }
}

