/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.api.support.java;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;

public final class GenerationUtils {
    static final String CLASS_TEMPLATE = "Templates/Classes/Class.java";
    static final String INTERFACE_TEMPLATE = "Templates/Classes/Interface.java";
    private final WorkingCopy copy;

    private GenerationUtils(WorkingCopy copy) {
        this.copy = copy;
    }

    public static GenerationUtils newInstance(WorkingCopy copy) {
        Parameters.notNull((CharSequence)"copy", (Object)copy);
        return new GenerationUtils(copy);
    }

    public static FileObject createClass(FileObject targetFolder, String className, String javadoc) throws IOException {
        return GenerationUtils.createClass(CLASS_TEMPLATE, targetFolder, className, javadoc, Collections.emptyMap());
    }

    public static FileObject createInterface(FileObject targetFolder, String interfaceName, String javadoc) throws IOException {
        return GenerationUtils.createClass(INTERFACE_TEMPLATE, targetFolder, interfaceName, javadoc, Collections.emptyMap());
    }

    public static FileObject createClass(String template, FileObject targetFolder, String className, String javadoc, Map<String, ? extends Object> parameters) throws IOException {
        Parameters.notNull((CharSequence)"template", (Object)template);
        Parameters.notNull((CharSequence)"targetFolder", (Object)targetFolder);
        Parameters.javaIdentifier((CharSequence)"className", (CharSequence)className);
        FileObject classFO = GenerationUtils.createDataObjectFromTemplate(template, targetFolder, className, parameters).getPrimaryFile();
        return classFO;
    }

    private static DataObject createDataObjectFromTemplate(String template, FileObject targetFolder, String targetName, Map<String, ? extends Object> parameters) throws IOException {
        assert (template != null);
        assert (targetFolder != null);
        assert (targetName != null && targetName.trim().length() > 0);
        FileObject templateFO = FileUtil.getConfigFile((String)template);
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        return templateDO.createFromTemplate(dataFolder, targetName, parameters);
    }

    public Tree createType(String typeName, TypeElement scope) {
        TreeMaker make = this.getTreeMaker();
        TypeKind primitiveTypeKind = null;
        if ("boolean".equals(typeName)) {
            primitiveTypeKind = TypeKind.BOOLEAN;
        } else if ("byte".equals(typeName)) {
            primitiveTypeKind = TypeKind.BYTE;
        } else if ("short".equals(typeName)) {
            primitiveTypeKind = TypeKind.SHORT;
        } else if ("int".equals(typeName)) {
            primitiveTypeKind = TypeKind.INT;
        } else if ("long".equals(typeName)) {
            primitiveTypeKind = TypeKind.LONG;
        } else if ("char".equals(typeName)) {
            primitiveTypeKind = TypeKind.CHAR;
        } else if ("float".equals(typeName)) {
            primitiveTypeKind = TypeKind.FLOAT;
        } else if ("double".equals(typeName)) {
            primitiveTypeKind = TypeKind.DOUBLE;
        } else if ("void".equals(typeName)) {
            primitiveTypeKind = TypeKind.VOID;
        }
        if (primitiveTypeKind != null) {
            return this.getTreeMaker().PrimitiveType(primitiveTypeKind);
        }
        Tree typeTree = this.tryCreateQualIdent(typeName);
        if (typeTree == null) {
            TypeMirror typeMirror = this.copy.getTreeUtilities().parseType(typeName, scope);
            typeTree = typeMirror == null || typeMirror.getKind() == TypeKind.ERROR ? this.getTreeMaker().QualIdent(typeName) : make.Type(typeMirror);
        }
        return typeTree;
    }

    public ModifiersTree createModifiers(Modifier modifier) {
        return this.getTreeMaker().Modifiers(EnumSet.of(modifier), Collections.emptyList());
    }

    public AnnotationTree createAnnotation(String annotationType) {
        Parameters.notNull((CharSequence)"annotationType", (Object)annotationType);
        return this.createAnnotation(annotationType, Collections.emptyList());
    }

    public AnnotationTree createAnnotation(String annotationType, List<? extends ExpressionTree> arguments) {
        Parameters.notNull((CharSequence)"annotationType", (Object)annotationType);
        Parameters.notNull((CharSequence)"arguments", arguments);
        ExpressionTree annotationTypeTree = this.createQualIdent(annotationType);
        return this.getTreeMaker().Annotation((Tree)annotationTypeTree, arguments);
    }

    public ExpressionTree createAnnotationArgument(String argumentName, Object argumentValue) {
        Parameters.javaIdentifierOrNull((CharSequence)"argumentName", (CharSequence)argumentName);
        Parameters.notNull((CharSequence)"argumentValue", (Object)argumentValue);
        TreeMaker make = this.getTreeMaker();
        LiteralTree argumentValueTree = make.Literal(argumentValue);
        if (argumentName == null) {
            return argumentValueTree;
        }
        return make.Assignment((ExpressionTree)make.Identifier((CharSequence)argumentName), (ExpressionTree)argumentValueTree);
    }

    public ExpressionTree createAnnotationArgument(String argumentName, List<? extends ExpressionTree> argumentValues) {
        Parameters.javaIdentifierOrNull((CharSequence)"argumentName", (CharSequence)argumentName);
        Parameters.notNull((CharSequence)"argumentValues", argumentValues);
        TreeMaker make = this.getTreeMaker();
        NewArrayTree argumentValuesTree = make.NewArray(null, Collections.emptyList(), argumentValues);
        if (argumentName == null) {
            return argumentValuesTree;
        }
        return make.Assignment((ExpressionTree)make.Identifier((CharSequence)argumentName), (ExpressionTree)argumentValuesTree);
    }

    public ExpressionTree createAnnotationArgument(String argumentName, String argumentType, String argumentTypeField) {
        Parameters.javaIdentifierOrNull((CharSequence)"argumentName", (CharSequence)argumentName);
        Parameters.notNull((CharSequence)"argumentType", (Object)argumentType);
        Parameters.javaIdentifier((CharSequence)"argumentTypeField", (CharSequence)argumentTypeField);
        TreeMaker make = this.getTreeMaker();
        MemberSelectTree argumentValueTree = make.MemberSelect(this.createQualIdent(argumentType), (CharSequence)argumentTypeField);
        if (argumentName == null) {
            return argumentValueTree;
        }
        return make.Assignment((ExpressionTree)make.Identifier((CharSequence)argumentName), (ExpressionTree)argumentValueTree);
    }

    public ClassTree ensureNoArgConstructor(ClassTree classTree) {
        TypeElement typeElement = SourceUtils.classTree2TypeElement((CompilationController)this.copy, classTree);
        if (typeElement == null) {
            throw new IllegalArgumentException("No TypeElement for ClassTree " + classTree.getSimpleName());
        }
        ExecutableElement constructor = SourceUtils.getNoArgConstructor((CompilationController)this.copy, typeElement);
        MethodTree constructorTree = constructor != null ? this.copy.getTrees().getTree(constructor) : null;
        MethodTree newConstructorTree = null;
        TreeMaker make = this.getTreeMaker();
        if (constructor != null) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                ModifiersTree oldModifiersTree = constructorTree.getModifiers();
                EnumSet<Modifier> newModifiers = EnumSet.of(Modifier.PUBLIC);
                for (Modifier modifier : oldModifiersTree.getFlags()) {
                    if (Modifier.PROTECTED == modifier || Modifier.PRIVATE == modifier) continue;
                    newModifiers.add(modifier);
                }
                newConstructorTree = make.Constructor(make.Modifiers(newModifiers), constructorTree.getTypeParameters(), constructorTree.getParameters(), constructorTree.getThrows(), constructorTree.getBody());
            }
        } else {
            newConstructorTree = make.Constructor(this.createModifiers(Modifier.PUBLIC), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{ }");
        }
        ClassTree newClassTree = classTree;
        if (newConstructorTree != null) {
            if (constructorTree != null) {
                newClassTree = make.removeClassMember(newClassTree, (Tree)constructorTree);
            }
            newClassTree = make.addClassMember(newClassTree, (Tree)newConstructorTree);
        }
        return newClassTree;
    }

    public MethodTree createAssignmentConstructor(ModifiersTree modifiersTree, String constructorName, List<VariableTree> parameters) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"constructorName", (CharSequence)constructorName);
        Parameters.notNull((CharSequence)"parameters", parameters);
        StringBuilder body = new StringBuilder(parameters.size() * 30);
        body.append("{");
        for (VariableTree parameter : parameters) {
            String parameterName = parameter.getName().toString();
            body.append("this." + parameterName + " = " + parameterName + ";");
        }
        body.append("}");
        TreeMaker make = this.getTreeMaker();
        return make.Constructor(modifiersTree, Collections.emptyList(), parameters, Collections.emptyList(), body.toString());
    }

    public VariableTree createField(TypeElement scope, ModifiersTree modifiersTree, String fieldName, String fieldType, ExpressionTree expressionTree) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"fieldName", (CharSequence)fieldName);
        Parameters.notNull((CharSequence)"fieldType", (Object)fieldType);
        return this.getTreeMaker().Variable(modifiersTree, (CharSequence)fieldName, this.createType(fieldType, scope), expressionTree);
    }

    public VariableTree createVariable(TypeElement scope, String variableName, String variableType) {
        Parameters.javaIdentifier((CharSequence)"variableName", (CharSequence)variableName);
        Parameters.notNull((CharSequence)"variableType", (Object)variableType);
        return this.createField(scope, this.createEmptyModifiers(), variableName, variableType, null);
    }

    public VariableTree createVariable(String variableName, Tree variableType) {
        Parameters.javaIdentifier((CharSequence)"variableName", (CharSequence)variableName);
        Parameters.notNull((CharSequence)"variableType", (Object)variableType);
        return this.getTreeMaker().Variable(this.createEmptyModifiers(), (CharSequence)variableName, variableType, null);
    }

    public VariableTree removeModifiers(VariableTree variableTree) {
        Parameters.notNull((CharSequence)"variableTree", (Object)variableTree);
        TreeMaker make = this.getTreeMaker();
        return make.Variable(this.createEmptyModifiers(), (CharSequence)variableTree.getName(), variableTree.getType(), variableTree.getInitializer());
    }

    public MethodTree createPropertyGetterMethod(TypeElement scope, ModifiersTree modifiersTree, String propertyName, String propertyType) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"propertyName", (CharSequence)propertyName);
        Parameters.notNull((CharSequence)"propertyType", (Object)propertyType);
        return this.createPropertyGetterMethod(modifiersTree, propertyName, this.createType(propertyType, scope));
    }

    public MethodTree createPropertyGetterMethod(ModifiersTree modifiersTree, String propertyName, Tree propertyType) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"propertyName", (CharSequence)propertyName);
        Parameters.notNull((CharSequence)"propertyType", (Object)propertyType);
        return this.getTreeMaker().Method(modifiersTree, (CharSequence)this.createPropertyAccessorName(propertyName, true), propertyType, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{ return " + propertyName + "; }", null);
    }

    public MethodTree createPropertySetterMethod(TypeElement scope, ModifiersTree modifiersTree, String propertyName, String propertyType) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"propertyName", (CharSequence)propertyName);
        Parameters.notNull((CharSequence)"propertyType", (Object)propertyType);
        return this.createPropertySetterMethod(modifiersTree, propertyName, this.createType(propertyType, scope));
    }

    public MethodTree createPropertySetterMethod(ModifiersTree modifiersTree, String propertyName, Tree propertyType) {
        Parameters.notNull((CharSequence)"modifiersTree", (Object)modifiersTree);
        Parameters.javaIdentifier((CharSequence)"propertyName", (CharSequence)propertyName);
        Parameters.notNull((CharSequence)"propertyType", (Object)propertyType);
        TreeMaker make = this.getTreeMaker();
        return make.Method(modifiersTree, (CharSequence)this.createPropertyAccessorName(propertyName, false), (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(this.createVariable(propertyName, propertyType)), Collections.emptyList(), "{ this." + propertyName + " = " + propertyName + "; }", null);
    }

    public ClassTree addAnnotation(ClassTree classTree, AnnotationTree annotationTree) {
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        Parameters.notNull((CharSequence)"annotationTree", (Object)annotationTree);
        TreeMaker make = this.getTreeMaker();
        return make.Class(make.addModifiersAnnotation(classTree.getModifiers(), annotationTree), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), classTree.getPermitsClause(), classTree.getMembers());
    }

    public MethodTree addAnnotation(MethodTree methodTree, AnnotationTree annotationTree) {
        Parameters.notNull((CharSequence)"methodTree", (Object)methodTree);
        Parameters.notNull((CharSequence)"annotationTree", (Object)annotationTree);
        TreeMaker make = this.getTreeMaker();
        return make.Method(make.addModifiersAnnotation(methodTree.getModifiers(), annotationTree), (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), methodTree.getBody(), (ExpressionTree)methodTree.getDefaultValue());
    }

    public VariableTree addAnnotation(VariableTree variableTree, AnnotationTree annotationTree) {
        Parameters.notNull((CharSequence)"variableTree", (Object)variableTree);
        Parameters.notNull((CharSequence)"annotationTree", (Object)annotationTree);
        TreeMaker make = this.getTreeMaker();
        return make.Variable(make.addModifiersAnnotation(variableTree.getModifiers(), annotationTree), (CharSequence)variableTree.getName(), variableTree.getType(), variableTree.getInitializer());
    }

    public ClassTree addClassFields(ClassTree classTree, List<? extends VariableTree> fieldTrees) {
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        Parameters.notNull((CharSequence)"fieldTrees", fieldTrees);
        int firstNonFieldIndex = 0;
        Iterator<? extends Tree> memberTrees = classTree.getMembers().iterator();
        while (memberTrees.hasNext() && memberTrees.next().getKind() == Tree.Kind.VARIABLE) {
            ++firstNonFieldIndex;
        }
        TreeMaker make = this.getTreeMaker();
        ClassTree newClassTree = classTree;
        for (VariableTree variableTree : fieldTrees) {
            newClassTree = make.insertClassMember(newClassTree, firstNonFieldIndex, (Tree)variableTree);
            ++firstNonFieldIndex;
        }
        return newClassTree;
    }

    public ClassTree addImplementsClause(ClassTree classTree, String interfaceType) {
        Parameters.notNull((CharSequence)"classTree", (Object)classTree);
        Parameters.notNull((CharSequence)"interfaceType", (Object)interfaceType);
        ExpressionTree interfaceTree = this.createQualIdent(interfaceType);
        return this.getTreeMaker().addClassImplementsClause(classTree, (Tree)interfaceTree);
    }

    private TreeMaker getTreeMaker() {
        return this.copy.getTreeMaker();
    }

    private ModifiersTree createEmptyModifiers() {
        return this.getTreeMaker().Modifiers(Collections.emptySet(), Collections.emptyList());
    }

    private ExpressionTree tryCreateQualIdent(String typeName) {
        TypeElement typeElement = this.copy.getElements().getTypeElement(typeName);
        if (typeElement != null) {
            return this.getTreeMaker().QualIdent((Element)typeElement);
        }
        return null;
    }

    private ExpressionTree createQualIdent(String typeName) {
        ExpressionTree qualIdent = this.tryCreateQualIdent(typeName);
        if (qualIdent == null) {
            qualIdent = this.getTreeMaker().QualIdent(typeName);
        }
        if (qualIdent == null) {
            throw new IllegalArgumentException("Cannot create a QualIdent for " + typeName);
        }
        return qualIdent;
    }

    private String createPropertyAccessorName(String propertyName, boolean getter) {
        assert (propertyName.length() > 0);
        StringBuffer pascalCaseName = new StringBuffer(propertyName);
        pascalCaseName.setCharAt(0, Character.toUpperCase(pascalCaseName.charAt(0)));
        return (getter ? "get" : "set") + pascalCaseName;
    }
}

