/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.CharArrayWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.NbInstaller;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.BaseUtilities;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class ModuleList
implements Stamps.Updater {
    static final RequestProcessor RP = new RequestProcessor("Module List Updates");
    public static final String PUBLIC_ID = "-//NetBeans//DTD Module Status 1.0//EN";
    public static final String SYSTEM_ID = "http://www.netbeans.org/dtds/module-status-1_0.dtd";
    private static final boolean VALIDATE_XML = true;
    private static final Logger LOG = Logger.getLogger(ModuleList.class.getName());
    private final ModuleManager mgr;
    private final FileObject folder;
    private final Events ev;
    private final Map<String, DiskStatus> statuses = new HashMap<String, DiskStatus>(100);
    private boolean triggered = false;
    private final Listener listener = new Listener();
    private FileChangeListener weakListener;
    private final Set<FileSystem.AtomicAction> myAtomicActions = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap(100)));
    private static final byte[] MODULE_XML_INTRO = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"".getBytes();
    private static final byte[] MODULE_XML_INTRO_END = ">\n".getBytes();
    private static final byte[] MODULE_XML_DIV2 = "   <param name=\"".getBytes();
    private static final byte[] MODULE_XML_DIV3 = "/param>\n".getBytes();
    private static final byte[] MODULE_XML_END = "/module>\n".getBytes();

    public ModuleList(ModuleManager mgr, FileObject folder, Events ev) {
        this.mgr = mgr;
        this.folder = folder;
        this.ev = ev;
        LOG.fine("ModuleList created, storage in " + folder);
    }

    public Set<Module> readInitial() {
        this.ev.log("startRead", new Object[0]);
        HashSet<Module> read = new HashSet<Module>();
        try {
            this.folder.getFileSystem().runAtomicAction((FileSystem.AtomicAction)new ReadInitial(read));
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
        }
        return read;
    }

    final Module createModule(File jarFile, ModuleHistory hist, boolean reloadable, boolean autoload, boolean eager, Integer startLevel) throws IOException {
        Module m;
        try {
            m = startLevel != null ? this.mgr.createBundle(jarFile, (Object)hist, reloadable, autoload, eager, startLevel.intValue()) : this.mgr.create(jarFile, (Object)hist, reloadable, autoload, eager);
        }
        catch (DuplicateException dupe) {
            throw new IOException(dupe);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File findJarByName(String jar, String name) throws IOException {
        File f = new File(jar);
        if (f.isAbsolute()) {
            if (!f.isFile()) {
                throw new FileNotFoundException(f.getAbsolutePath());
            }
            return f;
        }
        Set jars = InstalledFileLocator.getDefault().locateAll(jar, name, false);
        if (jars.isEmpty()) {
            throw new FileNotFoundException(jar);
        }
        if (jars.size() == 1 || Boolean.getBoolean("org.netbeans.core.startup.ModuleList.firstModuleJarWins")) {
            return (File)jars.iterator().next();
        }
        int major = -1;
        SpecificationVersion spec = null;
        File newest = null;
        for (File candidate : jars) {
            int candidateMajor = -1;
            SpecificationVersion candidateSpec = null;
            try (JarFile jf = new JarFile(candidate);){
                String sv;
                int slash;
                Attributes attr = jf.getManifest().getMainAttributes();
                String codename = attr.getValue("OpenIDE-Module");
                if (codename != null && (slash = codename.lastIndexOf(47)) != -1) {
                    candidateMajor = Integer.parseInt(codename.substring(slash + 1));
                }
                if ((sv = attr.getValue("OpenIDE-Module-Specification-Version")) != null) {
                    candidateSpec = new SpecificationVersion(sv);
                }
            }
            if (newest != null && candidateMajor <= major && (spec == null || candidateSpec == null || candidateSpec.compareTo(spec) <= 0)) continue;
            newest = candidate;
            major = candidateMajor;
            spec = candidateSpec;
        }
        return newest;
    }

    public void trigger(Set<Module> boot) {
        this.ev.log("perfStart", new Object[]{"ModuleList.trigger"});
        if (this.triggered) {
            throw new IllegalStateException("Duplicate call to trigger()");
        }
        HashSet<Module> maybeEnable = new HashSet<Module>(boot);
        for (DiskStatus status : this.statuses.values()) {
            if (!status.pendingInstall) continue;
            status.pendingInstall = false;
            Module m = status.module;
            if (m.isEnabled() || m.isAutoload() || m.isEager()) {
                throw new IllegalStateException();
            }
            maybeEnable.add(m);
        }
        this.ev.log("perfTick", new Object[]{"modules to enable prepared"});
        if (!maybeEnable.isEmpty()) {
            this.ev.log("startAutoRestore", new Object[]{maybeEnable});
            this.installNew(maybeEnable);
            this.ev.log("finishAutoRestore", new Object[]{maybeEnable});
        }
        LOG.fine("ModuleList.trigger: enabled new modules, flushing changes...");
        this.triggered = true;
        this.flushInitial();
        this.ev.log("perfEnd", new Object[]{"ModuleList.trigger"});
    }

    private void installNew(Set<Module> modules) {
        if (modules.isEmpty()) {
            return;
        }
        this.ev.log("perfStart", new Object[]{"ModuleList.installNew"});
        Iterator<Object> it = modules.iterator();
        while (it.hasNext()) {
            Module m = it.next();
            if (m.isAutoload() || m.isEager()) {
                it.remove();
                continue;
            }
            if (m.isEnabled()) {
                LOG.fine("#17295 fix active for " + m.getCodeNameBase());
                it.remove();
                continue;
            }
            if (m.isValid()) continue;
            LOG.fine("#17471 fix active for " + m.getCodeNameBase());
            it.remove();
        }
        List toEnable = this.mgr.simulateEnable(modules);
        for (Module m : toEnable) {
            if (m.isAutoload() || m.isEager() || modules.contains(m)) continue;
            modules.add(m);
        }
        HashSet<Module> missing = new HashSet<Module>(modules);
        missing.removeAll(toEnable);
        if (!missing.isEmpty()) {
            Util.transitiveClosureModuleDependencies((ModuleManager)this.mgr, missing);
            it = missing.iterator();
            while (it.hasNext()) {
                Module m;
                m = (Module)it.next();
                if (!m.getProblems().isEmpty()) continue;
                it.remove();
            }
            this.ev.log("failedInstallNew", new Object[]{missing});
            modules.removeAll(missing);
        }
        try {
            this.mgr.enable(modules);
        }
        catch (InvalidException ie) {
            LOG.log(Level.INFO, null, ie);
            Module bad = ie.getModule();
            if (bad == null) {
                throw new IllegalStateException();
            }
            Set affectedModules = this.mgr.getModuleInterdependencies(bad, true, true, true);
            this.ev.log("failedInstallNewUnexpected", new Object[]{bad, affectedModules, ie});
            modules.removeAll(affectedModules);
            this.installNew(modules);
        }
        this.ev.log("perfEnd", new Object[]{"ModuleList.installNew"});
    }

    private Map<String, Object> readStatus(InputSource is, XMLReader reader) throws IOException, SAXException {
        if (reader == null) {
            reader = XMLUtil.createXMLReader((boolean)true);
            reader.setEntityResolver(this.listener);
            reader.setErrorHandler(this.listener);
        }
        final HashMap<String, Object> m = new HashMap<String, Object>();
        DefaultHandler handler = new DefaultHandler(){
            private String modName;
            private String paramName;
            private StringBuffer data = new StringBuffer();

            @Override
            public void startElement(String uri, String localname, String qname, org.xml.sax.Attributes attrs) throws SAXException {
                if ("module".equals(qname)) {
                    this.modName = attrs.getValue("name");
                    if (this.modName == null) {
                        throw new SAXException("No module name");
                    }
                    m.put("name", this.modName.intern());
                } else if (this.modName != null && "param".equals(qname)) {
                    this.paramName = attrs.getValue("name");
                    if (this.paramName == null) {
                        throw new SAXException("No param name");
                    }
                    this.paramName = this.paramName.intern();
                    this.data.setLength(0);
                }
            }

            @Override
            public void characters(char[] ch, int start, int len) {
                if (this.modName != null && this.paramName != null) {
                    this.data.append(ch, start, len);
                }
            }

            @Override
            public void endElement(String uri, String localname, String qname) throws SAXException {
                if ("param".equals(qname)) {
                    if (this.modName != null && this.paramName != null) {
                        if (this.data.length() == 0) {
                            throw new SAXException("No text contents in " + this.paramName + " of " + this.modName);
                        }
                        try {
                            m.put(this.paramName, ModuleList.this.processStatusParam(this.paramName, this.data.toString()));
                        }
                        catch (NumberFormatException nfe) {
                            throw (SAXException)new SAXException(nfe.toString()).initCause(nfe);
                        }
                        this.data.setLength(0);
                        this.paramName = null;
                    }
                } else if ("module".equals(qname)) {
                    this.modName = null;
                }
            }
        };
        reader.setContentHandler(handler);
        reader.parse(is);
        this.sanityCheckStatus(m);
        return m;
    }

    private Object processStatusParam(String k, String v) throws NumberFormatException {
        if (k == "enabled" || k == "autoload" || k == "eager" || k == "reloadable") {
            return Boolean.valueOf(v);
        }
        if (k == "startlevel") {
            return Integer.valueOf(v);
        }
        if (v.length() < 100) {
            v = v.intern();
        }
        return v;
    }

    private void sanityCheckStatus(Map<String, Object> m) throws IOException {
        String jar = (String)m.get("jar");
        if (jar == null) {
            throw new IOException("Must define jar param");
        }
        if (Boolean.TRUE.equals(m.get("autoload")) && m.get("enabled") != null) {
            throw new IOException("Autoload " + jar + " cannot specify enablement");
        }
        if (Boolean.TRUE.equals(m.get("eager")) && m.get("enabled") != null) {
            throw new IOException("Eager " + jar + " cannot specify enablement");
        }
    }

    private Map<String, Object> readStatus(InputStream is, boolean checkEOF) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is, 1);
        HashMap<String, Object> m = new HashMap<String, Object>(15);
        if (!this.expect(pbis, MODULE_XML_INTRO)) {
            LOG.fine("Could not read intro");
            return null;
        }
        String name = this.readTo(pbis, '\"');
        if (name == null) {
            LOG.fine("Could not read code name base");
            return null;
        }
        m.put("name", name.intern());
        if (!this.expect(pbis, MODULE_XML_INTRO_END)) {
            LOG.fine("Could not read stuff after cnb");
            return null;
        }
        block6: while (true) {
            int c = pbis.read();
            switch (c) {
                case 32: {
                    if (!this.expect(pbis, MODULE_XML_DIV2)) {
                        LOG.fine("Could not read up to param");
                        return null;
                    }
                    String k = this.readTo(pbis, '\"');
                    if (k == null) {
                        LOG.fine("Could not read param");
                        return null;
                    }
                    k = k.intern();
                    if (pbis.read() != 62) {
                        LOG.fine("No > at end of <param> " + k);
                        return null;
                    }
                    String v = this.readTo(pbis, '<');
                    if (v == null) {
                        LOG.fine("Could not read value of " + k);
                        return null;
                    }
                    if (!this.expect(pbis, MODULE_XML_DIV3)) {
                        LOG.fine("Could not read end of param " + k);
                        return null;
                    }
                    try {
                        m.put(k, this.processStatusParam(k, v));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        LOG.fine("Number misparse: " + nfe);
                        return null;
                    }
                }
                case 60: {
                    if (!this.expect(pbis, MODULE_XML_END)) {
                        LOG.fine("Strange ending");
                        return null;
                    }
                    if (!checkEOF || pbis.read() == -1) break block6;
                    LOG.fine("Trailing garbage");
                    return null;
                }
                default: {
                    LOG.fine("Strange stuff after <param>s: " + c);
                    return null;
                }
            }
        }
        this.sanityCheckStatus(m);
        return m;
    }

    private boolean expect(PushbackInputStream is, byte[] stuff) throws IOException {
        int c;
        int len = stuff.length;
        boolean inNewline = false;
        int i = 0;
        while (i < len) {
            int c2 = is.read();
            if (c2 == 10 || c2 == 13) {
                if (inNewline) continue;
                inNewline = true;
                c2 = 10;
            } else {
                inNewline = false;
            }
            if (c2 == stuff[i++]) continue;
            return false;
        }
        if (stuff[len - 1] == 10 && (c = is.read()) != -1 && c != 10 && c != 13) {
            is.unread(c);
        }
        return true;
    }

    private String readTo(InputStream is, char delim) throws IOException {
        if (delim == '\n') {
            throw new IOException("Not implemented");
        }
        CharArrayWriter caw = new CharArrayWriter(100);
        boolean inNewline = false;
        int c;
        while ((c = is.read()) != -1) {
            if (c > 126) {
                return null;
            }
            if (c == 10 || c == 13) {
                if (inNewline) continue;
                inNewline = true;
                c = 10;
            } else {
                if (c < 32 && c != 9) {
                    return null;
                }
                inNewline = false;
            }
            if (c == delim) {
                return caw.toString();
            }
            caw.write(c);
        }
        return null;
    }

    final Map<String, Map<String, Object>> readCache() {
        InputStream is = Stamps.getModulesJARs().asStream("all-modules.dat");
        if (is == null) {
            this.writeCache();
            return null;
        }
        LOG.log(Level.FINEST, "Reading cache all-modules.dat");
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(1333);
            while (is.available() > 0) {
                Set deps;
                Map<String, Object> prop = this.readStatus(ois, false);
                if (prop == null) {
                    LOG.log(Level.CONFIG, "Cache is invalid all-modules.dat");
                    return null;
                }
                try {
                    deps = (Set)ois.readObject();
                }
                catch (ClassNotFoundException ex) {
                    throw new IOException(ex);
                }
                prop.put("deps", deps);
                String cnb = (String)prop.get("name");
                ret.put(cnb, prop);
            }
            is.close();
            return ret;
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Cannot read cache", ex);
            this.writeCache();
            return null;
        }
    }

    final void writeCache() {
        Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, "all-modules.dat", false);
    }

    public void cacheReady() {
    }

    public void flushCaches(DataOutputStream os) throws IOException {
        ObjectOutputStream oss = new ObjectOutputStream(os);
        for (Module m : this.mgr.getModules()) {
            if (m.isFixed()) continue;
            Map<String, Object> prop = this.computeProperties(m);
            this.writeStatus(prop, oss);
            oss.writeObject(m.getDependencies());
        }
    }

    private void writeStatus(Map<String, Object> m, OutputStream os) throws IOException {
        String codeName = (String)m.get("name");
        if (codeName == null) {
            throw new IllegalArgumentException("no code name present");
        }
        OutputStreamWriter w = new OutputStreamWriter(os, StandardCharsets.UTF_8);
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        w.write("<!DOCTYPE module PUBLIC \"");
        w.write(PUBLIC_ID);
        w.write("\"\n                        \"");
        w.write(SYSTEM_ID);
        w.write("\">\n");
        w.write("<module name=\"");
        w.write(XMLUtil.toAttributeValue((String)codeName));
        w.write("\">\n");
        for (Map.Entry<String, Object> entry : new TreeMap<String, Object>(m).entrySet()) {
            String name = entry.getKey();
            if (name.equals("name") || name.equals("deps")) continue;
            Object val = entry.getValue();
            w.write("    <param name=\"");
            w.write(XMLUtil.toAttributeValue((String)name));
            w.write("\">");
            w.write(XMLUtil.toElementContent((String)val.toString()));
            w.write("</param>\n");
        }
        w.write("</module>\n");
        ((Writer)w).flush();
    }

    private DiskStatus writeOut(Module m, DiskStatus old) throws IOException {
        DiskStatus nue;
        if (old == null) {
            nue = new DiskStatus();
            nue.module = m;
            nue.setDiskProps(this.computeProperties(m));
        } else {
            nue = old;
        }
        FileSystem.AtomicAction aa = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                if (nue.file == null) {
                    nue.file = FileUtil.createData((FileObject)ModuleList.this.folder, (String)(((String)nue.diskProps.get("name")).replace('.', '-') + ".xml"));
                } else if (nue.dirty) {
                    LOG.log(Level.INFO, null, new IOException("Will not clobber external changes in " + nue.file));
                    return;
                }
                LOG.fine("ModuleList: (re)writing " + nue.file);
                FileLock lock = nue.file.lock();
                try (OutputStream os = nue.file.getOutputStream(lock);){
                    ModuleList.this.writeStatus(nue.diskProps, os);
                }
                finally {
                    lock.releaseLock();
                }
            }
        };
        this.myAtomicActions.add(aa);
        this.folder.getFileSystem().runAtomicAction(aa);
        return nue;
    }

    private void deleteFromDisk(final Module m, final DiskStatus status) throws IOException {
        final String nameDashes = m.getCodeNameBase().replace('.', '-');
        FileSystem.AtomicAction aa = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject xml = ModuleList.this.folder.getFileObject(nameDashes, "xml");
                if (xml == null) {
                    LOG.fine("ModuleList: " + m + "'s XML already gone from disk");
                    return;
                }
                if (status.dirty) {
                    throw new IOException("Unapproved external change to " + xml);
                }
                LOG.fine("ModuleList: deleting " + xml);
                xml.delete();
                FileObject ser = ModuleList.this.folder.getFileObject(nameDashes, "ser");
                if (ser != null) {
                    LOG.fine("(and also " + ser + ")");
                    ser.delete();
                }
            }
        };
        this.myAtomicActions.add(aa);
        this.folder.getFileSystem().runAtomicAction(aa);
    }

    private void flushInitial() {
        LOG.fine("Flushing initial module list...");
        for (Module m : this.mgr.getModules()) {
            DiskStatus status = this.statuses.get(m.getCodeNameBase());
            if (status == null) continue;
            this.moduleChanged(m, status);
            m.addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.moduleListChanged();
        this.mgr.addPropertyChangeListener((PropertyChangeListener)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void moduleListChanged() {
        Map<String, DiskStatus> map = this.statuses;
        synchronized (map) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("ModuleList: moduleListChanged; statuses=" + this.statuses);
            }
            for (Module m : this.mgr.getModules()) {
                String name;
                if (m.isFixed() || m.getJarFile() == null || this.statuses.get(name = m.getCodeNameBase()) != null) continue;
                LOG.fine("moduleListChanged: added: " + m);
                try {
                    this.statuses.put(name, this.writeOut(m, null));
                    m.addPropertyChangeListener((PropertyChangeListener)this.listener);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, null, ioe);
                }
            }
            Iterator<DiskStatus> it = this.statuses.values().iterator();
            while (it.hasNext()) {
                DiskStatus status = it.next();
                if (status.module.isValid()) continue;
                status.module.removePropertyChangeListener((PropertyChangeListener)this.listener);
                Module nue = this.mgr.get(status.module.getCodeNameBase());
                if (nue != null) {
                    LOG.fine("moduleListChanged: recreated: " + nue);
                    nue.addPropertyChangeListener((PropertyChangeListener)this.listener);
                    status.module = nue;
                    this.moduleChanged(nue, status);
                    continue;
                }
                LOG.fine("moduleListChanged: deleted: " + status.module);
                it.remove();
                try {
                    this.deleteFromDisk(status.module, status);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, null, ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleChanged(Module m, DiskStatus status) {
        DiskStatus diskStatus = status;
        synchronized (diskStatus) {
            LOG.log(Level.FINE, "moduleChanged: {0}", m);
            Map<String, Object> newProps = this.computeProperties(m);
            int cnt = 0;
            for (Map.Entry<String, Object> entry : status.diskProps.entrySet()) {
                if (entry.getKey().equals("deps")) continue;
                Object snd = newProps.get(entry.getKey());
                if (!entry.getValue().equals(snd)) {
                    cnt = -1;
                    break;
                }
                ++cnt;
            }
            if (cnt != newProps.size()) {
                if (LOG.isLoggable(Level.FINE)) {
                    HashSet<Map.Entry<String, Object>> changes = new HashSet<Map.Entry<String, Object>>(newProps.entrySet());
                    changes.removeAll(status.diskProps.entrySet());
                    LOG.fine("ModuleList: changes are " + changes);
                }
                status.setDiskProps(newProps);
                try {
                    this.writeOut(m, status);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, null, ioe);
                }
                this.writeCache();
            }
        }
    }

    private Map<String, Object> computeProperties(Module m) {
        if (m.isFixed() || !m.isValid()) {
            throw new IllegalArgumentException("fixed or invalid: " + m);
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("name", m.getCodeNameBase());
        if (!m.isAutoload() && !m.isEager()) {
            p.put("enabled", m.isEnabled());
        }
        p.put("autoload", m.isAutoload());
        p.put("eager", m.isEager());
        p.put("reloadable", m.isReloadable());
        if (m.getStartLevel() > 0) {
            p.put("startlevel", m.getStartLevel());
        }
        if (m.getHistory() instanceof ModuleHistory) {
            ModuleHistory hist = (ModuleHistory)m.getHistory();
            p.put("jar", hist.getJar());
        }
        return p;
    }

    final void init() {
        this.weakListener = FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)this.folder);
        this.folder.getChildren();
        this.folder.addFileChangeListener(this.weakListener);
    }

    final void shutDown() {
        this.folder.removeFileChangeListener(this.weakListener);
    }

    private final class Listener
    implements PropertyChangeListener,
    ErrorHandler,
    EntityResolver,
    FileChangeListener,
    Runnable {
        private final RequestProcessor.Task task = RP.create((Runnable)this);
        private boolean listening = true;

        Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!ModuleList.this.triggered) {
                throw new IllegalStateException("Property change before trigger()");
            }
            String prop = evt.getPropertyName();
            Object src = evt.getSource();
            if (!this.listening) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ModuleList: ignoring own change " + prop + " from " + src);
                }
                return;
            }
            if ("classLoader".equals(prop) || "enabledModules".equals(prop) || "classLoader".equals(prop) || "problems".equals(prop) || "valid".equals(prop)) {
                return;
            }
            if ("modules".equals(prop)) {
                ModuleList.this.moduleListChanged();
            } else if (src instanceof Module) {
                Module m = (Module)src;
                if (!m.isValid()) {
                    return;
                }
                DiskStatus status = ModuleList.this.statuses.get(m.getCodeNameBase());
                if (status == null) {
                    throw new IllegalStateException("Unknown module " + m + "; statuses=" + ModuleList.this.statuses);
                }
                if (status.pendingInstall && "enabled".equals(prop)) {
                    throw new IllegalStateException("Got PROP_ENABLED on " + m + " before trigger()");
                }
                ModuleList.this.moduleChanged(m, status);
            } else {
                LOG.fine("Unexpected property change: " + evt + " prop=" + prop + " src=" + src);
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            LOG.log(Level.WARNING, null, e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public InputSource resolveEntity(String pubid, String sysid) throws SAXException, IOException {
            if (pubid.equals(ModuleList.PUBLIC_ID)) {
                return new InputSource(ModuleList.class.getResource("module-status-1_0.dtd").toExternalForm());
            }
            return EntityCatalog.getDefault().resolveEntity(pubid, sysid);
        }

        public void fileDeleted(FileEvent ev) {
            if (this.isOurs(ev)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ModuleList: got expected deletion " + ev);
                }
                return;
            }
            FileObject fo = ev.getFile();
            this.fileDeleted0(fo.getName(), fo.getExt());
        }

        public void fileDataCreated(FileEvent ev) {
            if (this.isOurs(ev)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ModuleList: got expected creation " + ev);
                }
                return;
            }
            FileObject fo = ev.getFile();
            this.fileCreated0(fo.getName(), fo.getExt());
        }

        public void fileRenamed(FileRenameEvent ev) {
            if (this.isOurs((FileEvent)ev)) {
                throw new IllegalStateException("I don't rename anything! " + ev);
            }
            FileObject fo = ev.getFile();
            this.fileDeleted0(ev.getName(), ev.getExt());
            this.fileCreated0(fo.getName(), fo.getExt());
        }

        private void fileCreated0(String name, String ext) {
            if ("xml".equals(ext)) {
                String codenamebase = name.replace('-', '.');
                DiskStatus status = ModuleList.this.statuses.get(codenamebase);
                LOG.fine("ModuleList: outside file creation event for " + codenamebase);
                if (status != null) {
                    status.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(ext)) {
                // empty if block
            }
        }

        private void fileDeleted0(String name, String ext) {
            if ("xml".equals(ext)) {
                String codenamebase = name.replace('-', '.');
                DiskStatus status = ModuleList.this.statuses.get(codenamebase);
                LOG.fine("ModuleList: outside file deletion event for " + codenamebase);
                if (status != null) {
                    status.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(ext)) {
                // empty if block
            }
        }

        public void fileChanged(FileEvent ev) {
            if (this.isOurs(ev)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ModuleList: got expected modification " + ev);
                }
                return;
            }
            FileObject fo = ev.getFile();
            String name = fo.getName();
            String ext = fo.getExt();
            if ("xml".equals(ext)) {
                String codenamebase = name.replace('-', '.');
                DiskStatus status = ModuleList.this.statuses.get(codenamebase);
                LOG.fine("ModuleList: outside file modification event for " + codenamebase + ": " + ev);
                if (status != null) {
                    status.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(ext)) {
                // empty if block
            }
        }

        public void fileFolderCreated(FileEvent ev) {
        }

        public void fileAttributeChanged(FileAttributeEvent ev) {
        }

        private boolean isOurs(FileEvent ev) {
            for (FileSystem.AtomicAction action : ModuleList.this.myAtomicActions) {
                if (!ev.firedFrom(action)) continue;
                return true;
            }
            return false;
        }

        private void runme() {
            this.task.schedule(100);
        }

        @Override
        public void run() {
            LOG.fine("ModuleList: will process outstanding external XML changes");
            ModuleList.this.mgr.mutexPrivileged().enterWriteAccess();
            try {
                ModuleList.this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        Map<String, FileObject> xmlfiles = Listener.this.prepareXMLFiles();
                        Map<String, Map<String, Object>> dirtyprops = Listener.this.prepareDirtyProps(xmlfiles);
                        Listener.this.listening = false;
                        try {
                            Listener.this.stepCheckReloadable(dirtyprops);
                            Listener.this.stepCreate(xmlfiles, dirtyprops);
                            Listener.this.stepEnable(dirtyprops);
                            Listener.this.stepDisable(dirtyprops);
                            Listener.this.stepDelete(xmlfiles);
                            Listener.this.stepCheckMisc(dirtyprops);
                            Listener.this.stepCheckSer(xmlfiles, dirtyprops);
                        }
                        finally {
                            Listener.this.listening = true;
                            Listener.this.stepUpdateProps(dirtyprops);
                            Listener.this.stepMarkClean();
                        }
                    }
                });
                LOG.fine("ModuleList: finished processing outstanding external XML changes");
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
            finally {
                ModuleList.this.mgr.mutexPrivileged().exitWriteAccess();
            }
        }

        private Map<String, FileObject> prepareXMLFiles() {
            LOG.fine("ModuleList: prepareXMLFiles");
            HashMap<String, FileObject> xmlfiles = new HashMap<String, FileObject>(100);
            FileObject[] kids = ModuleList.this.folder.getChildren();
            for (int i = 0; i < kids.length; ++i) {
                if (!kids[i].hasExt("xml")) continue;
                xmlfiles.put(kids[i].getName().replace('-', '.'), kids[i]);
            }
            return xmlfiles;
        }

        /*
         * Exception decompiling
         */
        private Map<String, Map<String, Object>> prepareDirtyProps(Map<String, FileObject> xmlfiles) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void stepCheckReloadable(Map<String, Map<String, Object>> dirtyprops) {
            LOG.fine("ModuleList: stepCheckReloadable");
            for (Map.Entry<String, Map<String, Object>> entry : dirtyprops.entrySet()) {
                boolean diskReloadable;
                String cnb = entry.getKey();
                DiskStatus status = ModuleList.this.statuses.get(cnb);
                if (status == null) continue;
                Map<String, Object> props = entry.getValue();
                Boolean diskReloadableB = (Boolean)props.get("reloadable");
                boolean bl = diskReloadable = diskReloadableB != null ? diskReloadableB : false;
                boolean memReloadable = status.module.isReloadable();
                if (memReloadable == diskReloadable) continue;
                LOG.fine("Disk change in reloadable for " + cnb + " from " + memReloadable + " to " + diskReloadable);
                status.module.setReloadable(diskReloadable);
            }
        }

        private void stepCreate(Map<String, FileObject> xmlfiles, Map<String, Map<String, Object>> dirtyprops) throws IOException {
            LOG.fine("ModuleList: stepCreate");
            for (Map.Entry<String, FileObject> entry : xmlfiles.entrySet()) {
                Map<String, Object> statusProps;
                File jarFile;
                String cnb = entry.getKey();
                if (ModuleList.this.statuses.containsKey(cnb)) continue;
                FileObject xmlfile = entry.getValue();
                Map<String, Object> props = dirtyprops.get(cnb);
                if (!cnb.equals(props.get("name"))) {
                    throw new IOException("Code name mismatch");
                }
                String jar = (String)props.get("jar");
                try {
                    jarFile = ModuleList.this.findJarByName(jar, cnb);
                }
                catch (FileNotFoundException fnfe) {
                    File file = new File(fnfe.getMessage());
                    ModuleList.this.ev.log("missingJarFile", new Object[]{file, true});
                    File p = file.getParentFile();
                    File[] arr = p.listFiles();
                    LOG.log(Level.FINE, "Content of {0} is:", p);
                    int cnt = 0;
                    if (arr != null) {
                        for (File f : arr) {
                            LOG.log(Level.FINE, "{0}. = {1}", new Object[]{++cnt, f});
                        }
                        LOG.log(Level.FINE, "There was {0} files", cnt);
                    } else {
                        LOG.fine("Directory does not exist");
                    }
                    dirtyprops.remove(cnb);
                    continue;
                }
                Boolean reloadableB = (Boolean)props.get("reloadable");
                boolean reloadable = reloadableB != null ? reloadableB : false;
                Boolean autoloadB = (Boolean)props.get("autoload");
                boolean autoload = autoloadB != null ? autoloadB : false;
                Boolean eagerB = (Boolean)props.get("eager");
                boolean eager = eagerB != null ? eagerB : false;
                Integer startLevel = (Integer)props.get("startlevel");
                ModuleHistory hist = new ModuleHistory(jar, "created from " + xmlfile);
                Module m = ModuleList.this.createModule(jarFile, hist, reloadable, autoload, eager, startLevel);
                m.addPropertyChangeListener((PropertyChangeListener)this);
                if (props.get("enabled") != null && ((Boolean)props.get("enabled")).booleanValue()) {
                    statusProps = new HashMap<String, Object>(props);
                    statusProps.put("enabled", Boolean.FALSE);
                } else {
                    statusProps = props;
                }
                DiskStatus status = new DiskStatus();
                status.module = m;
                status.file = xmlfile;
                status.setDiskProps(statusProps);
                ModuleList.this.statuses.put(cnb, status);
            }
        }

        private void stepEnable(Map<String, Map<String, Object>> dirtyprops) throws IOException {
            LOG.fine("ModuleList: stepEnable");
            if (LOG.isLoggable(Level.FINEST)) {
                for (Map.Entry<String, Map<String, Object>> e : dirtyprops.entrySet()) {
                    LOG.log(Level.FINEST, "{0} = {1}", new Object[]{e.getKey(), e.getValue()});
                }
            }
            HashSet<Module> toenable = new HashSet<Module>();
            for (Map.Entry<String, Map<String, Object>> entry : dirtyprops.entrySet()) {
                String cnb = entry.getKey();
                Map<String, Object> props = entry.getValue();
                if (props.get("enabled") == null || !((Boolean)props.get("enabled")).booleanValue()) continue;
                DiskStatus status = ModuleList.this.statuses.get(cnb);
                assert (status != null) : cnb;
                if (status.diskProps.get("enabled") != null && ((Boolean)status.diskProps.get("enabled")).booleanValue()) continue;
                if (status.module.isEnabled()) {
                    throw new IllegalStateException("Already enabled: " + status.module);
                }
                toenable.add(status.module);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                for (Module m : toenable) {
                    LOG.log(Level.FINEST, "About to enable {0}", m);
                }
            }
            ModuleList.this.installNew(toenable);
        }

        private void stepDisable(Map<String, Map<String, Object>> dirtyprops) throws IOException {
            LOG.fine("ModuleList: stepDisable");
            HashSet<Module> todisable = new HashSet<Module>();
            for (Map.Entry<String, Map<String, Object>> entry : dirtyprops.entrySet()) {
                String cnb = entry.getKey();
                Map<String, Object> props = entry.getValue();
                if (props.get("enabled") != null && ((Boolean)props.get("enabled")).booleanValue()) continue;
                DiskStatus status = ModuleList.this.statuses.get(cnb);
                assert (status != null) : cnb;
                if (!Boolean.TRUE.equals(status.diskProps.get("enabled"))) continue;
                if (!status.module.isEnabled()) {
                    throw new IllegalStateException("Already disabled: " + status.module);
                }
                todisable.add(status.module);
            }
            if (todisable.isEmpty()) {
                return;
            }
            List reallydisable = ModuleList.this.mgr.simulateDisable(todisable);
            for (Module m : reallydisable) {
                if (m.isAutoload() || m.isEager() || todisable.contains(m)) continue;
                todisable.add(m);
            }
            ModuleList.this.mgr.disable(todisable);
        }

        private void stepDelete(Map<String, FileObject> xmlfiles) throws IOException {
            LOG.fine("ModuleList: stepDelete");
            HashSet<Module> todelete = new HashSet<Module>();
            Iterator<Map.Entry<String, DiskStatus>> it = ModuleList.this.statuses.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, DiskStatus> entry = it.next();
                String cnb = entry.getKey();
                DiskStatus diskStatus = entry.getValue();
                if (xmlfiles.containsKey(cnb)) continue;
                Module m3 = diskStatus.module;
                todelete.add(m3);
                it.remove();
            }
            if (todelete.isEmpty()) {
                return;
            }
            HashSet<Module> todisable = new HashSet<Module>();
            for (Module module : todelete) {
                if (!module.isEnabled() || module.isAutoload() || module.isEager()) continue;
                todisable.add(module);
            }
            List reallydisable = ModuleList.this.mgr.simulateDisable(todisable);
            for (Module m : reallydisable) {
                if (m.isAutoload() || m.isEager() || todisable.contains(m)) continue;
                todisable.add(m);
            }
            ModuleList.this.mgr.disable(todisable);
            Iterator iterator = todelete.iterator();
            while (iterator.hasNext()) {
                Module m;
                m = (Module)iterator.next();
                if (m.isEnabled()) {
                    if (!m.isAutoload() && !m.isEager()) {
                        throw new IllegalStateException("Module " + m + " scheduled for deletion could not be disabled yet was not an autoload nor eager");
                    }
                    ModuleList.this.ev.log("cantDeleteEnabledAutoload", new Object[]{m});
                    iterator.remove();
                    continue;
                }
                ModuleList.this.mgr.delete(m);
            }
        }

        private void stepCheckMisc(Map<String, Map<String, Object>> dirtyprops) {
            LOG.fine("ModuleList: stepCheckMisc");
            String[] toCheck = new String[]{"jar", "autoload", "eager"};
            for (Map.Entry<String, Map<String, Object>> entry : dirtyprops.entrySet()) {
                String cnb = entry.getKey();
                Map<String, Object> props = entry.getValue();
                DiskStatus status = ModuleList.this.statuses.get(cnb);
                assert (status != null) : cnb;
                Map<String, Object> diskProps = status.diskProps;
                for (int i = 0; i < toCheck.length; ++i) {
                    Object inMem;
                    String prop = toCheck[i];
                    Object onDisk = props.get(prop);
                    if (BaseUtilities.compareObjects((Object)onDisk, (Object)(inMem = diskProps.get(prop)))) continue;
                    ModuleList.this.ev.log("miscPropMismatch", new Object[]{status.module, prop, onDisk, inMem});
                }
            }
        }

        private void stepCheckSer(Map<String, FileObject> xmlfiles, Map<String, Map<String, Object>> dirtyprops) {
        }

        private void stepUpdateProps(Map<String, Map<String, Object>> dirtyprops) {
            LOG.fine("ModuleList: stepUpdateProps");
            for (Map.Entry<String, Map<String, Object>> entry : dirtyprops.entrySet()) {
                String cnb = entry.getKey();
                DiskStatus status = ModuleList.this.statuses.get(cnb);
                if (status == null) continue;
                Map<String, Object> props = entry.getValue();
                status.setDiskProps(props);
            }
        }

        private void stepMarkClean() {
            LOG.fine("ModuleList: stepMarkClean");
            for (DiskStatus status : ModuleList.this.statuses.values()) {
                status.dirty = false;
            }
        }
    }

    private class ReadInitial
    implements FileSystem.AtomicAction,
    Runnable {
        private final Set<Module> read;
        private volatile RequestProcessor.Task task;

        public ReadInitial(Set<Module> read) {
            this.read = read;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String[] names;
            if (this.task != null) {
                ModuleList.this.init();
                return;
            }
            this.task = RP.create((Runnable)this);
            this.task.schedule(0);
            Map<String, Map<String, Object>> cache = ModuleList.this.readCache();
            if (cache != null) {
                names = cache.keySet().toArray(new String[cache.size()]);
            } else {
                FileObject[] children = ModuleList.this.folder.getChildren();
                ArrayList<String> arr = new ArrayList<String>(children.length);
                for (FileObject f : children) {
                    if (f.hasExt("ser")) continue;
                    if (f.hasExt("xml")) {
                        String nameDashes = f.getName();
                        char[] badChars = new char[]{'.', '/', '>', '='};
                        for (int j = 0; j < 4; ++j) {
                            if (nameDashes.indexOf(badChars[j]) == -1) continue;
                            throw new IllegalArgumentException("Bad name: " + nameDashes);
                        }
                        String name = nameDashes.replace('-', '.').intern();
                        arr.add(name);
                        continue;
                    }
                    LOG.fine("Strange file encountered in modules folder: " + f);
                }
                names = arr.toArray(new String[0]);
            }
            ModuleList.this.ev.log("modulesFileScanned", new Object[]{names.length});
            XMLReader reader = null;
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                FileObject f = null;
                try {
                    File jarFile;
                    Map<String, Object> props;
                    block22: {
                        Map<String, Object> map = props = cache == null ? null : cache.get(name);
                        if (props == null) {
                            Dependency.create((int)1, (String)name);
                            LOG.log(Level.FINEST, "no cache for {0}", name);
                            f = ModuleList.this.folder.getFileObject(name.replace('.', '-') + ".xml");
                            try (InputStream is = f.getInputStream();){
                                props = ModuleList.this.readStatus(new BufferedInputStream(is), true);
                                if (props != null) break block22;
                                LOG.warning("Note - failed to parse " + f + " the quick way, falling back on XMLReader");
                                is.close();
                                is = f.getInputStream();
                                InputSource src = new InputSource(is);
                                src.setSystemId(f.toURL().toExternalForm());
                                if (reader == null) {
                                    try {
                                        reader = XMLUtil.createXMLReader();
                                    }
                                    catch (SAXException e) {
                                        throw (IllegalStateException)new IllegalStateException(e.toString()).initCause(e);
                                    }
                                    reader.setEntityResolver(ModuleList.this.listener);
                                    reader.setErrorHandler(ModuleList.this.listener);
                                }
                                props = ModuleList.this.readStatus(src, reader);
                            }
                        }
                    }
                    if (!name.equals(props.get("name"))) {
                        throw new IOException("Code name mismatch: " + name + " vs. " + props.get("name"));
                    }
                    Boolean enabledB = (Boolean)props.get("enabled");
                    String jar = (String)props.get("jar");
                    try {
                        jarFile = ModuleList.this.findJarByName(jar, name);
                    }
                    catch (FileNotFoundException fnfe) {
                        ModuleList.this.ev.log("missingJarFile", new Object[]{new File(fnfe.getMessage()), enabledB});
                        if (f == null || Boolean.FALSE.equals(enabledB)) continue;
                        try {
                            f.delete();
                        }
                        catch (IOException ioe) {
                            LOG.log(Level.WARNING, null, ioe);
                        }
                        continue;
                    }
                    ModuleHistory history = new ModuleHistory(jar, "loaded from " + f);
                    Boolean reloadableB = (Boolean)props.get("reloadable");
                    boolean reloadable = reloadableB != null ? reloadableB : false;
                    boolean enabled = enabledB != null ? enabledB : false;
                    Boolean autoloadB = (Boolean)props.get("autoload");
                    boolean autoload = autoloadB != null ? autoloadB : false;
                    Boolean eagerB = (Boolean)props.get("eager");
                    boolean eager = eagerB != null ? eagerB : false;
                    NbInstaller.register(name, props.get("deps"));
                    Integer startLevel = (Integer)props.get("startlevel");
                    Module m = ModuleList.this.createModule(jarFile, history, reloadable, autoload, eager, startLevel);
                    NbInstaller.register(null, null);
                    this.read.add(m);
                    DiskStatus status = new DiskStatus();
                    status.module = m;
                    status.file = f;
                    status.pendingInstall = enabled;
                    status.setDiskProps(props);
                    ModuleList.this.statuses.put(name, status);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error encountered while reading " + name, e);
                }
                ModuleList.this.ev.log("modulesFileProcessed", new Object[]{name});
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("read initial XML files: statuses=" + ModuleList.this.statuses);
            }
            ModuleList.this.ev.log("finishRead", new Object[]{this.read});
            this.task.waitFinished();
        }
    }

    private static final class DiskStatus {
        public Module module;
        public FileObject file;
        public boolean pendingInstall = false;
        public Map<String, Object> diskProps;
        public boolean dirty = false;

        void setDiskProps(Map<String, Object> diskProps) {
            Parameters.notNull((CharSequence)"diskProps", diskProps);
            this.diskProps = diskProps;
        }

        public String toString() {
            return "DiskStatus[module=" + this.module + ",valid=" + this.module.isValid() + ",file=" + this.file + ",dirty=" + this.dirty + ",pendingInstall=" + this.pendingInstall + ",diskProps=" + this.diskProps + "]";
        }
    }
}

