/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.actions.singlefilerun;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.support.actions.singlefilerun.Bundle;
import org.netbeans.modules.groovy.support.actions.singlefilerun.JPDAStart;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class SingleGroovySourceRunActionProvider
implements ActionProvider {
    private static final String GROOVY_EXTENSION = "groovy";
    static final Logger LOG = Logger.getLogger(JPDAStart.class.getPackage().getName());

    public String[] getSupportedActions() {
        return new String[]{"run.single", "debug.single"};
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        FileObject fileObject = SingleGroovySourceRunActionProvider.getGroovyFile(context);
        if (!SingleGroovySourceRunActionProvider.isSingleSourceFile(fileObject)) {
            StatusDisplayer.getDefault().setStatusText(Bundle.CTL_IsInProject(), 1000);
            return;
        }
        InputOutput io = IOProvider.getDefault().getIO(Bundle.CTL_SingleGroovyFile(), false);
        ActionProgress progress = ActionProgress.start((Lookup)context);
        ExecutionDescriptor descriptor = new ExecutionDescriptor().controllable(true).frontWindow(true).preExecution(null).inputOutput(io).postExecution(exitCode -> progress.finished(exitCode == 0));
        JPDAStart jpdaStart = "debug.single".equals(command) ? new JPDAStart(io, fileObject) : null;
        LaunchProcess process = new LaunchProcess(fileObject, jpdaStart);
        ExecutionService exeService = ExecutionService.newService((Callable)process, (ExecutionDescriptor)descriptor, (String)Bundle.CTL_SingleGroovyFile());
        exeService.run();
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        return SingleGroovySourceRunActionProvider.isSingleSourceFile(SingleGroovySourceRunActionProvider.getGroovyFile(context));
    }

    private static boolean isSingleSourceFile(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)fileObject);
        return p == null;
    }

    private static FileObject getGroovyFile(Lookup lookup) {
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            if (!GROOVY_EXTENSION.equalsIgnoreCase(fObj.getExt())) continue;
            return fObj;
        }
        for (FileObject fObj : lookup.lookupAll(FileObject.class)) {
            if (!GROOVY_EXTENSION.equalsIgnoreCase(fObj.getExt())) continue;
            return fObj;
        }
        return null;
    }

    private static class LaunchProcess
    implements Callable<Process> {
        private final FileObject fileObject;
        private final JPDAStart startDebug;

        public LaunchProcess(FileObject file, JPDAStart startDebug) {
            this.fileObject = file;
            this.startDebug = startDebug;
        }

        @Override
        public Process call() throws Exception {
            if (this.startDebug != null) {
                return this.setupProcess(this.startDebug.execute());
            }
            return this.setupProcess(null);
        }

        private Process setupProcess(String port) throws InterruptedException {
            ArrayList<String> commandList = new ArrayList<String>();
            FileObject java = JavaPlatformManager.getDefault().getDefaultPlatform().findTool("java");
            File groovyJar = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-libs-groovy.jar", null, false);
            commandList.add(FileUtil.toFile((FileObject)java).getAbsolutePath());
            if (port != null) {
                commandList.add("-agentlib:jdwp=transport=dt_socket,address=" + port + ",server=n");
            }
            commandList.add("-cp");
            commandList.add(String.join((CharSequence)File.pathSeparator, ".", groovyJar.getAbsolutePath()));
            commandList.add("groovy.ui.GroovyMain");
            commandList.add(this.fileObject.getNameExt());
            ProcessBuilder pb = new ProcessBuilder(commandList);
            pb.directory(FileUtil.toFile((FileObject)this.fileObject.getParent())).redirectErrorStream(true).redirectOutput();
            try {
                return pb.start();
            }
            catch (IOException ex) {
                LOG.info("Could not get InputStream of Run Process");
                return null;
            }
        }
    }
}

