/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Position;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.support.actions.TestMethodUtil;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.gsf.testrunner.ui.spi.ComputeTestMethods;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;

public class GroovyComputeTestMethods
implements ComputeTestMethods {
    public List<TestMethodController.TestMethod> computeTestMethods(Parser.Result parserResult, AtomicBoolean cancel) {
        ArrayList<TestMethodController.TestMethod> result = new ArrayList<TestMethodController.TestMethod>();
        if (cancel.get()) {
            return result;
        }
        FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
        if (!GroovyComputeTestMethods.isTestSource(fileObject)) {
            return result;
        }
        String text = parserResult.getSnapshot().getText().toString();
        ModuleNode moduleNode = TestMethodUtil.extractModuleNode(parserResult);
        if (moduleNode == null) {
            return result;
        }
        for (ClassNode classNode : moduleNode.getClasses()) {
            if (!GroovyComputeTestMethods.isSpecification(classNode.getSuperClass())) continue;
            int classStartLine = classNode.getLineNumber();
            int classStartColumn = classNode.getColumnNumber();
            int classOffset = classStartLine > 0 && classStartColumn > 0 ? GroovyComputeTestMethods.getOffset(text, classStartLine, classStartColumn) : 0;
            for (MethodNode methodNode : classNode.getMethods()) {
                for (AnnotationNode annotation : methodNode.getAnnotations()) {
                    if (!"org.spockframework.runtime.model.FeatureMetadata".equals(annotation.getClassNode().getName())) continue;
                    int startLine = methodNode.getLineNumber();
                    int startColumn = methodNode.getColumnNumber();
                    int endLine = methodNode.getLastLineNumber();
                    int endColumn = methodNode.getLastColumnNumber();
                    if (startLine <= 0 || startColumn <= 0 || endLine <= 0 || endColumn <= 0) continue;
                    int startOffset = GroovyComputeTestMethods.getOffset(text, startLine, startColumn);
                    int endOffset = GroovyComputeTestMethods.getOffset(text, endLine, endColumn);
                    String name = annotation.getMember("name").getText();
                    Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                    boolean isMaven = project != null && project.getLookup().lookup(NbMavenProject.class) != null;
                    result.add(new TestMethodController.TestMethod(isMaven ? classNode.getNameWithoutPackage() : classNode.getName(), (Position)new SimplePosition(classOffset), new SingleMethod(fileObject, name), (Position)new SimplePosition(startOffset), (Position)new SimplePosition(startOffset), (Position)new SimplePosition(endOffset)));
                }
            }
        }
        return result;
    }

    private static boolean isSpecification(ClassNode classNode) {
        String name;
        HashSet<String> visited = new HashSet<String>();
        while (classNode != null && !visited.contains(name = classNode.getName())) {
            if ("spock.lang.Specification".equals(name)) {
                return true;
            }
            visited.add(name);
            classNode = classNode.getSuperClass();
        }
        return false;
    }

    private static boolean isTestSource(FileObject fo) {
        FileObject root;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp != null && (root = cp.findOwnerRoot(fo)) != null) {
            return UnitTestForSourceQuery.findSources((FileObject)root).length > 0;
        }
        return false;
    }

    private static int getOffset(String text, int lineNumber, int columnNumber) {
        int offset = 0;
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length && i < lineNumber; ++i) {
            if (i < lineNumber - 1) {
                offset += lines[i].length() + 1;
                continue;
            }
            offset += columnNumber - 1;
        }
        return Math.min(offset, text.length());
    }

    private static class SimplePosition
    implements Position {
        private final int offset;

        private SimplePosition(int offset) {
            this.offset = offset;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }
}

