/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.ui.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript2.debug.ui.JSUtils;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

public class V8DebugActionsProvider
extends ActionsProviderSupport
implements V8Debugger.Listener {
    private static final Logger LOG = Logger.getLogger(V8DebugActionsProvider.class.getName());
    private static final Set<Object> ACTIONS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_RUN_TO_CURSOR, ActionsManager.ACTION_EVALUATE)));
    private final V8Debugger dbg;
    private final PropertyChangeListener jsFileContextListener = new JSFileContextListener();

    public V8DebugActionsProvider(ContextProvider contextProvider) {
        this.dbg = (V8Debugger)contextProvider.lookupFirst(null, V8Debugger.class);
        this.dbg.addListener((V8Debugger.Listener)this);
        this.notifySuspended(false);
    }

    public void postAction(Object action, Runnable actionPerformedNotifier) {
        if (action == ActionsManager.ACTION_EVALUATE) {
            CodeEvaluator.getDefault().open();
            actionPerformedNotifier.run();
        } else {
            super.postAction(action, actionPerformedNotifier);
        }
    }

    public void doAction(Object action) {
        Line currentLine;
        LOG.fine("doAction(" + action + ")");
        if (action == ActionsManager.ACTION_RUN_TO_CURSOR && (currentLine = JSUtils.getCurrentLine()) != null) {
            FileObject fo = (FileObject)currentLine.getLookup().lookup(FileObject.class);
            long line = currentLine.getLineNumber();
            this.dbg.runTo(fo, line);
        }
    }

    public Set getActions() {
        return ACTIONS;
    }

    public void notifySuspended(boolean suspended) {
        this.setEnabled(ActionsManager.ACTION_EVALUATE, suspended);
        if (suspended) {
            EditorContextDispatcher.getDefault().addPropertyChangeListener("text/javascript", this.jsFileContextListener);
            this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, JSUtils.getCurrentLine() != null);
        } else {
            EditorContextDispatcher.getDefault().removePropertyChangeListener(this.jsFileContextListener);
            this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, false);
        }
    }

    public void notifyCurrentFrame(CallFrame cf) {
    }

    public void notifyFinished() {
        EditorContextDispatcher.getDefault().removePropertyChangeListener(this.jsFileContextListener);
    }

    private class JSFileContextListener
    implements PropertyChangeListener {
        private JSFileContextListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            V8DebugActionsProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, JSUtils.getCurrentLine() != null);
        }
    }
}

